#!C:\Perl\bin\perl
############################################################################################################################
#  JPG Ratings v2b1 (C) Copyright 1998-2002 Joseph Gilland (www.josephgilland.com, admin@josephgilland.com) rate_admin.cgi #  
############################################################################################################################

# Load Config
require "config.db";

# Parse User Input
if ($ENV{'REQUEST_METHOD'} eq 'GET') { $buffer = $ENV{'QUERY_STRING'}; }
else { read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'}); } 

@pairs = split(/&/, $buffer); 

foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $FORM{$name} = $value;
} 

# Set Variables
$action = "$FORM{'action'}";
$product = "$FORM{'product'}";
$deleteid = "$FORM{'deleteid'}";
$password = "$FORM{'password'}";
$id = "$FORM{'id'}";

# Check Password
if ($password eq "") {
 &error("You are not authorized to use the admin section.");
}

unless ($password eq $adminpass) {
 &error("You are not authorized to use the admin section.");
}

# Send admin to requested page
if ($action eq "") {
 &do_main;
}

elsif ($action eq "do_create") {
 &do_create;
}

elsif ($action eq "do_create2") {
 &do_create2;
}

elsif ($action eq "do_delete") {
 &do_delete;
}

elsif ($action eq "do_delete2") {
 &do_delete2;
}

elsif ($action eq "do_viewall") {
 &do_viewall;
}

else {
 &do_main;
}


# Just the main page..
sub do_main {

 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;
  print "</font>\n";
 &footer;

}



# Give Create Form
sub do_create {

 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;
  print "<FORM METHOD=\"POST\">\n";
  print "Product:<br><input type=\"text\" name=\"product\" size=\"20\" value=\"\"><p>\n";
  print "ID Number:<br><input type=\"text\" name=\"id\" size=\"20\" value=\"\"><p>\n";
  print "<input type=\"hidden\" name=\"action\" value=\"do_create2\"><input type=\"hidden\" name=\"password\" value=\"$password\"><p>\n";
  print "<p><input type=\"submit\" value=\"Create\">\&nbsp\;\&nbsp\;<input type=\"reset\" value=\"Clear\"></FORM>\n";
  print "</font>\n";
 &footer;

}



# Create It
sub do_create2 {

 # Check variables again..
 if ($id eq ""){
  &error("There was an error.  You did not specify a rating ID.");
 }

 elsif ($password eq ""){
  &error("There was an error.  You did not specify an admin password.");
 }

 elsif ($product eq ""){
  &error("There was an error.  You did not specify an admin password.");
 }

 # Create the new ID
 open(NEW,">$basedata\\$id.db") || &error("The ID database file failed to be created.");
  print NEW "$id\|$product\|0\|0\|0";
 close(NEW);

 # Create the new IP Log
 open(NEWIP,">$basedata\\ip$id.db") || &error("The IP Log database file failed to be created.");
  print NEWIP "";
 close(NEWIP);

 # Add to the main DB
 open(ADD,">>$basedata\\main.db") || &error("The main database file failed to appended to.");
  print ADD "$id\|$product\n";
 close(ADD);

 # Print Success
 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;
  print "Thank you.  The rating database for $product ($id) was created successfully.<p>\n";
  print "</font>\n";
 &footer;

}



# Give Delete Radio Buttons
sub do_delete {

 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;
  print "<form method=POST>\n";
  print "<input type=hidden name=\"action\" value=\"do_delete2\">\n";
  print "<input type=hidden name=\"password\" value=\"$password\">\n";
  print "<hr width=50% align=left><input type=\"radio\" value=\"none\" name=\"deleteid\" checked>\&nbsp\;Delete None<hr width=50% align=left><P>\n";

  # Open main db and put into radio buttons
  open(LIST, "$basedata\\main.db") || &error("The main database failed to open.");
   @pass = <LIST>;
  close(LIST); 

  foreach $line(@pass) {
    chomp($line);
    ($list_id,$list_product) = split(/\|/,$line);
     print "<hr width=50% align=left><input type=\"radio\" value=\"$list_id\" name=\"deleteid\">\&nbsp\;Delete ID $list_id ($list_product)<hr width=50% align=left><P>\n";

  }
  print "<P><input type=submit value=\"Delete\"> <input type=reset></form>\n";
  print "</font>\n";
 &footer;

}



# Delete It
sub do_delete2 {

 # Check Variables
 if ($deleteid eq "none"){
  &error("No files were deleted.  Rest easy.");
 }

 # Open main db
 open(MAIN,"$basedata\\main.db") || &error("The main database failed to open.");
  @main = <MAIN>;
 close(MAIN);

 # Open main db and delete the ID line from it..
 open(MAIN,">$basedata\\main.db") || &error("The main database failed to open.");
  foreach $mainer (@main) {
   if ($mainer =~ /$deleteid/) {
    print MAIN "";
   }
   else {
    print MAIN "$mainer";
   }
  }
 close(MAIN);

 # Now delete the ID file and IP Log
 if (-e "$basedata\\$deleteid.db") {
  unlink("$basedata\\$deleteid.db") || &error("Delete Failed.");
 }
 else {
  &error("Delete Failed.");
 }

 if (-e "$basedata\\ip$deleteid.db") {
  unlink("$basedata\\ip$deleteid.db") || &error("Delete Failed.");
 }
 else {
  &error("Delete Failed.");
 }

 # Print Success 
 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;
  print "The ID was successfully deleted.<P>\n";
  print "</font>\n";
 &footer;

}



sub do_viewall {

 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;

  # Open main db for viewing
  open(LIST, "$basedata\\main.db");
   @pass = <LIST>;
  close(LIST); 

  foreach $line(@pass) {
    chomp($line);
    ($list_id,$list_product) = split(/\|/,$line);
     print "<hr width=50% align=left><b>ID:</b> $list_id<br><b>Product:</b> $list_product<hr width=50% align=left><P>\n";
  }

  print "</font>\n";
 &footer;

}



sub links {

 print "<a href=\"?action=do_viewall\&password=$password\">View All</a> \| <a href=\"?action=do_create\&password=$password\">Create New</a> \| <a href=\"?action=do_delete\&password=$password\">Delete</a><P>\n";

}



sub header {

  print "Content-type:text/html\n\n";
  open(FILE,"$header") || &error("The header file failed to open.");
  @data = <FILE>;
  close(FILE);
   foreach $line (@data) {
    print "$line";
   }

}



sub footer {

 open(FILE,"$footer") || &error("The footer file failed to open.");
 @data = <FILE>;
 close(FILE);
  foreach $line (@data) {
   print "$line";
  }

}



sub error {

$error = $_[0];

$error = $_[0];
 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  &links;
  print "<b>Error</b> - $error\n";
  print "</font>\n";
 &footer;
exit(0);

exit(0);

}

