#!/usr/bin/perl
############################################################################################################################
#    JPG Ratings v2b1 (C) Copyright 1998-2002 Joseph Gilland (www.josephgilland.com, admin@josephgilland.com) rate.cgi     #  
############################################################################################################################

# Load Config
require "config.db";

# Parse User Input
if ($ENV{'REQUEST_METHOD'} eq 'GET') { $buffer = $ENV{'QUERY_STRING'}; }
else { read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'}); } 

@pairs = split(/&/, $buffer); 

foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $FORM{$name} = $value;
} 

# Check Varaibles
if ($FORM{'rate'} eq ""){
 &error("There was an error.  No rating was chosen.");
}

if ($FORM{'id'} eq ""){
 &error("There was an error.  The webmaster did not specify a rating ID.");
}

unless (length($FORM{'rate'}) >= 1 ){
 &error("The rating chosen was invalid because it is lower than 1.");
}

unless (length($FORM{'rate'}) <= 10 ){
 &error("The rating chosen was invalid because it is higher than 10.");
}

# Set Variables
$remote_addr = "$ENV{'REMOTE_ADDR'}";
$rate = "$FORM{'rate'}";
$id = "$FORM{'id'}";

# Check IP, give rotten message if already rated
open(LIST, "$basedata/ip$id.db");
 @pass = <LIST>;
close(LIST); 

foreach $line(@pass) {
  chomp($line);
  ($list_ip,$list_id) = split(/\|/,$line);
   if ($remote_addr eq "$list_ip" && $id eq "$list_id"){
    &error("You have already rated $id.");
   }
}

# Add IP to log since it isn't there
open(IPLOG, ">>$basedata/ip$id.db") || &error("The IP log failed to open.");
 print IPLOG "$remote_addr\|$id\n";
close(IPLOG);

# Open the ID file, do the math, and close
open(LIST2, "$basedata/$id.db") || &error("The IP log failed to be created.");
 @pass = <LIST2>;
close(LIST2); 

foreach $line(@pass) {
  chomp($line);
  ($list_id,$list_product,$list_rating,$list_count,$list_total) = split(/\|/,$line);

   $list_count++;
   $list_total = $list_total + $rate;
   $newrating = sprintf ("%.2f", ($list_total/$list_count));

    open(LIST3, ">$basedata/$id.db") || &error("The ID database failed to open.");
     print LIST3 "$list_id\|$list_product\|$newrating\|$list_count\|$list_total";
    close(LIST3);

}

# Print success page
&header;
 print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
 print "Thank you for taking the time to rate $list_product.  You gave $list_product a rating of $rate, becoming person number $list_count to rate it.<P>Go <a href=\"$linkback\">back</a> to the ratings page.<P>\n";
 print "</font>\n";
&footer;






sub error {

$error = $_[0];
 &header;
  print "<font face=\"$fontface\" color=\"\#$fontcolor\" size=\"$fontsize\">\n";
  print "<b>Error</b> - $error\n";
  print "</font>\n";
 &footer;
exit(0);

}



sub header {

  print "Content-type:text/html\n\n";
  open(FILE,"$header") || &error("The header file failed to open.");
  @data = <FILE>;
  close(FILE);
   foreach $line (@data) {
    print "$line";
   }

}



sub footer {

 open(FILE,"$footer") || &error("The footer file failed to open.");
 @data = <FILE>;
 close(FILE);
  foreach $line (@data) {
   print "$line";
  }

}
