#!/usr/bin/perl
#####################################################################################
# Copyright IMAX Scripts 2002. All Rights Reserved                                  #
#                                                                                   #
# This program is copyrighted software. It may not be modified, distributed or sold #
# without prior written consent from the copyright holder.                          #
#                                                                                   #
# Any use of this script is entirely at the risk of the user. No liability will be  #
# accepted by the author.                                                           #
#                                                                                   #
######################NOTHING BELOW THIS LINE NEEDS TO BE EDITED#####################

use Fcntl qw/:flock/;
require "configure.pl";
use CGI qw/:standard/;
$CGI::POST_MAX = 100 * 1024;

print header(),
start_html(-title=>'Member Banner Upload',
           -BGCOLOR=>"$bgcolor",
	   -TEXT=>"$textcolor",
	   -LINK=>"$linkcolor",
	   -VLINK=>"$visited_link_color",
	   -ALINK=>"$active_link_color"
          );
$member = param('member');
$password = param('password');
if (param('banner')){process_banner();}else{print_form();}

sub process_banner{
if (!$member){
push(@errors,"<tr><td bgcolor=\"$table_row_color\" align=\"center\">No member name supplied...</td></tr>");
report_errors();
exit(0);
}
open( FILE, "<exchange_data/exchange.dat" )
  || bail("Cannot open exchange database");
flock( FILE, LOCK_SH )
  || bail("Cannot get shared lock on exchange database");
while (<FILE>) {
    chomp;
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
      )
      = split ( /\|/, $_ );
     if($member eq $user_name){
     $found = 1;
     last;
     }


}
close(FILE);

if (!$found){
push(@errors,"<tr><td bgcolor=\"$table_row_color\" align=\"center\">Cannot find member name supplied...</td></tr>");
report_errors();
exit(0);
}
chomp($member_password);
if ($password ne $member_password){
push(@errors,"<tr><td bgcolor=\"$table_row_color\" align=\"center\">Password supplied is incorrect...</td></tr>");
report_errors();
exit(0);
}
$file_name = param('banner');
if (!$file_name){
push(@errors,"<tr><td bgcolor=\"$table_row_color\" align=\"center\">JPEG, GIF or PNG format banners only!</td></tr>");
report_errors();
exit(0);
}

$info = uploadInfo($file_name);
$type = $info->{'Content-Type'};
print "$type<br>";
unless ($type eq "image/jpeg" || $type eq "image/gif" || $type eq "image/png"){
push(@errors,"<tr><td bgcolor=\"$table_row_color\" align=\"center\">JPEG, GIF or PNG format banners only!</td></tr>");
report_errors();
exit(0);
}
if(-e "$path_to_banners$member.jpeg"){unlink("$path_to_banners$member.jpeg");}
if(-e "$path_to_banners$member.gif"){unlink("$path_to_banners$member.gif");}
if(-e "$path_to_banners$member.png"){unlink("$path_to_banners$member.png");}
($image,$suffix) = split(/\//,$type);
open(TEMP, "> $path_to_banners$member.$suffix") || die('Cannot open banner file');
binmode(TEMP);
($bytes_read, $buf);
($total_size) = 0;
while ($bytes_read = read($file_name, $buf, 2048) )
{
$total_size += $bytes_read;
print TEMP $buf;
}
close(TEMP);
if ($total_size > ($max_banner_size * 1024)){
push(@errors,"<tr><td bgcolor=\"$table_row_color\" align=\"center\">Banner size exceeds maximum limit of $max_banner_size Kb</td></tr>");
unlink("$path_to_banners$member.$suffix");
report_errors();
}
open( FILE, "+<exchange_data/exchange.dat" )
  || bail("Cannot open exchange database");
flock( FILE, LOCK_EX )
  || bail("Cannot get exclusive lock on exchange database");
while (<FILE>) {
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $member_password
      )
      = split ( /\|/, $_ );
    if ( $member eq $user_name ) {
       $banner_url = "$url_to_banners$member.$suffix";
       $status = 'pending';
    }
    @values = (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $member_password
    );
    $value = join ( "\|", @values );
    push ( @updated, $value );
}
seek FILE, 0, 0;
truncate FILE, 0;
foreach $updated(@updated){
print( FILE "$updated" );
}
close(FILE);

&head;
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Banner Upload Successfull!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\"><img src=\"$url_to_banners$member.$suffix\" height=\"60\" width=\"468\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">If this is not the banner you want use your back button and try again...</td></tr>";
print "</table>";
&footer;
}

sub print_form {
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Member Banner Upload</td></tr>";
&head;
print "<tr><td>";
print start_multipart_form(),
filefield(-name=>'banner', -size=>45),
submit(-label=>'Upload File'),
hidden(-name=>'member', -default=>["$member"]),
hidden(-name=>'password', -default=>["$password"]),
end_form();
print "</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Please browse to your banner on your local drive...";
print "<br><i>Banners will be displayed at 468x60</i></font></td></tr>";
print "</table>";
print "<br><center><font color=\"$table_header_color\"><i>Updating your banner once it\'s been approved will cause your<br></i></font></center>";
print "<center><font color=\"$table_header_color\"><i>account status to be automatically changed to pending.<br></i></font></center>";
print "<center><font color=\"$table_header_color\"><i>All changes must be approved by the administrator...</i></font></center>";
&footer;
}

sub report_errors{
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">ERROR!</td></tr>";
print "@errors";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Please use your browser\'s back button and fix the above errors...</td></tr>";
print "</table>";
exit(0);
}

sub head{
open(FILE, "exchange_data/header.txt");
@lines = <FILE>;
close(FILE);
foreach $line(@lines){
print "$line";
}
}


sub footer{
open(FILE, "exchange_data/footer.txt");
@lines = <FILE>;
close(FILE);
foreach $line(@lines){
print "$line";
}
}







