#!/usr/bin/perl
#####################################################################################
# Copyright IMAX Scripts 2002. All Rights Reserved                                  #
#                                                                                   #
# This program is copyrighted software. It may not be modified, distributed or sold #
# without prior written consent from the copyright holder.                          #
#                                                                                   #
# Any use of this script is entirely at the risk of the user. No liability will be  #
# accepted by the author.                                                           #
#                                                                                   #
#################################EDIT THESE VARIABLES!###############################
$default_banner_url = 'http://www.yourserver.com/default_banner.gif';
$default_link_url   = 'http://www.default_url.com';
######################NOTHING BELOW THIS LINE NEEDS TO BE EDITED#####################


use Fcntl qw/:flock/;


decode_query();


open( BLOCKED, "<exchange_data/blocked_ip.dat" )
  || bail("Cannot open exchange database");
flock( BLOCKED, LOCK_SH )
  || bail("Cannot get shared lock on blocked IP database");
while(<BLOCKED>){
chomp;
if ($ENV{'REMOTE_ADDR'} eq $_){$blocked = 1; last;}
}
close(BLOCKED);

if($blocked){default_banner();exit(0);}

open( FILE, "+<exchange_data/exchange.dat" )
  || bail("Cannot open exchange database");
flock( FILE, LOCK_EX )
  || bail("Cannot get exclusive lock on exchange database");
while (<FILE>) {
    chomp;
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $password
      )
      = split ( /\|/, $_ );
    if ( $member eq $user_name && $status eq 'approved' ) {
        $found   = 1;
        $credits = ( $credits + $ratio );
        $c_shown++;
        get_banner();
	get_date();
    }
    if ( $member eq $user_name && $status eq 'pending' ) {
        $found = 1;
        $c_shown++;
        $waiting_credits++;
        get_banner();
	get_date();
    }
    @values = (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $password
    );
    $value = join ( "\|", @values );
    push (@updated, $value );
}
seek FILE, 0, 0;
truncate FILE, 0;
foreach $updated(@updated) {
     (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $password
      )
      = split ( /\|/, $updated );
    if ( $user_name eq $shown_member ) {
        $shown++;
        $event = 'member';
    }
   @values = (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $password
    );
    $value = join ( "\|", @values );
    print( FILE "$value\n" );
}
close(FILE);
@updated = ();

if ( !$found ) {
    default_banner();
}
print "Set-Cookie: site_url=$member_url; ; path=/;\n";
print "Set-Cookie: shown_member=$shown_member;\n";
print "Set-Cookie: type_click=$type_click;\n";
print "Location: $shown_banner_url\n\n";
exchange_stats($event);
exit(0);

sub decode_query {
    $buffer = $ENV{'QUERY_STRING'};
    @pairs = split ( /&/, $buffer );
    foreach $pair (@pairs) {
        ($name, $value ) = split ( /=/, $pair );
	$FORM{$name} = $value;
    }
$member = $FORM{'member'};
}

sub exchange_stats {
    open( STATS, "+<exchange_data/exchange_stats.dat" )
      || bail("Cannot open exchange stats database");
    flock( STATS, LOCK_EX )
      || bail("Cannot get exclusive lock on exchange stats database");
      while (<STATS>) {
      ( $default_display, $default_clicks,
	  $ad_display,      $ad_clicks,
	  $member_display,  $member_clicks,
	  $total_displays,  $total_clicks
        )
	   = split ( /\|/, $_ );
        if ( $_[0] eq 'default' ) { $default_display++; }
        if ( $_[0] eq 'ad' )      { $ad_display++; }
        if ( $_[0] eq 'member' )  { $member_display++; }
        $total_displays++;
       @stats =
          ( $default_display, $default_clicks,
	    $ad_display,      $ad_clicks,
	    $member_display,  $member_clicks,
	    $total_displays,  $total_clicks
	  );
        $stats = join ( "\|", @stats );
    }
    seek STATS, 0, 0;
    truncate STATS, 0;
    print( STATS "$stats" );
    close(STATS);
    exit(0);
}

sub default_banner {
    $type_click = 'default';
    print "Set-Cookie: site_url=$default_link_url; ; path=/;\n";
    print "Set-Cookie: shown_member=default; ; path=/;\n";
    print "Set-Cookie: type_click=$type_click;\n";
    print "Location: $default_banner_url\n\n";
    $event = 'default';
    exchange_stats($event);
}

sub bail {
    $type_click = 'default';
    print "Set-Cookie: site_url=$default_link_url; ; path=/;\n";
    print "Set-Cookie: shown_member=default; ; path=/;\n";
    print "Set-Cookie: type_click=$type_click;\n";
    print "Location: $default_banner_url\n\n";
    die $_[0];
}


sub get_date{
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$mon = ($mon + 1);
$year = ($year + 1900);
$last_display = "$mon-$mday-$year";
}

sub get_banner {
    if ( $credits >= 1 && $status eq 'approved' ) {
        open( ROTATION, "+<exchange_data/rotation.dat" )
          || bail("Cannot open rotation database");
        flock( ROTATION, LOCK_EX )
          || bail("Cannot get exclusive lock on rotation database");
        @lines = <ROTATION>;
        chomp(@lines);
        if ( $waiting_credits >= 1 ) {
            $waiting_credits = ( $waiting_credits * $ratio );
            if ( $waiting_credits <= 1 ) {
                $waiting_credits = 1;
            }
	    $credits = $waiting_credits;
            for ( $i = 0 ; $i <= $waiting_credits ; $i++ ) {
                push ( @lines, "$member|$banner_url|$site_url|$cat" );
            }
        $waiting_credits = 0;
	}
        push ( @lines, "$member|$banner_url|$site_url|$cat" );
        $credits = ( $credits - 1 );
        $i       = 0;
        ( $member_name, $shown_banner_url, $member_url, $catagory ) =
          split ( /\|/, $lines[$i] );
        until ( $member_name ne $member && $catagory eq $cat ) {
            $i++;
            ( $member_name, $shown_banner_url, $member_url, $catagory ) =
              split ( /\|/, $lines[$i] );
            if ( $i >= $#lines ) {
                last;
            }
        }
        if ( $member_name eq $member ) {
            $i = 0;
            ( $member_name, $shown_banner_url, $member_url, $category ) =
              split ( /\|/, $lines[$i] );
            until ( $member_name ne $member ) {
                $i++;
                ( $member_name, $shown_banner_url, $member_url, $category ) =
                  split ( /\|/, $lines[$i] );
                if ( $i >= $#lines ) {
                    last;
                }
            }
        }
        if ( $member_name eq $member ) {
            $credits          = ( $credits + 1 );
            $shown_member     = $default_banner_url;
            $shown_banner_url = $default_link_url;
            $event            = 'default';
	    $type_click = 'default';
        }
        else {
          ( $shown_member, $shown_banner_url, $member_url, $category ) =
              split ( /\|/, $lines[$i] );
            splice( @lines, $i, 1 );
	   $type_click = 'member';
        }
        seek ROTATION, 0, 0;
        truncate ROTATION, 0;
        foreach $line (@lines) {
            print( ROTATION "$line\n" );
        }
        close(ROTATION);
        @lines = ();
    }
    else {
        open( ADS, "<exchange_data/ads_$cat.dat" )
          || bail("Cannot open exchange ads database");
        flock( ADS, LOCK_SH )
          || bail("Cannot get shared lock on exchange ads database");
        @ads = <ADS>;
        close(ADS);
        srand;
        $ads = $ads[ rand(@ads) ];
        chomp($ads);
        ( $shown_banner_url, $member_url ) = split ( /\|/, $ads );
        $event = 'ad';
	$type_click = 'ad';
    }
}

