#!/usr/bin/perl
#####################################################################################
# Copyright IMAX Scripts 2002. All Rights Reserved                                  #
#                                                                                   #
# This program is copyrighted software. It may not be modified, distributed or sold #
# without prior written consent from the copyright holder.                          #
#                                                                                   #
# Any use of this script is entirely at the risk of the user. No liability will be  #
# accepted by the author.                                                           #
#                                                                                   #
######################NOTHING BELOW THIS LINE NEEDS TO BE EDITED#####################

use Fcntl qw/:flock/;
require "configure.pl";

decode_querry();

$password = $FORM{'password'};
$event = $FORM{'event'};
$member = $FORM{'member'};
$exchange_ads = $FORM{'exchange_ads'};
$header = $FORM{'header'};
$footer = $FORM{'footer'};
$start_at = $FORM{'start_at'};

print "Content-type: text/html", "\n\n";

if (!$password){log_in();}
if ($password ne $admin_password){pass_error();}
if ($event eq 'Enter Admin'){admin_main();}
if ($event eq 'admin_main'){admin_main();}
if ($event eq 'edit_member'){edit_member();}
if ($event eq 'Update Member Data'){update_member();}
if ($event eq 'Exchange Ad Manager'){display_ad_manager();}
if ($event eq 'Update Ad Category'){ad_manager();}
if ($event eq 'Update Exchange Ads'){update_ads();}
if ($event eq 'Set Exchange Options'){config_exchange();}
if ($event eq 'Reset Global Statistics'){reset_stats();}
if ($event eq 'Save Exchange Options'){save_options();}
if ($event eq 'Delete This Member'){delete_member();}
if ($event eq 'Confirm Delete Member'){confirm_delete();}
if ($event eq 'Return To Main Admin Screen'){admin_main();}
if ($event eq 'Set Header and Footer'){header_footer();}
if ($event eq 'Update Exchange Header'){update_header();}
if ($event eq 'Update Exchange Footer'){update_footer();}
if ($event eq 'Exchange Data Backup'){backup_database();}
if ($event eq 'Restore Exchange Data'){restore_database();}
if ($event eq 'Confirm Restore Database'){confirm_database();}
if ($event eq 'Bulk Email Members'){email_members();}
if ($event eq 'Send Email To Members'){send_email();}
if ($event eq 'Block IP Addresses'){block_ip();}
if ($event eq 'Update Blocked Addresses'){update_ip();}



sub log_in{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<form action=\"admin.cgi\" method=\"GET\">";
print "<table align=\"center\">";
print "<tr><td align=\"center\" bgcolor=\"$table_header_color\" colspan=\"2\">Exchange Administration</td></tr>";
print "<tr><td align=\"center\" bgcolor=\"$table_row_color\">Password:</td>";
print "<td align=\"center\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"password\" size=\"20\" maxlength=\"60\"></td></tr>";
print "<tr><td align=\"center\" bgcolor=\"$table_row_color\" colspan=\"2\"><input type=\"submit\" name=\"event\" value=\"Enter Admin\"></td></tr>";
print "</table>";
print "</form>";
footer();
exit(0);
}

sub admin_main{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\" bgcolor=\"$table_header_color\" width=\"100%\">";
print "<tr><td align=\"center\">Main Administration Screen</td></tr>";
print "</table><br><br>";
open (FILE, "<exchange_data/exchange_stats.dat") || die "Cannot open exchange stats database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange stats database:  $!";
while(<FILE>){
chomp($_);
($default_display, $default_clicks, $ad_display, $ad_clicks, $member_display, $member_clicks, $total_displays, $total_clicks) = split ( /\|/, $_ );
}
close(FILE);
print "<table align=\"center\" bgcolor=\"$table_header_color\" border=\"0\">";
print "<tr><td align=\"center\" colspan=\"8\" bgcolor=\"$table_header_color\">Global Exchange Statistics</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td>Default Displays</td><td>Default Clicks</td><td>Ad Displays</td><td>Ad Clicks</td><td>Member Displays</td><td>Member Clicks</td><td>Total Displays</td><td>Total Clicks</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td>$default_display</td><td>$default_clicks</td><td>$ad_display</td><td>$ad_clicks</td><td>$member_display</td><td>$member_clicks</td><td>$total_displays</td><td>$total_clicks</td></tr>";
print "</table><br>";
$pending_count = 0;
$approved_count = 0;
open (FILE, "<exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange database:  $!";
while(<FILE>){
chomp($_);
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
      ) = split(/\|/,$_);
  if ($status eq 'pending'){
      $pending_count++;
      push(@pending, "<tr align=\"center\" bgcolor=\"$table_row_color\"><td><a href=\"admin.cgi?event=edit_member&member=$user_name&password=$password\">$user_name</a></td><td>$status</td><td>$cat</td><td>$waiting_credits</td><td>$shown</td><td>$c_shown</td><td>$clicks</td><td>$ratio</td></tr>");
     }else{
      $approved_count++;
      push(@accepted, "<tr align=\"center\" bgcolor=\"$table_row_color\"><td><a href=\"admin.cgi?event=edit_member&member=$user_name&password=$password\">$user_name</a></td><td>$status</td><td>$cat</td><td>$last_display</td><td>$shown</td><td>$c_shown</td><td>$clicks</td><td>$ratio</td></tr>");
     }
}
close(FILE);
print "<table align=\"center\" width=\"75%\">";
print "<tr bgcolor=\"$table_header_color\"><td align=\"center\" colspan=\"4\">Exchange Administration Table</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange Ad Manager:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Exchange+Ad+Manager\">Submit";
print "</a></td>";
print "<td bgcolor=\"$table_row_color\">Set Exchange Options:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Set+Exchange+Options\">Submit";
print "</a></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Reset Global Statistics:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Reset+Global+Statistics\">Submit";
print "</a></td>";
print "<td bgcolor=\"$table_row_color\">Set Header and Footer:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Set+Header+and+Footer\">Submit";
print "</a></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange Data Backup:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Exchange+Data+Backup\">Submit";
print "</a></td>";
print "<td bgcolor=\"$table_row_color\">Restore Exchange Data:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Restore+Exchange+Data\">Submit";
print "</a></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Bulk Email Members:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Bulk+Email+Members\">Submit";
print "</a></td>";
print "<td bgcolor=\"$table_row_color\">Block IP Addresses:</td>";
print "<td bgcolor=\"$table_row_color\" align=\"center\"><a href=\"admin.cgi?password=$password\&event=Block+IP+Addresses\">Submit";
print "</a></td></tr>";
print "</table><br>";
if (@pending){
print "<center><font color=\"$table_header_color\"><i>Currently there are $pending_count pending members</i></font></center><br>";
print "<table align=\"center\" bgcolor=\"$table_header_color\" border=\"0\">";
print "<tr><td align=\"center\" colspan=\"8\" bgcolor=\"$table_header_color\">Pending Members Table</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td>Member</td><td>Status</td><td>Category</td><td>Pending Credits</td><td>Network Displays</td><td>Banners Shown</td><td>Clicks to Member</td><td>Credits Per Display</td></tr>";
foreach $pending(@pending){
print "$pending";
}
}
print "</table>";
print "<br>";
print "<center><font color=\"$table_header_color\"><i>Currently there are $approved_count approved and on hold members</i></font></center><br>";
print "<table align=\"center\" bgcolor=\"$table_header_color\" border=\"0\">";
print "<tr><td align=\"center\" colspan=\"8\" bgcolor=\"$table_header_color\">Approved and On Hold Members Table</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td>Member</td><td>Status</td><td>Category</td><td>Last Display</td><td>Network Displays</td><td>Banners Shown</td><td>Clicks to Member</td><td>Credits Per Display</td></tr>";
if(!start_at){$start_at = 0;}
if(!$number_to_show){$number_to_show = 10;}
for($i=$start_at;$i<($start_at + $number_to_show);$i++){
unless($i > $#accepted){
print "$accepted[$i]";
}
}
print "</table>";
if($start_at <= ($#accepted - $number_to_show)){
$i = $i++;
print "<br><div align=\"right\"><a href=\"admin.cgi?password=$password\&event=admin_main\&start_at=$i\">Next Members ---></a></div>";
}
footer();
exit(0);
}

sub edit_member{
open (FILE, "<exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange database:  $!";
while(<FILE>){
chomp($_);
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
      )
      = split ( /\|/, $_ );
if ($user_name eq $member){
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<form action=\"admin.cgi\" method=\"GET\">";
print "<table align=\"center\" cellpadding=\"2\" border=\"0\"><tr align=\"center\" bgcolor=\"$table_header_color\"><td colspan=\"2\">Edit Member Screen</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Site Title:</td>";
print "<td align=\"right\"><input type=\"text\" name=\"site_title\" value=\"$site_title\" size=\"20\" maxlength=\"60\"></td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>User Name:</td>";
print "<td align=\"right\"><input type=\"text\" name=\"user_name\" value=\"$user_name\" size=\"20\" maxlength=\"60\" readonly></td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Site URL:</td>";
print "<td align=\"right\"><input type=\"text\" name=\"site_url\" value=\"$site_url\" size=\"20\" maxlength=\"60\"></td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Banner URL:</td>";
print "<td align=\"right\"><input type=\"text\" name=\"banner_url\" value=\"$banner_url\" size=\"20\" maxlength=\"60\"></td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Status:</td>";
print "<td align=\"right\">";
if ($status eq 'pending'){
print "<select name=\"status\">";
print "<option selected value=\"pending\">Pending";
print "<option value=\"approved\">Approved";
print "<option value=\"on hold\">On Hold";
print "</select>";
}elsif ($status eq 'approved'){
print "<select name=\"status\">";
print "<option selected value=\"approved\">Approved";
print "<option value=\"pending\">Pending";
print "<option value=\"on hold\">On Hold";
print "</select>";
}else{
print "<select name=\"status\">";
print "<option selected value=\"on hold\">On Hold";
print "<option value=\"approved\">Approved";
print "<option value=\"pending\">Pending";
print "</select>";
}
print "</td></tr>";
print "<tr bgcolor=\"$table_row_color\">";
print "<td><font size=\"-1\">Category:</font></td>";
print "<td>";
$i = 0;
for ($i=0; $i<=$#categories; $i++){
if ($categories[$i] eq $cat){
$current_cat = $categories[$i];
splice(@categories, $i, 1);
}
}
print "\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;<input type=\"radio\" checked name=\"cat\" value=\"$current_cat\">$current_cat<br>";
for($i=0; $i<=$#categories; $i++){
print "\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;<input type=\"radio\" name=\"cat\" value=\"$categories[$i]\">$categories[$i]<br>";
}
print "</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Ratio:</td>";
print "<td align=\"right\"><input type=\"text\" name=\"ratio\" value=\"$ratio\" size=\"2\" maxlength=\"2\"></td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Pending Displays:</td>";
print "<td align=\"right\"><input type=\"text\" name=\"waiting_credits\" value=\"$waiting_credits\" size=\"6\" maxlength=\"6\"></td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td align=\"center\" colspan=\"2\"><input type=\"submit\" name=\"event\" value=\"Update Member Data\"></td></tr>";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"hidden\" name=\"member\" value=\"$member\">";
print "</form>";
print "<tr bgcolor=\"$table_row_color\"><td align=\"center\" colspan=\"2\"><form action=\"admin.cgi\" method=\"GET\">";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"hidden\" name=\"member\" value=\"$member\">";
print "<center><input type=\"submit\" name=\"event\" value=\"Delete This Member\"></td></tr>";
print "</table>";
print "<br><br><center><a href=\"mailto:$email\">$email</a></center>";
print "</form>";
print "<br><br><center><font color=\"$table_header_color\">Member Banner</font></center>";
print "<center><a href=\"$site_url\" border=\"0\"><img src=\"$banner_url\"></a></center><br><br>";
last;
}
}
close(FILE);
exit(0);
}

sub update_member{
open (FILE, "<exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange database:  $!";
while(<FILE>){
chomp($_);
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
      )
      = split ( /\|/, $_ );
   if ($member eq $user_name){
       $site_title = $FORM{'site_title'};
       $ratio = $FORM{'ratio'};
       $site_url = $FORM{'site_url'};
       $banner_url = $FORM{'banner_url'};
       $status = $FORM{'status'};
       $cat = $FORM{'cat'};
       $waiting_credits = $FORM{'waiting_credits'};
}
@values = (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
          );

$value = join("\|",@values);
push(@updated, $value);
}
close(FILE);
open(FILE, ">exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_EX ) || die "Cannot get exclusive lock on exchange database:  $!";
foreach $line(@updated){
print (FILE "$line\n");
}
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Member Data Update</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Data for member $member has been updated successfully!</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br></td></tr>";
footer();
exit(0);
}

sub display_ad_manager{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\" cellpadding=\"2\" border=\"0\"><tr align=\"center\" bgcolor=\"$table_header_color\"><td>Choose Ad Category To Edit</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td align=\"center\">";
foreach $category(@categories){
print "<form action=\"admin.cgi\" method=\"GET\">";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"hidden\" name=\"ad_category\" value=\"$category\">";
print "$category Category<br><input type=\"submit\" name=\"event\" value=\"Update Ad Category\"><br>";
print "</form>";
}
print "</td></tr></table>";
footer();
exit(0);
}

sub ad_manager{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
unless(-e "exchange_data/ads_$FORM{'ad_category'}.dat"){
open (FILE, ">exchange_data/ads_$FORM{'ad_category'}.dat") || die "Cannot create new exchange ad category database:  $!";
close(FILE);
}
open (FILE, "<exchange_data/ads_$FORM{'ad_category'}.dat") || die "Cannot open exchange ads database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange ads database:  $!";
@lines = <FILE>;
close(FILE);
print "<table align=\"center\" border=\"0\">";
print "<tr bgcolor=\"$table_header_color\" align=\"center\"><td>Exchange Ad Management</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td><form action=\"admin.cgi\" method=\"GET\">";
print "<textarea name=\"exchange_ads\" wrap=\"virtual\" cols=\"60\" rows=\"10\">";
foreach $line(@lines){
print "$line";
}
print "</textarea><br></td></tr>";
print "<tr bgcolor=\"$table_row_color\" align=\"center\"><td><input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"hidden\" name=\"ad_category\" value=\"$FORM{'ad_category'}\">";
print "<input type=\"submit\" name=\"event\" value=\"Update Exchange Ads\">";
print "</td></tr></table><br>";
print "<center><font color=\"$table_header_color\"><i>List sponsor urls one per line.  Do Not ADD additional blank lines.</i></font></center>";
footer();
exit(0);
}

sub update_ads{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
open (FILE, ">exchange_data/ads_$FORM{'ad_category'}.dat") || die "Cannot open exchange ads database:  $!";
flock( FILE, LOCK_EX ) || die "Cannot get exclusive lock on exchange ads database:  $!";
print (FILE "$exchange_ads");
close(FILE);
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Exchange Ads Updated</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Sponsor urls for $exchange_name updated successfully!</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br></td></tr>";
footer();
exit(0);
}


sub config_exchange{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<form action=\"admin.cgi\" method=\"GET\">";
print "<table align=\"center\">";
print "<tr><td align=\"center\" bgcolor=\"$table_header_color\" colspan=\"2\">Exchange Configuration</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange Name:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"exchange_name\" value=\"$exchange_name\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange URL:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"exchange_url\" value=\"$exchange_url\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange Text:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"exchange_text\" value=\"$exchange_text\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Banner Style:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"side_button\" value=\"$side_button\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Join Credits:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"join_credits\" value=\"$join_credits\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Email Admin:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"email_admin\" value=\"$email_admin\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Admin Email:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"admin_email\" value=\"$admin_email\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Button URL:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"exchange_button_url\" value=\"$exchange_button_url\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange Email:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"exchange_email\" value=\"$exchange_email\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Path To Sendmail:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"path_to_sendmail\" value=\"$path_to_sendmail\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Admin Password:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"admin_password\" value=\"$admin_password\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Number To Show:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"number_to_show\" value=\"$number_to_show\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">URL To Scripts:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"url_to_cgi\" value=\"$url_to_cgi\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Background Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"bgcolor\" value=\"$bgcolor\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Text Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"textcolor\" value=\"$textcolor\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Link Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"linkcolor\" value=\"$linkcolor\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Visted Link Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"visited_link_color\" value=\"$visited_link_color\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Active Link Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"active_link_color\" value=\"$active_link_color\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Table Header Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"table_header_color\" value=\"$table_header_color\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Table Row Color:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"table_row_color\" value=\"$table_row_color\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Exchange Ratio:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"ratio\" value=\"$ratio\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Upload Banners:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"upload_banner\" value=\"$upload_banner\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Max Banner Size:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"max_banner_size\" value=\"$max_banner_size\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">URL To Banners:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"url_to_banners\" value=\"$url_to_banners\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Path To Banners:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"path_to_banners\" value=\"$path_to_banners\" size=\"30\"></td></tr>";
print "<tr><td bgcolor=\"$table_row_color\">Categories:</td>";
print "<td align=\"right\" bgcolor=\"$table_row_color\"><input type=\"text\" name=\"categories\" value=\"@categories\" size=\"30\"></td></tr>";
print "<tr><td align=\"center\" bgcolor=\"$table_row_color\" colspan=\"2\"><input type=\"submit\" name=\"event\" value=\"Save Exchange Options\"></td></tr>";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "</table>";
print "</form>";
footer();
exit(0);
}

sub save_options{
open(FILE, ">configure.pl") || die "Cannot open exchange configuration file:  $!";
flock( FILE, LOCK_EX ) || die "Cannot get exclusive lock on exchange configuration file:  $!";
print FILE ("\$exchange_name = \"$FORM{'exchange_name'}\"\;\n");
print FILE ("\$exchange_url = \"$FORM{'exchange_url'}\"\;\n");
print FILE ("\$exchange_text = \"$FORM{'exchange_text'}\"\;\n");
print FILE ("\$side_button = \"$FORM{'side_button'}\"\;\n");
print FILE ("\$join_credits = \"$FORM{'join_credits'}\"\;\n");
print FILE ("\$email_admin = \"$FORM{'email_admin'}\"\;\n");
$FORM{'admin_email'} =~ s/\@/\\@/;
print FILE ("\$admin_email = \"$FORM{'admin_email'}\"\;\n");
print FILE ("\$exchange_button_url = \"$FORM{'exchange_button_url'}\"\;\n");
$FORM{'exchange_email'} =~ s/\@/\\@/;
print FILE ("\$exchange_email = \"$FORM{'exchange_email'}\"\;\n");
print FILE ("\$path_to_sendmail = \"$FORM{'path_to_sendmail'}\"\;\n");
print FILE ("\$admin_password = \"$FORM{'admin_password'}\"\;\n");
print FILE ("\$number_to_show = \"$FORM{'number_to_show'}\"\;\n");
print FILE ("\$url_to_cgi = \"$FORM{'url_to_cgi'}\"\;\n");
print FILE ("\$bgcolor = \"$FORM{'bgcolor'}\"\;\n");
print FILE ("\$textcolor = \"$FORM{'textcolor'}\"\;\n");
print FILE ("\$linkcolor = \"$FORM{'linkcolor'}\"\;\n");
print FILE ("\$visited_link_color = \"$FORM{'visited_link_color'}\"\;\n");
print FILE ("\$active_link_color = \"$FORM{'active_link_color'}\"\;\n");
print FILE ("\$table_header_color = \"$FORM{'table_header_color'}\"\;\n");
print FILE ("\$table_row_color = \"$FORM{'table_row_color'}\"\;\n");
print FILE ("\$ratio = \"$FORM{'ratio'}\"\;\n");
print FILE ("\$upload_banner = \"$FORM{'upload_banner'}\"\;\n");
print FILE ("\$max_banner_size = \"$FORM{'max_banner_size'}\"\;\n");
print FILE ("\$url_to_banners = \"$FORM{'url_to_banners'}\"\;\n");
print FILE ("\$path_to_banners = \"$FORM{'path_to_banners'}\"\;\n");
@new_categories = split/ /,$FORM{'categories'};
for($i=0;$i<=($#new_categories - 1);$i++){
$new_categories[$i] = "\"$new_categories[$i]\"\,";
}
$new_categories[$#new_categories] = "\"$new_categories[$#new_categories]\"\)\;\n";
print FILE ("\@categories = \(");
foreach $new_categories(@new_categories){
print FILE ("$new_categories");
}
print FILE ("1\;\n");
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Exchange Options Saved</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Options for $exchange_name updated successfully!</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br></td></tr>";
footer();
exit(0);
}

sub reset_stats{
open (STATS, ">exchange_data/exchange_stats.dat") || die "Cannot open exchange statistics database: $!";
flock(STATS, LOCK_EX ) || die "Cannot get exclusive lock on exchange statistics database: $!";
print (STATS "0|0|0|0|0|0|0|0");
close(STATS);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Global Statistics Reset</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Global statistics for $exchange_name reset successfully!</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br></td></tr>";
footer();
exit(0);
}

sub delete_member{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Delete Member Confirmation!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Pushing continue will PERMANENTLY remove member $member from the exchange!<br>Are you sure?</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td align=\"center\"><form action=\"admin.cgi\" method=\"GET\">";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"hidden\" name=\"member\" value=\"$member\">";
print "<center><input type=\"submit\" name=\"event\" value=\"Confirm Delete Member\"></td></tr>";
print "</form>";
print "</table>";
footer();
exit(0);
}

sub confirm_delete{
open (FILE, "<exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange database:  $!";
while(<FILE>){
chomp($_);
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
      )
      = split ( /\|/, $_ );
   if ($member eq $user_name){
       next;
}
@values = (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
          );

$value = join("\|",@values);
push(@updated, $value);
}
close(FILE);
open(FILE, ">exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_EX ) || die "Cannot get exclusive lock on exchange database:  $!";
foreach $line(@updated){
print (FILE "$line\n");
}
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Member Deleted!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Member $member deleted successfully...</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td align=\"center\"><form action=\"admin.cgi\" method=\"GET\">";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<center><input type=\"submit\" name=\"event\" value=\"Return To Main Admin Screen\"></td></tr>";
print "</form>";
print "</table>";
footer();
exit(0);
}

sub pass_error{
unshift(@errors, "<tr><td bgcolor=\"$table_row_color\">Password does not match!</td></tr>");
report_errors();
}

sub email_members{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<form action=\"admin.cgi\" method=\"GET\">";
print "<table  align=\"center\" border=\"0\">";
print "<tr bgcolor=\"$table_header_color\"><td  align=\"center\">Bulk Email To Members</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td>Subject:<input type=\"text\" name=\"subject\" value=\"\" size=\"45\"></td></tr>";
print "<tr bgcolor=\"$table_row_color\" align=\"center\"><td>Type or Paste Email Here</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td>";
print "<textarea name=\"bulk_email\" wrap=\"virtual\" cols=\"80\" rows=\"25\">";
print "</textarea><br></td></tr>";
print "<tr bgcolor=\"$table_row_color\" align=\"center\"><td><input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"submit\" name=\"event\" value=\"Send Email To Members\">";
print "</td></tr></table></form><br>";
footer();
exit(0);
}

sub send_email{
open( FILE, "<exchange_data/exchange.dat" ) || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange database:  $!";
@lines = <FILE>;
close(FILE);
foreach $line(@lines){
    (
        $user_name, $banner_url, $site_url, $status,
        $cat,       $credits,    $clicks,   $waiting_credits,
        $shown,     $c_shown,    $ratio,    $site_title,
        $name,      $email,      $last_display, $member_password
      )
      = split ( /\|/, $line );
open(SENDMAIL, "|$path_to_sendmail -oi -t") || die "Can't Open Sendmail: $!\n";
print SENDMAIL <<"EOF";
From: $exchange_name <$exchange_email>
To: $name <$email>
Subject: $FORM{'subject'}
$FORM{'bulk_email'}
EOF
close(SENDMAIL);
}
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Bulk Email To Members Successfull!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Email sent to $exchange_name members successfully...</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}

sub backup_database{
open (FILE, "<exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange database:  $!";
@lines = <FILE>;
close(FILE);
open (FILE, ">backup/exchange.bak") || die "Cannot create exchange backup database:  $!";
flock( FILE, LOCK_EX ) || die "Cannot get exclusive lock on exchange backup database:  $!";
foreach $line(@lines){
print (FILE "$line");
}
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Exchange Database Saved!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Database for $exchange_name saved successfully...</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}

sub restore_database{
if(-e "backup/exchange.bak"){
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Restore Database Confirmation!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Pushing confirm will overwrite the current exchange database!<br>Are you sure?</td></tr>";
print "<tr bgcolor=\"$table_row_color\"><td align=\"center\"><form action=\"admin.cgi\" method=\"GET\">";
print "<input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<center><input type=\"submit\" name=\"event\" value=\"Confirm Restore Database\"></td></tr>";
print "</form>";
print "</table>";
footer();
exit(0);
}else{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Backup Database Does Not Exist!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">No backup database exits! Cannot Restore...</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}
}

sub confirm_database{
open (FILE, "<backup/exchange.bak") || die "Cannot open exchange database backup:  $!";
flock( FILE, LOCK_SH ) || die "Cannot get shared lock on exchange backup database:  $!";
@lines = <FILE>;
close(FILE);
open (FILE, ">exchange_data/exchange.dat") || die "Cannot open exchange database:  $!";
foreach $line(@lines){
print (FILE "$line");
}
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Exchange Database Restored!</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Database for $exchange_name restored successfully...</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}

sub header_footer{
open (FILE, "<exchange_data/header.txt") || die "Cannot open exchange header:  $!";
@lines = <FILE>;
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\" border=\"0\">";
print "<tr bgcolor=\"$table_header_color\" align=\"center\"><td>Exchange Header Management</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td><form action=\"admin.cgi\" method=\"GET\">";
print "<textarea name=\"header\" wrap=\"virtual\" cols=\"60\" rows=\"10\">";
foreach $line(@lines){
print "$line";
}
print "</textarea><br></td></tr>";
print "<tr bgcolor=\"$table_row_color\" align=\"center\"><td><input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"submit\" name=\"event\" value=\"Update Exchange Header\">";
print "</td></tr></table><br><br>";
print "<center><font color=\"$table_header_color\"><i>Copy and paste your html into these textareas and press update...</i></font></center>";
open (FILE, "<exchange_data/footer.txt") || die "Cannot open exchange footer:  $!";
@lines = <FILE>;
close(FILE);
print "<br><br><table align=\"center\" border=\"0\">";
print "<tr bgcolor=\"$table_header_color\" align=\"center\"><td>Exchange Footer Management</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td><form action=\"admin.cgi\" method=\"GET\">";
print "<textarea name=\"footer\" wrap=\"virtual\" cols=\"60\" rows=\"10\">";
foreach $line(@lines){
print "$line";
}
print "</textarea><br></td></tr>";
print "<tr bgcolor=\"$table_row_color\" align=\"center\"><td><input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"submit\" name=\"event\" value=\"Update Exchange Footer\">";
print "</td></tr></table><br>";
footer();
exit(0);
}

sub update_header{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
open (FILE, ">exchange_data/header.txt") || die "Cannot open exchange header:  $!";
print (FILE "$header");
close(FILE);
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Exchange Header Updated</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Exchange headers for $exchange_name updated successfully!</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}

sub update_footer{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
open (FILE, ">exchange_data/footer.txt") || die "Cannot open exchange footer:  $!";
print (FILE "$footer");
close(FILE);
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Exchange Footer Updated</td></tr>";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Exchange footers for $exchange_name updated successfully!</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}

sub block_ip{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
open (FILE, "<exchange_data/blocked_ip.dat") || die "Cannot open block IPs database:  $!";
@lines = <FILE>;
close(FILE);
print "<table align=\"center\" border=\"0\">";
print "<tr bgcolor=\"$table_header_color\" align=\"center\"><td>Blocked IP Addresses</td></tr>";
print "<tr align=\"center\" bgcolor=\"$table_row_color\"><td><form action=\"admin.cgi\" method=\"GET\">";
print "<textarea name=\"blocked_ip\" wrap=\"virtual\" cols=\"60\" rows=\"10\">";
foreach $line(@lines){
print "$line";
}
print "</textarea><br></td></tr>";
print "<tr bgcolor=\"$table_row_color\" align=\"center\"><td><input type=\"hidden\" name=\"password\" value=\"$password\">";
print "<input type=\"submit\" name=\"event\" value=\"Update Blocked Addresses\">";
print "</td></tr></table><br>";
print "<center><font color=\"$table_header_color\"><i>Put blocked addresses one per line.  Do Not ADD additional blank lines.</i></font></center>";
footer();
exit(0);
}

sub update_ip{
open (FILE, ">exchange_data/blocked_ip.dat") || die "Cannot open block IPs database:  $!";
flock( FILE, LOCK_EX ) || die "Cannot get exclusive lock on blocked IP database:  $!";
print (FILE $FORM{'blocked_ip'});
close(FILE);
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">Blocked IP Addresses Updated!</td></tr>";
print "@errors";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Blocked IP addresses have been updated successfully...</td></tr>";
print "</table>";
print "<br><center><a href=\"admin.cgi?event=admin_main&password=$password\">Continue To Main Admin Screen</a></center><br>";
footer();
exit(0);
}

sub header{
open(FILE, "exchange_data/header.txt");
@lines = <FILE>;
close(FILE);
foreach $line(@lines){
print "$line";
}
}

sub footer{
open(FILE, "exchange_data/footer.txt");
@lines = <FILE>;
close(FILE);
foreach $line(@lines){
print "$line";
}
}

sub decode_querry{
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/, $buffer);
    foreach $pair (@pairs){
      ($name, $value) = split(/=/, $pair);
      $value =~ tr/+/ /;
      $value =~ s/%(..)/pack("C", hex($1))/eg;
      $FORM{$name} = $value;
}
}

sub report_errors{
print "<html><head><title>$exchange_name</title></head>";
print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\" alink=\"$active_link_color\" vlink=\"$visited_link_color\">";
header();
print "<table align=\"center\">";
print "<tr><td bgcolor=\"$table_header_color\" align=\"center\">ERROR!</td></tr>";
print "@errors";
print "<tr><td bgcolor=\"$table_row_color\" align=\"center\">Please use your browser\'s back button and fix the above errors...</td></tr>";
print "</table>";
footer();
exit(0);
}
