#!/usr/bin/perl -w

#
# FAQmanager version 2.2.2
# Copyright (c) Richard Lawrence 1999,2000
# Version 2.2 modifications by Leo B Julius
# 
# This program was originally called FAQman but had to be changed as their
# is a macintosh program of the same name.
#
# web    -=>  http://www.custard.org/~richard/faqmanager
# email  -=>  richard@custard.org
#
#
# Settings:
#
# 1. Searching
#    If you would like case-sensitive searching (ie. searching for "fish"
#    does NOT return results that have "FISH" in them) then change
#    the line below to read:    my $case_sensitive = 1;

my $case_sensitive = 0;

#
# 2. Windows users only!
#    Some people have reported problems with the script running under
#    Windows. If the code cannot find your faq files then you will
#    probably need to uncomment the line below and set it to the correct
#    path. (However, try it first before you do this!)

# chdir("c:/path/to/the/directory/that/contains/the/faq/files";

#
# YOU DO NOT NEED TO EDIT ANYTHING BELOW THIS LINE!
# ============================================================================
#

use strict;
use CGI qw(:param);

my $template_top = "";  # the html at the top of the file
my $template_bot = "";  # the html at the bottom of the file
my @toc_files;  # faqs pointed to by the toc file
my $toc = "";  # the table of contents file
my $file = "";  # the file containing the answers
my $search = "";  # the string to search for
my $version = "2.2.2";  # version number

#
# load_templates
# loads the template files into the program
#

sub load_templates
{
  return unless ( -e "$_[0]");

  my $section = 0;

  $template_bot = "\n<!-- End of content generated by FAQmanager version $version --!>\n";

  open (TEMPLATE, $_[0]) || handle_error("Can't open template file \"$_[0]\"<br>$!");
  while(<TEMPLATE>)
  {
    if (/^\<faqmanager\>/)
    {
      $section = 1; 
    }
    else
    {
      $template_top .= $_ if ($section == 0);
      $template_bot .= $_ if ($section == 1);
    }
  }
  close TEMPLATE;
  
  $template_top .= "\n<!-- Generated by FAQmanager version $version (c) Richard Lawrence 1999,2000 http://www.custard.org/~richard/faqmanager --!>\n\n";  
}

#
# handle_error
# A nicer replacement for die. Deals with any problems
#

sub handle_error
{
  print <<EOF
<html>
<head><title>FAQmanager error</title></head>
<body bgcolor="#ffffff">
<blockquote>
<p>&nbsp;</p>
<p><b><u>FAQmanager error</u></b><br>
An error has occured in the FAQmanager script ...</p>

<p><i><b>$_[0]</b></i></p>

<p>Please check the URL and try again.<br>
If the problem persists, please contact the FAQ maintainer.</p>
<p><font size="-1"><a href="http://www.custard.org/~richard/faqmanager">FAQmanager v$version</a><br>
Copyright <a href="mailto:richard\@custard.org">Richard Lawrence</a> 1999,2000</font></p>
</body></html>  
EOF
;
  exit;
}

#
# load_toc
# Loads the table of contents into the program
#

sub load_toc
{
  open(TOC, "$_[0]") || handle_error("Unable to open table of contents file \"$_[0]\"<br>$!");
  while(<TOC>)
  {
    unless (/^#/)
    {
      chomp;
      my $line = $_;
      $line =~ s/(.+?)\.faq.*/$1/;
      push(@toc_files, $line) if ($line);
    }
  }
  close TOC;
}

#
# display_toc
# Displays the table of contents
#

sub display_toc
{
  my $toc_count;
  my $question_number;

  load_toc("$toc.toc");

  load_templates("$toc-main.ftf");

  print "$template_top<ol>\n";

  foreach $toc_count (@toc_files)
  {
    if (open(FAQ, "$toc_count.faq"))
    {
      my $faq_title = <FAQ>;
      chomp $faq_title;
      print "  <li> $faq_title\n    <p>\n    <ol>\n";

      $question_number = 1;
      while(<FAQ>)
      {
        if (/^::[ ]*(.+)/)
        {
          print "    <li> <a href=\"faqmanager.cgi?file=$toc_count&toc=$toc#q$question_number\">$1</a>\n";
          $question_number++;
        }
      }
      print "  </ol>\n  <p>\n";
      close FAQ;
    }
  }
  
  print "</ol>\n$template_bot";
}

#
# get_title
# given a faq name, return its title
#

sub get_title
{
  return "" if (!$_[0]);
  open (FILE, "$_[0].faq") || handle_error("can't open \"$_[0].faq\" to get title<br>$!");
  $_ = <FILE>;
  chomp;
  return $_;
}


#
# show_answer
# shows an answer to a question
#

sub show_answer
{
  my $back_to = "";
  my $forward_to = "";
  my $back_to_name = "";
  my $forward_to_name = "";
  my $count = 0;
  my $question = 1;
  
  load_toc("$toc.toc");
  load_templates("$toc-answers.ftf");

  # work out which pages are before and after the current one

  while($toc_files[$count])
  {
    if ($toc_files[$count] eq $file)
    {
      $back_to = $toc_files[$count-1] if ($count != 0);
      $forward_to = $toc_files[$count+1] if ($toc_files[$count+1]);
      last;
    }
    $count++
  }

  $back_to_name = get_title($back_to);
  $forward_to_name = get_title($forward_to);
  $forward_to =~ s/\.faq$//;
  $back_to =~ s/\.faq$//;

  print "$template_top";
  
  open (FAQ, "$file.faq") || handle_error("Can't open FAQ file \"$file.faq\"<br>$!");
  $_ = <FAQ>;
  chomp;
  
  print "<div id=\"faqtitle\"><a name=\"top\">$_</a></div>\n<p>";
  print "Back to <a href=\"faqmanager.cgi?file=$back_to&toc=$toc\">$back_to_name</a><br>" if ($back_to);
  print "Forward to <a href=\"faqmanager.cgi?file=$forward_to&toc=$toc\">$forward_to_name</a><br>" if ($forward_to);
  print "<hr><br>\n";
 
  while (<FAQ>)
  {
    if (/^::[ ]*(.+)/)
    {
      print "</p><p>[ <a href=\"faqmanager.cgi?toc=$toc\">Contents</a> | <a href=\"faqmanager.cgi?file=$file&toc=$toc\">Top</a> ]\n<hr>\n<br>\n" unless ($question == 1);
      print "<div id=\"faqquestion\"><a name=\"q$question\">$question. $1</a></div><p id=\"faqanswer\">\n";
      $question++;
    }
    else
    {
      print "$_";
    }
  }
  print "</p><p>[ <a href=\"faqmanager.cgi?toc=$toc\">Contents</a> | <a href=\"faqmanager.cgi?file=$file&toc=$toc\">Top</a> ]\n<hr>\n<br>\n";
  close FAQ;

  print "$template_bot";
}

#
# and_search
# Tests for AND match of ALL search words with case sensitivity option.
# Returns -1 for miss, else index of first match location.
# Word clusters typed between "" marks are tested as a group.
#

sub and_search
{
  my ($string, $substring) = @_;
  my $cluster = "";
  my @words = "";
  my $count = 0;
  my $idx = 0;

  if (!$case_sensitive)
  {
    $string =~ tr/A-Z/a-z/;
    $substring =~ tr/A-Z/a-z/;
  }

  do
  {
    $cluster = "";
    if ($substring =~ s/\"(.*?)\"//o)
    {
      $cluster = $1;
      $cluster =~ tr/ /\xFF/;
      $substring = $substring." ".$cluster;
    }
  }
  until ($cluster eq "");

  $substring =~ s/\s+/ /g;
  @words = split(/ /, $substring);
  $count = @words;
  while (($count > 0) && ($idx != -1))
  {
    $count--;
    $words[$count] =~ tr/\xFF/ /;
    $idx = index($string, $words[$count]);
  }
  return $idx;
}

#
# search_faqs
# Searchs each of the faqs looking for what they want
#

sub search_faqs
{
  my $toc_count;
  my $question_number;
  my $answer = "";
  my $question = "";
  my $htmlsearch = "";
  
  load_toc("$toc.toc");
  load_templates("$toc-search.ftf");
  
  print "$template_top\n";
  $htmlsearch = $search;
  $htmlsearch =~ s/ /&nbsp\;/g;
  print "<p id=\"faqsearch\">Search results for [$htmlsearch]:</p>\n<ol>\n"; 
  
  foreach $toc_count (@toc_files)
  {
    if (open(FAQ, "$toc_count.faq"))
    {
      my $faq_title = <FAQ>;
      chomp $faq_title;
      print "  <li> $faq_title\n    <p>\n    \n";

      $question_number = 0;
      $answer = "";
      $question = "";
      while(<FAQ>)
      {
        if ((/^::[ ]*(.+)/) || eof(FAQ))
        {
          if ($answer && and_search($question.$answer, $search) != -1)
          {
            $answer = "";
            print "&nbsp;&nbsp;&nbsp; $question_number. <a href=\"faqmanager.cgi?file=$toc_count&toc=$toc#q$question_number\">$question</a><br>\n";
          }
          $question = $1;
          $question_number++;
        }
        else
        {
          $answer .= $_;
        }
      }
      print "\n  </p>\n";
      close FAQ;
    }
  }
  print "</ol>\n$template_bot";
}
    

#
# main part of the script
#


$toc = param("toc");
$file = param("file");
$search = param("search");

print "Content-type: text/html\n\n";

# If no toc file is defined, then assume its called faq
$toc = "faq" if (!$toc);

if ($toc && $search)
{
  search_faqs();
}
elsif ($toc && !$file && !$search)
{
  display_toc();
}
elsif ($toc && $file)
{
  show_answer();
}
else
{
  handle_error("An unexpected error occurred! Please report what you did to <a href=\"mailto:richard\@custard.org\">richard\@custard.org</a>");
}

