-- This file should created all the tables you need. 
-- You'll also need to run zip-inserts.sql if you want geo-spatial searching


create table cas_category (
	category_id			int PRIMARY KEY auto_increment,
	name				varchar(64),
	description			text,
	meta_description	text,
	meta_keywords		text,
	header				text,
	footer				text,
	sort_key			varchar(255) unique,
	parent_id			int,
	-- a welcome message template to send to the email address of newly added entries in the directory
	insert_msg			text,
	-- template to let people know their entry has been updated. 
	update_msg			text
);


create table cas_item (
	item_id		    	int PRIMARY KEY auto_increment,
	url					blob,
	title				varchar(100) NOT NULL,
    description    		text,
    points          	int4,						-- a rating, from 0 to 5 (0 is inactive)
	--
	-- Further Contact info, if available. 
	--
	first_names			varchar(32),
	last_name			varchar(32),
	org_name			varchar(200),
    add1				varchar(32),
    add2				varchar(32),
    city				varchar(32),  
    state				varchar(2),
    country				varchar(64),
    postal_code			varchar(16),
	phone				varchar(32),
	fax					varchar(32),
	email				varchar(100),
	-- email address of the person submitting the entry, so we can send them a welcome message
	submitor_email		varchar(100),
	--  date it was suggested by a user
	insert_date			date,
	approval_state		varchar(20) default 'needs_approval',
    approved_date       date,
    approving_user      integer,
    approving_note      blob,

    email_verified_date      date,
    url_verified_date		 date,

    -- used if the item rejected before it reachs
    -- the approved state
    rejected_date        date,
    rejecting_user       integer,
    rejecting_note       blob,
    -- item was active but is now deleted from the system 
    -- (but can sell be revived)
    deleted_date        date,    
    deleting_user       integer,
    deleting_note       blob
);


-- houses suggested updates to the item table that need editor or admin approval 
create table cas_item_suggested_updates (
	item_update_id		int primary key auto_increment,
	date_added			date,
	item_id				int4 not null, -- the id of the item we are suggesting the update for.
	category_id			int4,
	url					blob,
	title				varchar(100) NOT NULL,
    description    		text,
    points          	int4,						-- a rating, from 0 to 5 (0 is inactive)
	--
	-- Further Contact info, if available. 
	--
	first_names	varchar(32),
	last_name	varchar(32),
	org_name	varchar(200),
    add1		varchar(32),
    add2		varchar(32),
    city		varchar(32),  
    state		varchar(2),
    country		varchar(64),
    postal_code	varchar(16),
	phone		varchar(32),
	fax			varchar(32),
	email		varchar(64),
	-- email address of person suggesting the update, so we can let them know it's been done. 
	submitor_email		varchar(100)
);


create table cas_category_item_map (
    category_id        	int NOT NULL,
    item_id             int NOT NULL,
    unique(category_id,item_id)
); 

insert into cas_category (category_id,name,description,sort_key) values
	(0,'Top','This is the top node in the hierarchy. The public should never see it.','aa');

-- Autoincrement means that this becomes "1" on insert, and needs to be manually adjusted
update cas_category set category_id = 0 where category_id = 1;


-- This is used for geo-spatial searching
CREATE TABLE cas_zipcodes (
	zipcode 		varchar(5) NOT NULL unique,
	state_code 		char(2),
	
	 -- strategically the field size in the zipcode file I use. -mls
	city 			varchar(28),
	lon_lat 		int
);


create table cas_country_codes (
	code		char(2) unique,
	name		varchar(64)
);
insert into cas_country_codes values('ad','Andorra');
insert into cas_country_codes values('ae','United Arab Emirates');
insert into cas_country_codes values('af','Afghanistan');
insert into cas_country_codes values('ag','Antigua and Barbuda');
insert into cas_country_codes values('ai','Anguilla');
insert into cas_country_codes values('al','Albania');
insert into cas_country_codes values('am','Armenia');
insert into cas_country_codes values('an','Netherlands Antilles');
insert into cas_country_codes values('ao','Angola');
insert into cas_country_codes values('aq','Antarctica');
insert into cas_country_codes values('ar','Argentina');
insert into cas_country_codes values('as','American Samoa');
insert into cas_country_codes values('at','Austria');
insert into cas_country_codes values('au','Australia');
insert into cas_country_codes values('aw','Aruba');
insert into cas_country_codes values('az','Azerbaijan');
insert into cas_country_codes values('ba','Bosnia and Herzegovina');
insert into cas_country_codes values('bb','Barbados');
insert into cas_country_codes values('bd','Bangladesh');
insert into cas_country_codes values('be','Belgium');
insert into cas_country_codes values('bf','Burkina Faso');
insert into cas_country_codes values('bg','Bulgaria');
insert into cas_country_codes values('bh','Bahrain');
insert into cas_country_codes values('bi','Burundi');
insert into cas_country_codes values('bj','Benin');
insert into cas_country_codes values('bm','Bermuda');
insert into cas_country_codes values('bn','Brunei Darussalam');
insert into cas_country_codes values('bo','Bolivia');
insert into cas_country_codes values('br','Brazil');
insert into cas_country_codes values('bs','Bahamas');
insert into cas_country_codes values('bt','Bhutan');
insert into cas_country_codes values('bv','Bouvet Island');
insert into cas_country_codes values('bw','Botswana');
insert into cas_country_codes values('by','Belarus');
insert into cas_country_codes values('bz','Belize');
insert into cas_country_codes values('ca','Canada');
insert into cas_country_codes values('cc','Cocos (Keeling) Islands');
insert into cas_country_codes values('cf','Central African Republic');
insert into cas_country_codes values('cg','Congo');
insert into cas_country_codes values('ch','Switzerland');
insert into cas_country_codes values('ck','Cook Islands');
insert into cas_country_codes values('cl','Chile');
insert into cas_country_codes values('cm','Cameroon');
insert into cas_country_codes values('cn','China');
insert into cas_country_codes values('co','Colombia');
insert into cas_country_codes values('cr','Costa Rica');
insert into cas_country_codes values('cs','Czechoslovakia (former)');
insert into cas_country_codes values('cu','Cuba');
insert into cas_country_codes values('cv','Cape Verde');
insert into cas_country_codes values('cx','Christmas Island');
insert into cas_country_codes values('cy','Cyprus');
insert into cas_country_codes values('cz','Czech Republic');
insert into cas_country_codes values('de','Germany');
insert into cas_country_codes values('dj','Djibouti');
insert into cas_country_codes values('dk','Denmark');
insert into cas_country_codes values('dm','Dominica');
insert into cas_country_codes values('do','Dominican Republic');
insert into cas_country_codes values('dz','Algeria');
insert into cas_country_codes values('ec','Ecuador');
insert into cas_country_codes values('ee','Estonia');
insert into cas_country_codes values('eg','Egypt');
insert into cas_country_codes values('eh','Western Sahara');
insert into cas_country_codes values('er','Eritrea');
insert into cas_country_codes values('es','Spain');
insert into cas_country_codes values('et','Ethiopia');
insert into cas_country_codes values('fi','Finland');
insert into cas_country_codes values('fj','Fiji');
insert into cas_country_codes values('fk','Falkland Islands (Malvinas)');
insert into cas_country_codes values('fm','Micronesia');
insert into cas_country_codes values('fo','Faroe Islands');
insert into cas_country_codes values('fr','France');
insert into cas_country_codes values('fx','France, Metropolitan');
insert into cas_country_codes values('ga','Gabon');
insert into cas_country_codes values('gb','Great Britain (UK)');
insert into cas_country_codes values('gd','Grenada');
insert into cas_country_codes values('ge','Georgia');
insert into cas_country_codes values('gf','French Guiana');
insert into cas_country_codes values('gh','Ghana');
insert into cas_country_codes values('gi','Gibraltar');
insert into cas_country_codes values('gl','Greenland');
insert into cas_country_codes values('gm','Gambia');
insert into cas_country_codes values('gn','Guinea');
insert into cas_country_codes values('gp','Guadeloupe');
insert into cas_country_codes values('gq','Equatorial Guinea');
insert into cas_country_codes values('gr','Greece');
insert into cas_country_codes values('gs','S. Georgia and S. Sandwich Isls.');
insert into cas_country_codes values('gt','Guatemala');
insert into cas_country_codes values('gu','Guam');
insert into cas_country_codes values('gw','Guinea-Bissau');
insert into cas_country_codes values('gy','Guyana');
insert into cas_country_codes values('hk','Hong Kong');
insert into cas_country_codes values('hm','Heard and McDonald Islands');
insert into cas_country_codes values('hn','Honduras');
insert into cas_country_codes values('hr','Croatia (Hrvatska)');
insert into cas_country_codes values('ht','Haiti');
insert into cas_country_codes values('hu','Hungary');
insert into cas_country_codes values('id','Indonesia');
insert into cas_country_codes values('ie','Ireland');
insert into cas_country_codes values('il','Israel');
insert into cas_country_codes values('in','India');
insert into cas_country_codes values('io','British Indian Ocean Territory');
insert into cas_country_codes values('iq','Iraq');
insert into cas_country_codes values('ir','Iran');
insert into cas_country_codes values('is','Iceland');
insert into cas_country_codes values('it','Italy');
insert into cas_country_codes values('jm','Jamaica');
insert into cas_country_codes values('jo','Jordan');
insert into cas_country_codes values('jp','Japan');
insert into cas_country_codes values('ke','Kenya');
insert into cas_country_codes values('kg','Kyrgyzstan');
insert into cas_country_codes values('kh','Cambodia');
insert into cas_country_codes values('ki','Kiribati');
insert into cas_country_codes values('km','Comoros');
insert into cas_country_codes values('kn','Saint Kitts and Nevis');
insert into cas_country_codes values('kp','Korea (North)');
insert into cas_country_codes values('kr','Korea (South)');
insert into cas_country_codes values('kw','Kuwait');
insert into cas_country_codes values('ky','Cayman Islands');
insert into cas_country_codes values('kz','Kazakhstan');
insert into cas_country_codes values('la','Laos');
insert into cas_country_codes values('lb','Lebanon');
insert into cas_country_codes values('lc','Saint Lucia');
insert into cas_country_codes values('li','Liechtenstein');
insert into cas_country_codes values('lk','Sri Lanka');
insert into cas_country_codes values('lr','Liberia');
insert into cas_country_codes values('ls','Lesotho');
insert into cas_country_codes values('lt','Lithuania');
insert into cas_country_codes values('lu','Luxembourg');
insert into cas_country_codes values('lv','Latvia');
insert into cas_country_codes values('ly','Libya');
insert into cas_country_codes values('ma','Morocco');
insert into cas_country_codes values('mc','Monaco');
insert into cas_country_codes values('md','Moldova');
insert into cas_country_codes values('mg','Madagascar');
insert into cas_country_codes values('mh','Marshall Islands');
insert into cas_country_codes values('mk','Macedonia');
insert into cas_country_codes values('ml','Mali');
insert into cas_country_codes values('mm','Myanmar');
insert into cas_country_codes values('mn','Mongolia');
insert into cas_country_codes values('mo','Macau');
insert into cas_country_codes values('mp','Northern Mariana Islands');
insert into cas_country_codes values('mq','Martinique');
insert into cas_country_codes values('mr','Mauritania');
insert into cas_country_codes values('ms','Montserrat');
insert into cas_country_codes values('mt','Malta');
insert into cas_country_codes values('mu','Mauritius');
insert into cas_country_codes values('mv','Maldives');
insert into cas_country_codes values('mw','Malawi');
insert into cas_country_codes values('mx','Mexico');
insert into cas_country_codes values('my','Malaysia');
insert into cas_country_codes values('mz','Mozambique');
insert into cas_country_codes values('na','Namibia');
insert into cas_country_codes values('nc','New Caledonia');
insert into cas_country_codes values('ne','Niger');
insert into cas_country_codes values('nf','Norfolk Island');
insert into cas_country_codes values('ng','Nigeria');
insert into cas_country_codes values('ni','Nicaragua');
insert into cas_country_codes values('nl','Netherlands');
insert into cas_country_codes values('no','Norway');
insert into cas_country_codes values('np','Nepal');
insert into cas_country_codes values('nr','Nauru');
insert into cas_country_codes values('nt','Neutral Zone');
insert into cas_country_codes values('nu','Niue');
insert into cas_country_codes values('nz','New Zealand (Aotearoa)');
insert into cas_country_codes values('om','Oman');
insert into cas_country_codes values('pa','Panama');
insert into cas_country_codes values('pe','Peru');
insert into cas_country_codes values('pf','French Polynesia');
insert into cas_country_codes values('pg','Papua New Guinea');
insert into cas_country_codes values('ph','Philippines');
insert into cas_country_codes values('pk','Pakistan');
insert into cas_country_codes values('pl','Poland');
insert into cas_country_codes values('pm','St. Pierre and Miquelon');
insert into cas_country_codes values('pn','Pitcairn');
insert into cas_country_codes values('pr','Puerto Rico');
insert into cas_country_codes values('pt','Portugal');
insert into cas_country_codes values('pw','Palau');
insert into cas_country_codes values('py','Paraguay');
insert into cas_country_codes values('qa','Qatar');
insert into cas_country_codes values('re','Reunion');
insert into cas_country_codes values('ro','Romania');
insert into cas_country_codes values('ru','Russian Federation');
insert into cas_country_codes values('rw','Rwanda');
insert into cas_country_codes values('sa','Saudi Arabia');
insert into cas_country_codes values('sb','Solomon Islands');
insert into cas_country_codes values('sc','Seychelles');
insert into cas_country_codes values('sd','Sudan');
insert into cas_country_codes values('se','Sweden');
insert into cas_country_codes values('sg','Singapore');
insert into cas_country_codes values('sh','St. Helena');
insert into cas_country_codes values('si','Slovenia');
insert into cas_country_codes values('sj','Svalbard and Jan Mayen Islands');
insert into cas_country_codes values('sk','Slovak Republic');
insert into cas_country_codes values('sl','Sierra Leone');
insert into cas_country_codes values('sm','San Marino');
insert into cas_country_codes values('sn','Senegal');
insert into cas_country_codes values('so','Somalia');
insert into cas_country_codes values('sr','Suriname');
insert into cas_country_codes values('st','Sao Tome and Principe');
insert into cas_country_codes values('su','USSR (former)');
insert into cas_country_codes values('sv','El Salvador');
insert into cas_country_codes values('sy','Syria');
insert into cas_country_codes values('sz','Swaziland');
insert into cas_country_codes values('tc','Turks and Caicos Islands');
insert into cas_country_codes values('td','Chad');
insert into cas_country_codes values('tf','French Southern Territories');
insert into cas_country_codes values('tg','Togo');
insert into cas_country_codes values('th','Thailand');
insert into cas_country_codes values('tj','Tajikistan');
insert into cas_country_codes values('tk','Tokelau');
insert into cas_country_codes values('tm','Turkmenistan');
insert into cas_country_codes values('tn','Tunisia');
insert into cas_country_codes values('to','Tonga');
insert into cas_country_codes values('tp','East Timor');
insert into cas_country_codes values('tr','Turkey');
insert into cas_country_codes values('tt','Trinidad and Tobago');
insert into cas_country_codes values('tv','Tuvalu');
insert into cas_country_codes values('tw','Taiwan');
insert into cas_country_codes values('tz','Tanzania');
insert into cas_country_codes values('ua','Ukraine');
insert into cas_country_codes values('ug','Uganda');
insert into cas_country_codes values('uk','United Kingdom');
insert into cas_country_codes values('um','US Minor Outlying Islands');
insert into cas_country_codes values('us','United States');
insert into cas_country_codes values('uy','Uruguay');
insert into cas_country_codes values('uz','Uzbekistan');
insert into cas_country_codes values('va','Vatican City State (Holy See)');
insert into cas_country_codes values('vc','Saint Vincent and the Grenadines');
insert into cas_country_codes values('ve','Venezuela');
insert into cas_country_codes values('vg','Virgin Islands (British)');
insert into cas_country_codes values('vi','Virgin Islands (U.S.)');
insert into cas_country_codes values('vn','Viet Nam');
insert into cas_country_codes values('vu','Vanuatu');
insert into cas_country_codes values('wf','Wallis and Futuna Islands');
insert into cas_country_codes values('ws','Samoa');
insert into cas_country_codes values('ye','Yemen');
insert into cas_country_codes values('yt','Mayotte');
insert into cas_country_codes values('yu','Yugoslavia');
insert into cas_country_codes values('za','South Africa');
insert into cas_country_codes values('zm','Zambia');
insert into cas_country_codes values('zr','Zaire');
insert into cas_country_codes values('zw','Zimbabwe');
update cas_country_codes set code  = upper(code); 


create table cas_state_codes (
	code		char(2) unique,
	name		varchar(64)
);

insert into cas_state_codes values('al','Alabama');
insert into cas_state_codes values('ak','Alaska');
insert into cas_state_codes values('as','American Samoa');
insert into cas_state_codes values('az','Arizona');
insert into cas_state_codes values('ar','Arkansas');
insert into cas_state_codes values('ca','California');
insert into cas_state_codes values('co','Colorado');
insert into cas_state_codes values('ct','Connecticut');
insert into cas_state_codes values('de','Delaware');
insert into cas_state_codes values('dc','District Of Columbia');
insert into cas_state_codes values('fm','Federated States Of Micronesia');
insert into cas_state_codes values('fl','Florida');
insert into cas_state_codes values('ga','Georgia');
insert into cas_state_codes values('gu','Guam');
insert into cas_state_codes values('hi','Hawaii');
insert into cas_state_codes values('id','Idaho');
insert into cas_state_codes values('il','Illinois');
insert into cas_state_codes values('in','Indiana');
insert into cas_state_codes values('ia','Iowa');
insert into cas_state_codes values('ks','Kansas');
insert into cas_state_codes values('ky','Kentucky');
insert into cas_state_codes values('la','Louisiana');
insert into cas_state_codes values('me','Maine');
insert into cas_state_codes values('mh','Marshall Islands');
insert into cas_state_codes values('md','Maryland');
insert into cas_state_codes values('ma','Massachusetts');
insert into cas_state_codes values('mi','Michigan');
insert into cas_state_codes values('mn','Minnesota');
insert into cas_state_codes values('ms','Mississippi');
insert into cas_state_codes values('mo','Missouri');
insert into cas_state_codes values('mt','Montana');
insert into cas_state_codes values('ne','Nebraska');
insert into cas_state_codes values('nv','Nevada');
insert into cas_state_codes values('nh','New Hampshire');
insert into cas_state_codes values('nj','New Jersey');
insert into cas_state_codes values('nm','New Mexico');
insert into cas_state_codes values('ny','New York');
insert into cas_state_codes values('nc','North Carolina');
insert into cas_state_codes values('nd','North Dakota');
insert into cas_state_codes values('mp','Northern Mariana Islands');
insert into cas_state_codes values('oh','Ohio');
insert into cas_state_codes values('ok','Oklahoma');
insert into cas_state_codes values('or','Oregon');
insert into cas_state_codes values('pw','Palau');
insert into cas_state_codes values('pa','Pennsylvania');
insert into cas_state_codes values('pr','Puerto Rico');
insert into cas_state_codes values('ri','Rhode Island');
insert into cas_state_codes values('sc','South Carolina');
insert into cas_state_codes values('sd','South Dakota');
insert into cas_state_codes values('tn','Tennessee');
insert into cas_state_codes values('tx','Texas');
insert into cas_state_codes values('ut','Utah');
insert into cas_state_codes values('vt','Vermont');
insert into cas_state_codes values('vi','Virgin Islands');
insert into cas_state_codes values('va','Virginia');
insert into cas_state_codes values('wa','Washington');
insert into cas_state_codes values('wv','West Virginia');
insert into cas_state_codes values('wi','Wisconsin');
insert into cas_state_codes values('wy','Wyoming');
insert into cas_state_codes values('aa','Armed Forces Americas');
insert into cas_state_codes values('ae','Armed Forces');
insert into cas_state_codes values('ap','Armed Forces Pacific');

update cas_state_codes set code  = upper(code);


-- to allow links to other categories and items in the directory
create table cas_link (
	link_id				int primary key auto_increment,
	from_cat_id 		int4 NOT NULL,
	to_cat_id 			int4,
	to_item_id  		int4,
	name 				varchar(64),
	active  			bool NOT NULL default 't'
); 


-- allows links to related categories
create table cas_related_category (
	from_cat_id			int4 NOT NULL,
	to_cat_id			int4 NOT NULL,
	unique(to_cat_id,from_cat_id)
);   


create table cas_users (
    user_id            int primary key auto_increment,
    first_names        varchar(100) not null,
    last_name        varchar(100) not null,
    screen_name        varchar(100),
    constraint cas_users_screen_name_unique unique(screen_name),
    email            varchar(100) not null unique,
    email_bouncing_p    char(1) default 'f',
    password        varchar(30) not null,
    -- set when user reappears at site
    last_visit        date,
    -- this is what most pages query against (since the above column
    -- will only be a few minutes old for most pages in a session)
    second_to_last_visit    date,
    -- how many times this person has visited
    n_sessions        integer default 1,
    registration_date    date,
    registration_ip      char(16),
    -- state the user is in in the registration process
    user_state        varchar(100),
    -- admin approval system
    approved_date           date,
    approving_user          integer,
    approving_note           blob,
    -- email verification system
    email_verified_date      date,
    -- used if the user rejected before they reach 
    -- the authorized state
    rejected_date        date,
    rejecting_user        integer,
    rejecting_note          blob,
    -- user was active but is now deleted from the system 
    -- may be revived
    deleted_date        date,    
    deleting_user       integer,
    deleting_note          blob,
    -- user was active and now not allowed into the system
    banned_date        date,
    -- who and why this person was banned
    banning_user        integer,
    banning_note        blob,
    bio            blob,
    role		   varchar(100) default 'user'
);

--- users who are not deleted or banned

 
create table cas_users_preferences (
    user_id            integer primary key,
    prefer_text_only_p    char(1) default 'f',
    -- an ISO 639 language code (in lowercase)
    language_preference    char(2) default 'en',
    dont_spam_me_p        char(1) default 'f',
    email_type        varchar(64)
);


CREATE TABLE cas_user_item_map (
        user_id integer not null,
        item_id integer not null,
        rating integer, 
        comment text,
	comment_add_date date,
        unique(user_id,item_id)
);


-- explains which editors go with which category. 
-- categories may have multiple editors
create table cas_category_editor_map (
	category_id				int4, -- refers to category table
	editor_id				int4, -- refers to users table 
	unique (category_id,editor_id),
	-- which admin approved this relationship? 
    approved_date           date,
    approving_user          integer
);


-- holds session information for users
CREATE TABLE cas_user_session (
        session_id varchar(50) primary key,
        user_id int4,
        real_user_id int4,
        remote_ip char(16),
        start_time timestamp,
        mod_time timestamp,
        end_time timestamp
);
create index session_user_id on cas_user_session(user_id);

-- IMPORTANT: personalize the below information or you've got a security risk!
insert into cas_users
    (user_id,first_names, last_name, email, password, user_state,role)
   values 
    (1,'Simon', 'Lindsay', 'simon@iseek.ws', 'simon', 'authorized','admin');

-- Autoincrement means that this becomes "1" on insert, and needs to be manually adjusted
-- update cas_users set user_id = 0 where user_id = 1;

-- if you want to get mail from the system when people suggest updates
--  set the below preference to 'f'
insert into cas_users_preferences (user_id,dont_spam_me_p) values (1,'t');
