#!/usr/bin/perl 
# Copyright (c) 2001 Mark Stosberg <mark@stosberg.com>
# Portions originally by Chris Hardie, <chris@summersault.com>
# Licensed under the the GNU GPL, available here: http://www.gnu.org/copyleft/gpl.html
# $Revision: 1.6 $
# This is here to satisfy CPAN, it shouldn't be considered otherwise meaningful. 
$VERSION = substr(q$Revision: 1.6 $, 10); 

=pod

=head1 NAME

  Cascade::Auth - Authentication related functions for Cascade 

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

package Cascade;
use strict;


# sets a cookie with the common defaults for all the needed domains 
# returns a reference to an array of cookies, so that pages can set them as they like 
sub create_cookie {
	my $sid = shift;
	my $exp = shift || $CFG{DEFAULT_COOKIE_EXP_TIME};
	my @cookies;
	foreach my $domain (@{ $CFG{COOKIE_DOMAINS} }) {
		push @cookies, CGI::cookie(
					  -name=>$CFG{SESSION_COOKIE_NAME},
					  -value=>$sid,
					  -domain=>".$domain",
					  -path=>"/",
					  -expires=>$exp
					  );
	}
	return \@cookies;
}


sub create_session {
  
  my %session;
  require Digest::SHA1;
  import Digest::SHA1 qw(sha1_base64);
  
  # this will always be 27 characters long, plus extra characters for URL encoding, if needed. 
  $session{session_id} = sha1_base64( time, $$, $ENV{REMOTE_ADDR}.$ENV{REMOTE_PORT} );
  # make it URL friendly
  $session{session_id} =~ tr|+/=|-_.|; 
  
   my $rv = $DBH->do("
   	INSERT into cas_user_session values (
      '$session{session_id}',
      null,
      null,
      ".$DBH->quote($ENV{REMOTE_ADDR}).", 
      CURRENT_TIMESTAMP,
      CURRENT_TIMESTAMP,
      null)");
    
    return %session;

}

sub validate_session {
# also populates %session

   # Also, force them to have this role when validating the session
   # XXX notice some functions that editors will need eventually are in the admin module
   
   my ($role,$user_id_req);
   if ($CFG{RM_AUTH}->{$FORM{rm}}) {
     $role = $CFG{RM_AUTH}->{$FORM{rm}};
     $user_id_req = 1;
   }

  my %session;
  if ($session{session_id} = $FORM{$CFG{SESSION_COOKIE_NAME}} || CGI::cookie($CFG{SESSION_COOKIE_NAME})) { 
     update_mod_time($session{session_id});
  }
   else {
     %session = create_session();
   }

   %session = &populate_session(\%session);

  
  if (($session{user_id}) && (!$session{valid_idle})) { 
      
      %session = &remove_userid_from_session(\%session);
      
# In Cascade, we will mostly be setting "Permanent Cookies"...which is my excuse for not dealing with this
# right now
#      my $title = "You Have Been Logged Out";
#      $FORM{return_url} ||= $ENV{SCRIPT_NAME};
#      my $message = qq { For your security, you have been logged out automatically!  You must 
#        <a href="$CFG{SITE_URI}/register/index.cgi?return_url=$FORM{return_url}">login again</a> to continue using 
#        this service. We apologize for any inconvenience. };

#      &error(title=>$title, msg=>$message);
      
  }

  if ( # if they must be logged in, check that
  	   ($user_id_req == 1) && (!$session{user_id})

  	# if they must be a certain role, check that
	or (($role eq 'users') && 
	      ($session{role} ne 'user' and $session{role} ne 'editor' and $session{role} ne 'admin'))
  	or (($role eq 'editor') && ($session{role} ne 'editor' and $session{role} ne 'admin'))
	or (($role eq 'admin') && ($session{role} ne 'admin'))    
  	) {
     return undef;
  }

  return %session;

}

# this populates the session hash, it doesn't update the database
sub populate_session {
  my $session = shift;
  my $sref = {};
  
  # we'll refer to the hash values by reference to be just a bit faster; 
  # XXX note we are using months, not minutes, as similar apps at Summersault do. -mls
  if ($CFG{DRIVER} eq "mysql") {
    $sref = $DBH->selectrow_hashref("
    SELECT * , 
     (mod_time > (DATE_SUB(CURRENT_TIMESTAMP, interval '$CFG{SESSION_EXPIRE_TIME}' month))) as valid_idle
      FROM cas_user_session
    	WHERE session_id = '".$session->{session_id}."'");
  } else {
    $sref = $DBH->selectrow_hashref("
    SELECT * , 
     (mod_time > (CURRENT_TIMESTAMP + '$CFG{SESSION_EXPIRE_TIME} months ago'::interval) ) as valid_idle
      FROM cas_user_session
    	WHERE session_id = '".$session->{session_id}."'");
  }
  
  # If they have a user_id, we add in in some extra info to the mix:
  my $user;
  if ($sref->{user_id}) {
     $DBH->{PrintError} = 1;
     my $full = ($CFG{DRIVER} eq 'mysql') 
       ? "CONCAT(first_names,' ',last_name)" 
	 : "first_names || ' ' || last_name";
     $user = $DBH->selectrow_hashref("
	 	SELECT 
	 		first_names, 
	 		last_name, 
	 		$full as full_name,
	 		email,
	 		role,
	 		CURRENT_DATE as todays_date
  			FROM cas_users
			WHERE user_id = ".$sref->{user_id});
  }    
  
  # preserve the old values as default, and add the new ones. 
  $session = { %$session, %$sref } if $sref;
  $session = { %$session, %$user } if $user;
  
  # Make an extra variable to make working with roles easier with HTML::Template
  #use Data::Dumper; warn Dumper($session);
  $session->{"role_". $session->{role} } = 1;
  # If you are an admin, your are also a user and editor, and so forth. 
  $session->{"role_user"}++ if $session->{role} eq 'admin';
  $session->{"role_user"}++ if $session->{role} eq 'editor';
  $session->{"role_editor"}++ if $session->{role} eq 'admin';
  
  return %$session;
}

sub update_last_login {
   my $user_id = shift; 
   return $DBH->do("
  	UPDATE cas_users
    	SET last_visit = CURRENT_DATE
    	WHERE user_id = $user_id");
}

sub update_mod_time {
   my $sid = shift;
   return $DBH->do(" UPDATE cas_user_session
			SET mod_time = CURRENT_TIMESTAMP
                        WHERE session_id = '$sid'");
}

sub add_userid_to_session {
# by manipulating the reference, we save copying the hash a couple times, and make shorter code, too 
  my ($ses,$uid) = @_;

  if ($CFG{DRIVER} eq "mysql") {
    my $rv = $DBH->do("
    	UPDATE cas_user_session 
      	SET user_id = $uid, 
    		real_user_id = $uid,
    		end_time = 0
    	WHERE session_id = '".$ses->{session_id}."'" );
  } else {
    my $rv = $DBH->do("
    	UPDATE cas_user_session 
       	SET user_id = $uid, 
      		real_user_id = $uid,
      		end_time = null
      	WHERE session_id = '".$ses->{session_id}."'" );
  }

  $ses->{user_id} = $uid; 

  # nothing to return -- the session passed in by reference has been modified. 	
}

sub remove_userid_from_session {
   my $ses = shift;   
  
  my $rv = $DBH->do("
  	UPDATE cas_user_session 
    	SET user_id = null, 
    		real_user_id = null,
    		end_time = CURRENT_TIMESTAMP
    	WHERE session_id = '".$ses->{session_id}."'" );

  $ses->{user_id} = $ses->{real_user_id} = '';
    # nothing to return -- the session passed in by reference has been modified. 	
}

sub login_as_user {
   my ($user_id,$ses_id) = @_;
 	
   $DBH->{RaiseError} = 1;
   eval {
      $DBH->do("UPDATE cas_user_session
      	SET user_id = $user_id
      	WHERE session_id = '$ses_id'");
   };
	
   $@ ? return undef : print redirect(-url=>"$CFG{CASCADE_CGI}") && exit;
}

1;
__END__

=pod

=head1 AUTHOR

Copyright (C) 2000-2001 Mark Stosberg <mark@stosberg.com>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
 
Address bug reports and comments to: mark@stosberg.com.  When sending
bug reports, please provide the version of Cascade, the version of
Perl, the name and version of your Web server, the name and version of
the operating system you are using, and the name and version of the
database you are using.  If the problem is even remotely browser
dependent, please provide information about the affected browers as
well.

=head1 SEE ALSO

perl(1).

=cut
