#!/usr/bin/perl 
# Copyright (c) 2001 Mark Stosberg <mark@stosberg.com>
# Licensed under the the GNU GPL, available here: http://www.gnu.org/copyleft/gpl.html

# $Header: /cvsroot/cascade/cascade/lib/Cascade/Admin.pm,v 1.8 2001/09/29 16:23:40 markjugg Exp $

# This is here to satisfy CPAN, it shouldn't be considered otherwise meaningful. 
$VERSION = substr(q$Revision: 1.8 $, 10); 
=pod

=head1 NAME

  Cascade::Admin - Mostly CGI::Application run modes for admin and editor functions of Cascade

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

package Cascade;
use strict;

#DBI->trace(1);

sub write_static_pages {
   my $self = shift;
   $| = 1;

   $FORM{mode} = 'static';

   umask $CFG{UMASK};

   print CGI::header(-expires=>'-3m',-type=>'text/html').CGI::start_html(gettext("Building Static Pages"))."\n";

   print qq!Writing the <a href="$CFG{HTML_ROOT_URL}/index.$CFG{HTML_EXTENSION}">front page</A>:
     $CFG{HTML_ROOT_DIR}/index.$CFG{HTML_EXTENSION}<P>\n!;

eval {
   $self->write_static_front_page;
   # If a category_id is present, we are writing just the pages for a single category.
   require Cascade::Category;

   if ($FORM{category_id}) {
      my $cat = Cascade::Category->new(id=> $FORM{category_id},mode=>'static' );
      $self->write_parents($cat);
      # Otherwise, we are rewriting the whole directory. 
   } else {
      # First, we get all leaf ids. (this select says: "show me all the categories that are not parents")
      my ($leaves);
      if ($CFG{DRIVER} eq "mysql") {
      $leaves = $DBH->selectcol_arrayref("
          SELECT category_id
            FROM cas_category as category
           WHERE category_id <> parent_id");
      } else {
      $leaves = $DBH->selectcol_arrayref("
    SELECT category_id
		FROM cas_category category
		EXCEPT SELECT parent.category_id
			FROM cas_category child, cas_category parent
			WHERE child.parent_id = parent.category_id");
      }
      # Now write pages top-to-bottom for each leaf, skipping any categories we've already seen before. 
      my %seen;
      while (my $cat_id = pop @$leaves) {
	 my $cat = Cascade::Category->new(id=>$cat_id,mode=>'static');
	 while (my $p =  shift @{ $cat->name('parents') }) {	
	    my $parent = Cascade::Category->new(id=>$p->{id},mode=>'static');
	    unless ($seen{ $p->{id} }) {
	       $self->write_static_cat($parent);
	       $seen{ $p->{id} }++;
	    }
	 }	
      }
        
   }	

   print "Writing the Footer: $CFG{HTML_ROOT_DIR}/includes/footer.$CFG{HTML_EXTENSION}<P>\n";
   $self->write_footer;

   print "Writing the Header: $CFG{HTML_ROOT_DIR}/includes/header.$CFG{HTML_EXTENSION}<P>\n";
   $self->write_header;

   print qq!Writing the <a href="$CFG{HTML_ROOT_URL}/$CFG{WHATS_NEW_DIR}/index.$CFG{HTML_EXTENSION}">
     What's New Page</A>: $CFG{HTML_ROOT_DIR}/$CFG{WHATS_NEW_DIR}/index.$CFG{HTML_EXTENSION}<P>\n!;
   $self->write_whats_new;
   };
   if ($@) {
      print "NOTICE: writing static pages failed for the following reason: $!"
   }
   exit;
}

##############################

sub write_static_front_page {
   my $self = shift;


  # XXX OK, this is a bit of a hack. To prevent
  # the "You are logged in as..." section from appearing on static pages, we delete the session
  # role variables. 
  # I thought of other ways to handle this, but they all seemed like more of a hack.  -mls
   delete $SES{role_user};

    open(FILE, ">$CFG{HTML_ROOT_DIR}/index.$CFG{HTML_EXTENSION}") || 
	print gettext("Could not open")," $CFG{HTML_ROOT_DIR}/index.$CFG{HTML_EXTENSION}: $! <BR>\n";
    print FILE $self->front_page();
    close(FILE);
}

sub write_footer {
   my $self = shift;
    (-e "$CFG{HTML_ROOT_DIR}/includes") || 
	mkdir ("$CFG{HTML_ROOT_DIR}/includes", $CFG{DEFAULT_FILE_MODE}) || 
	    print gettext("Could not make directory"),
	    " $CFG{HTML_ROOT_DIR}/includes :$! Skipping<P>\n", return;
    open(FILE, ">$CFG{HTML_ROOT_DIR}/includes/footer.$CFG{HTML_EXTENSION}") || 
	print gettext("Could not open"),
	"$CFG{HTML_ROOT_DIR}/includes/footer.$CFG{HTML_EXTENSION} ",
	gettext("for writing"),":$1 ",gettext("Skipping"),"<P>\n", return;
	
 my $tmpl = $self->load_tmpl('footer.tmpl' );
  
  $tmpl->param(&footer_html_tmpl);
	
    print FILE $tmpl->output;
    close(FILE);
}

sub write_header {
   my $self = shift;
    (-e "$CFG{HTML_ROOT_DIR}/includes") || 
	mkdir ("$CFG{HTML_ROOT_DIR}/includes", $CFG{DEFAULT_FILE_MODE}) || 
	    print gettext("Could not make directory"),
	    "$CFG{HTML_ROOT_DIR}/includes :$! ",
	    gettext("Skipping"),"<P>\n", return;
    
    open(FILE, ">$CFG{HTML_ROOT_DIR}/includes/header.$CFG{HTML_EXTENSION}") || 
	print gettext("Could not open"),
	" $CFG{HTML_ROOT_DIR}/includes/header.$CFG{HTML_EXTENSION} ",
	gettext("for writing"),":$1 ",
	gettext("Skipping"),"<P>\n", return;
    
  my $tmpl = $self->load_tmpl('header.tmpl', );
  
    print FILE $tmpl->output;
    close(FILE);
}

sub write_whats_new {
   my $self = shift;
   chdir $CFG{HTML_ROOT_DIR};
    (-e $CFG{WHATS_NEW_DIR}) || 
	mkdir ($CFG{WHATS_NEW_DIR}, $CFG{DEFAULT_FILE_MODE}) || 
	    print gettext("Could not make directory ")
		.$CFG{WHATS_NEW_DIR}.":$! ".gettext("Skipping")."<P>\n", return;
		
    open(FILE, ">$CFG{WHATS_NEW_DIR}/index.$CFG{HTML_EXTENSION}") || 
	print gettext("Could not open").
	    " $CFG{WHATS_NEW_DIR}/index.$CFG{HTML_EXTENSION} ".
		gettext("for writing").":$1 ".gettext("Skipping").
		    "<P>\n", return;
    print FILE $self->html_item_new
      || print "Count not print to file CFG{WHATS_NEW_DIR}/index.$CFG{HTML_EXTENSION}. Skipping", return ;
    close(FILE);
}



sub cat_add_form {
   my $self = shift;
   require Cascade::Category;
   my $cat = Cascade::Category->new(id=>$FORM{category_id}, mode=>'dynamic');
   my $tmpl = $self->load_tmpl('cat-add.tmpl');
   $tmpl->param(
		category_id=>$FORM{category_id},
		script_name=>$ENV{SCRIPT_NAME}	,
		footer_html_tmpl(),
		plain_name=>$cat->name('plain'),
	       );
   return $tmpl->output;
}

sub cat_add_process {
   my $self = shift;

   length $FORM{name} or return err(title=>gettext("No Category Name"),
				    msg=>gettext("You must at least provide a category name!")); 
   if (my $err = (&illegal_chars or 
		    cat_already_exists($FORM{name},$FORM{parent_id})
		      or &conflicts_with_existing_cat)) {
      return $err;
   }
   else {
      eval { 
	 $DBH->{RaiseError} = 1;
	 $DBH->{AutoCommit} = 0 if ( $CFG{DRIVER} eq 'Pg' ) ; 
	 require Cascade::Category; 
	 my $cat = new Cascade::Category (populate=>0);
	 my $sort_key = $cat->sort_key($FORM{parent_id});
	
	 # XXX maybe this should be moved into Cascade::Category.pm -mls
	 # Insert the node
	 require DBIx::Abstract;
	 my $db = DBIx::Abstract->connect($DBH);
	 $db->insert('cas_category',{
	     name	=> $FORM{name},
	     description => $FORM{description},
	     parent_id	=> $FORM{parent_id},
	     sort_key	=> $sort_key,
	    });

	 $DBH->commit if ( $CFG{DRIVER} eq 'Pg' ) ; 
      };

      $@ and return err(title=>'Problem Adding Category',
			msg=>'There was a problem adding that category. The database returned the error: '.$DBI::errstr);

      return $self->category_page;
   } 
}

# Returns the HTML for sideways link form
# XXX Maybe I should create Cascade::Link for all the link functions... -mls
sub link_form {
   my $self = shift;

   my $tmpl = $self->load_tmpl('link-manage.tmpl');	

   require Cascade::Category;
   # if we're in edit mode
   if (length $FORM{link_id}) {
      my $link_ref =	$DBH->selectrow_hashref("
              SELECT link_id, from_cat_id, to_cat_id, to_item_id, name, active 
                 FROM cas_link
                 WHERE link_id = $FORM{'link_id'}");
      $tmpl->param(%$link_ref);
      my $from_cat = Cascade::Category->new(id=>$link_ref->{from_cat_id}, mode=>$FORM{'mode'});
      if (defined $link_ref->{to_cat_id}) {	
	 #my $to_cat = Cascade::Category->new(id=>$link_ref->{to_cat_id});
	 #$tmpl->param( to_cat_url=>$to_cat->name('url') );
	 $tmpl->param(
	    to_cat_categories_box=>$from_cat->all_categories_box(
	       name=>'to_cat_id',
	       default=>$link_ref->{to_cat_id},
	       include_top=>0,
            )
	   );
      }
      $tmpl->param(
		   edit_mode=>1,
		   title=>'Edit',
		   from_cat_plain=>$from_cat->name('plain')
		   );
   }
   else {
      unless (length $FORM{from_cat_id}) {
	 return err(title=>gettext("Insufficient information"),
	  msg=>gettext("The needed from_cat_id form variable ").
	  gettext("was not found as expected. ").
	  gettext("This probably a programming error."));
      } 

      my $from_cat = Cascade::Category->new(id=>$FORM{from_cat_id}, mode=>$FORM{'mode'});
      $tmpl->param(to_cat_categories_box=>$from_cat->all_categories_box(
	 name=>'to_cat_id',
         include_top=>0,
	 )
		  );
      $tmpl->param(
		   from_cat_plain => $from_cat->name('plain'),
		   from_cat_id=>$FORM{from_cat_id},
		   title=>'Add'
		  );
   }

   $tmpl->param(
		script_name=>$ENV{SCRIPT_NAME}	,
		footer_html_tmpl(),
	       );
 
   $self->header_props(-expires=>'-3m',-type=>'text/html');
   return $tmpl->output;
}

sub link_validate_form {
   my $self = shift;
  length $FORM{from_cat_id} or
    err(title=>gettext("Insufficient information"),
	msg=>gettext("The needed from_cat_id form variable ").
	gettext("was not found as expected. ").
	gettext("This probably a programming error."));

   if (length $FORM{to_cat_id}) {
   }
   elsif (length $FORM{to_cat_url}) {
      $FORM{to_cat_id} = $self->check_cat_url($FORM{to_cat_url});
      length $FORM{to_cat_id} or
	    return err(title=>gettext("Not a Valid Category"),
		msg=>gettext("The Category you tried to link to ").
		gettext("does not the exist. That\'s the breaks"));
   }
   else {
      return err(title=>'Insufficient Information',
		   msg=>'We need at least a to_cat_id or to_cat_url variable to operate');
   }

   if ($FORM{name} =~ /^\s*$/) { 
	return err(title => gettext("Empty Name Field"), 
	     msg => gettext("You must supply a name for your link")) ;
    }

}
sub link_add {
   my $self = shift;
   my $err =  $self->link_validate_form();
   my $err = link_already_exists($FORM{to_cat_id});
   if ($err) { return $err }
   else {
      $DBH->do("insert into cas_link 
		(from_cat_id, to_cat_id, name)
		values
		($FORM{'from_cat_id'}, $FORM{to_cat_id},".
                $DBH->quote($FORM{name}) . ")") ;
	$FORM{category_id} = $FORM{from_cat_id};
	return $self->category_page();
     }	
}

sub link_already_exists {
    my $to_cat_id = shift;
    my $link_id = $DBH->selectrow_array("select link_id 
		from cas_link 
		where to_cat_id = $to_cat_id 
                    and from_cat_id = $FORM{'from_cat_id'}");
    if (defined $link_id) {
	# NOTE: It'd be nice to be more verbose about which 
	# cats there is already a link between
	return err(title => gettext("Link Exists"), 
	     msg => gettext("There's already a link ").
	     gettext("between these categories! "));
    }
}

sub link_edit {
   my $self = shift;
   if (my $err = $self->link_validate_form()) {
      return $err;
   }
   
   $DBH->do("update cas_link 
		set to_cat_id = $FORM{to_cat_id}, name = ". $DBH->quote($FORM{name}) ."
		where link_id = $FORM{'link_id'}");

   $FORM{category_id} = $FORM{from_cat_id};
   return $self->category_page;	
}

sub link_delete {
   my $self = shift;
   $DBH->do("delete from cas_link where link_id = $FORM{'link_id'}");
   $FORM{category_id} = $FORM{from_cat_id};
   return $self->category_page;	
}


sub cat_relate_form {
   my $self = shift;

   length $FORM{'from_cat_id'} or
     err(title => gettext("missing parameter: from_cat_id"),
	 msg => gettext("some programmer out there needs to ").
	   gettext("be to make sure that this page is called with a ").
	     gettext("from_cat_id parameter. Try bugging ").
	       $CFG{CONTACT_EMAIL} . gettext("about this."));

   require Cascade::Category;
   my $cat = Cascade::Category->new(id=>$FORM{from_cat_id}, mode=>$FORM{'mode'});

   my $tmpl = $self->load_tmpl('cat-relate.tmpl');
	
   my @to_cats;
   my $to_cat_ids_ref = $DBH->selectcol_arrayref("
		SELECT to_cat_id 
			FROM cas_related_category 
			WHERE from_cat_id = $FORM{'from_cat_id'}");
   my $rows;
   foreach my $id (@$to_cat_ids_ref) {
      my $cat = Cascade::Category->new(id=>$id);
      push @to_cats, {
	 cat_id 		=> $id,
	 single_link	=> $cat->name('single_link'),
      }
   }
	
   $tmpl->param(
      to_cats => \@to_cats,
      from_cat_id => $FORM{from_cat_id},
      single_link => $cat->name('single_link'),
      related_cat_id_box => $cat->all_categories_box(
	 name=>'related_cat_id',
	 size=>10,multiple=>1,
	 default=>undef,
	 include_top=>0),
      script_name=> $ENV{SCRIPT_NAME},
      footer_html_tmpl(),
     );

   return 	$tmpl->output;
}

sub cat_relate_update {
   my $self = shift;

   length $FORM{'from_cat_id'} or
	err(title => gettext("missing parameter: from_cat_id"),
	    msg => gettext("some programmer out there needs to ").
	    gettext("be to make sure that this page is called with a ").
	    gettext("from_cat_id parameter. Try bugging ").
	    $CFG{CONTACT_EMAIL} . gettext("about this."));

	map { relate_category($_) } 	($self->query->param('related_cat_id'));
	map { unrelate_category($_) }	($self->query->param('unrelate_cat_id'));
   $FORM{category_id} =  $FORM{from_cat_id};
   return $self->category_page;
}

sub relate_category {
	my $to_cat_id = shift;
	$DBH->do("insert into cas_related_category
		values
		($FORM{'from_cat_id'}, $to_cat_id)");
}

sub unrelate_category {
	my $to_cat_id = shift;
	$DBH->do("delete from cas_related_category 
		where to_cat_id = $to_cat_id 
			and from_cat_id = $FORM{'from_cat_id'}");
}

sub cat_edit_form {
   my $self = shift;

   length $FORM{cat_id} or
	err(title => gettext("No category specified"), 
	     msg => gettext("There must be an category_id present to edit the category"));

  my $cat_ref = $DBH->selectrow_hashref("
        SELECT *,category_id as cat_id from cas_category where category_id = $FORM{cat_id}");
  
   #DBI->trace(1);
  require Cascade::Category;
  my $cat = Cascade::Category->new(id=>$FORM{cat_id});	

   my $tmpl = $self->load_tmpl('cat-edit.tmpl');
	$tmpl->param(
		%$cat_ref,
		new_parent_id_box=>$cat->all_categories_box(name=>'cat_parent_id'),
		plain_name=>$cat->name('plain'),
		script_name=>$ENV{SCRIPT_NAME},
		&footer_html_tmpl,
	);

  $self->header_props(-expires=>'-3m',-type=>'text/html');
  return $tmpl->output;
}

sub cat_update {
   my $self = shift;

   length $FORM{cat_id} or
	return err(title => gettext("No category specified"), 
	     msg => gettext("There must be an category_id present to edit the category"));

   # XXX maybe these two category related routines should be moved into Cascade::Category. -mls
   if (my $err = (&illegal_chars 
		    or &cat_already_exists($FORM{cat_name},$FORM{cat_parent_id},$FORM{cat_id})
		    or &conflicts_with_existing_cat)) {
      return $err;
   }
   else {
	require Cascade::Category;
	my $cat = new Cascade::Category(id=>$FORM{cat_id});
	$cat->update() or return 
	    err(title=>'Category Update Failed',
             msg=>"The Category update failed due to an unexpected error: $@");
	
	# if the parent_id has changed, we update the sort_keys
	if ($cat->parent_id != $FORM{cat_parent_id}) {
		$cat->update_sort_keys;
	    }
	$FORM{category_id} = $FORM{cat_id};
	return $self->category_page
    }
}
# anyone want to provide an example of how to do this easier with RI? -mls
sub cat_delete {
   my $self = shift;

   length $FORM{cat_id} or
	return err(title => gettext("No category specified"), 
	     msg => gettext("There must be an category_id present to edit the category"));


     # Turning AutoCommit off and back on effectively does a "begin" and "commit"

    # Update the all resource counts for parent categories
    my $cat_id =  $FORM{cat_id};
   require Cascade::Category;
    my $cat = Cascade::Category->new(id=>$cat_id);	
    # XXX I'm pretty sure that if the parent_id is not present that actually means
    # that the parent_id should be zero. If this is always true, I should move this logic into
    # Cascade::Category->parent_id. -mls
    my $parent_id = $cat->parent_id || 0;

    $DBH->{AutoCommit} = 0 if ( $CFG{DRIVER} eq 'Pg' ) ; 
    $DBH->do("DELETE from cas_category WHERE category_id = $cat_id");

    # delete "related category" relationships" 
   $DBH->do("DELETE from cas_related_category
                  WHERE from_cat_id = $cat_id
                     OR to_cat_id = $cat_id");

   # delete "link" relationships"
   $DBH->do("DELETE from cas_link 
                  WHERE from_cat_id = $cat_id
                     OR to_cat_id = $cat_id");

   # if there are any suggested updates for this category, they now apply to the categories parent
    $DBH->do("UPDATE  cas_item_suggested_updates
                 SET category_id = $parent_id
                 WHERE category_id = $cat_id");    

    # foreach child, reconnect them to the grandparent. 
    my $children = $DBH->selectcol_arrayref(" SELECT category_id from cas_category where parent_id = $cat_id ");
    
    if (@$children) {
	    $DBH->do("
	    	UPDATE cas_category 
	    		SET parent_id = $parent_id
	    		WHERE category_id in (".join ',',@$children.")");
	  
	    # now update the the sort_keys
	    foreach my $child (@$children) {
	    	my $cat = new Cascade::Category (id=>$child);
	    	$cat->update_sort_keys;
	    }
	}	    
    		
    # Linked deletes dont work in MYSQL -em
    $DBH->do("DELETE from cas_item WHERE cas_item.item_id in (
    	SELECT item_id from cas_category_item_map WHERE category_id=$cat_id)");
    $DBH->do("delete from cas_category_item_map where category_id = $cat_id");

    
#    Mysql doesnt support transactions
    $DBH->commit if ( $CFG{DRIVER} eq 'Pg' ) ; 

   $FORM{category_id} = $FORM{cat_parent_id};
   return $self->category_page;
}

# Writes out static pages for this page and all parents.
# Returns array of ids of all affected categories
sub write_parents {
   my $self = shift;
   my $cat = shift;
   
   my @parent_ids;
   while (my $p =  shift @{ $cat->name('parents') }) {	
      my $parent = Cascade::Category->new(id=>$p->{id},mode=>'static');
      push @parent_ids, $p->{id};
      $self->write_static_cat($parent);
   }
   return @parent_ids;
}


# Write's a static page for a single category
# Outputs progress in HTML
# Hey, maybe someday there will options for silent and verbose modes. What to program that yourself? -mls
sub write_static_cat {
   my $self = shift;
   my $cat = shift;
   my %in = (
      verbose=>1, # by default we're verbose. 
      @_
     );

  # XXX OK, this is a bit of a hack. To prevent
  # the "You are logged in as..." section from appearing on static pages, we delete the session
  # role variables. 
  # I thought of other ways to handle this, but they all seemed like more of a hack.  -mls
   delete $SES{role_user};
	
   my $cat_dir = $Cascade::CFG{HTML_ROOT_DIR}.'/'.$cat->name('enc_name');
   my ($parent_dir) = ($cat_dir =~ m!^(.*)/!);
	
   if ($in{verbose}) {
      print gettext("Building Category").": ".
     $Cascade::CFG{HTML_ROOT_URL}.'/'.$cat->name('single_link')."<BR>\n".
       gettext("Filename").": ".$cat_dir."/index.$CFG{HTML_EXTENSION} <BR>\n";
   }
	
   # Check to make sure the parent directory is already there first
   if (-e $parent_dir) {
      if (!-e $cat_dir) {
	 if (mkdir ($cat_dir, $Cascade::CFG{DEFAULT_FILE_MODE})) {
	    print "Making directory $cat_dir with mode $Cascade::CFG{DEFAULT_FILE_MODE} and umask ".(umask)." <P>\n" if $in{verbose};
	 } else {
	    print gettext("Could not make directory ").$cat_dir.
	      ":$! (umask was ".(umask). ".) Skipping<P>\n" if $in{verbose};
	    return 0;
	 }
      }
      if (open(FILE, ">$cat_dir/index.$CFG{HTML_EXTENSION}")) {
	 my $t = $self->load_tmpl('category.tmpl');
	 $t->param($cat->html_page);
	 print FILE $t->output;
	 close(FILE);
      } else {
	print gettext("Could not open "). $cat_dir."/index.$CFG{HTML_EXTENSION} ". gettext("for writing").
	  ":$1 ".gettext("Skipping")."<P>\n" if $in{verbose}; 
	 return 0;
      }
		
      print gettext("Building Includes for Static Content Pages").
	": dir_url.$CFG{HTML_EXTENSION}" if $in{verbose};

      if ( open(FILE, ">$cat_dir/dir_url.$CFG{HTML_EXTENSION}")) { 
	 print FILE '<a href="'.$Cascade::CFG{HTML_ROOT_URL}.'">'.
	   $CFG{SYSTEM_NAME}.'</a>: '.$cat->name('MULTI_LINK') if $in{verbose};
	 close(FILE);
      } else {	
	 print gettext("Could not open ").$cat_dir."/dir_url.$CFG{HTML_EXTENSION}".
	   gettext("for writing").":$1". gettext(" Skipping")."<P>\n" if $in{verbose};
	 return 0;
      }
	
      print "\tdir_list.$CFG{HTML_EXTENSION}<P>\n\n" if $in{verbose};

      if (open(FILE, ">$cat_dir/dir_links.$CFG{HTML_EXTENSION}")) { 
	 print FILE $cat->get_item_html(style=>'short');
	 close(FILE);
      } else {
	 print gettext("Could not open "). $cat_dir."/dir_links.$CFG{HTML_EXTENSION} ".
	   gettext("for writing").":$1 ".
	     gettext("Skipping")."<P>\n" if $in{verbose} ;
	 return 0;
      }
		
      return 1;
   } else {
      print gettext("No Parent directory was found for ").
	gettext("this category. ").gettext("Skipping").'.<P>\n';
      return 0;
   }
}

sub item_approve_add {
   my $self = shift;
   if (length $FORM{item_id}) {
      # link to an existing item
      $DBH->do("insert into cas_link (from_cat_id, to_item_id) values ($FORM{category_id}, $FORM{item_id})");
   }
   else {
      # add the item to the database
      my $item = Cascade::Item->new();
      # XXX hackish -mls
      $FORM{item_approval_state} = 'approved';
      $item->insert(data=>\%FORM);
   }
   return $self->category_page
}

sub needs_approval_summary {
  my $self = shift;
  my $tmpl = $self->load_tmpl('item-needs-approval-summary.tmpl');

  my $tbl_ref = $DBH->selectall_arrayref("
		SELECT item.item_id, category_item_map.category_id
		  FROM cas_item item,
                       cas_category_item_map category_item_map
	      WHERE item.item_id = category_item_map.item_id
	      	AND item.approval_state = 'needs_approval'
	      ORDER BY item.insert_date DESC, category_item_map.category_id",
       # compatibility hack to work both with DBI 1.19 and DBI 1.20
					 {  dbi_fetchall_arrayref_attr=>{}, Slice=>{} }); 
  my %insert_cats;
  while (my $row = shift @$tbl_ref) {
    push @{ $insert_cats{ $row->{category_id} }->{item_ids} }, $row->{item_id};
  }	 

  require Cascade::Item;
  foreach my $cat_id (keys %insert_cats) {
    my $cat  = Cascade::Category->new(id=>$cat_id);
    $insert_cats{$cat_id}->{single_link} = $cat->name('single_link');
   
    foreach my $item_id (@{ $insert_cats{$cat_id}->{item_ids} }) {
      my $item = Cascade::Item->new(id=>$item_id,category_id=>$cat_id);
      push @{ $insert_cats{$cat_id}{items} }, {
	approve_link => qq!<A HREF="$CFG{CASCADE_CGI}/item_approve_insert?item_id=$item_id&cat_id=$cat_id">approve</A>!,
	item_html => $item->output_html			   
       }
    }			
  }
	
  # collect the suggested updates
  my $updates_ref = $DBH->selectall_arrayref("
		SELECT item_update_id, category_id
			FROM cas_item_suggested_updates
			ORDER BY date_added DESC, category_id ",
      # compatibility hack to work both with DBI 1.19 and DBI 1.20
				     {  dbi_fetchall_arrayref_attr=>{}, Slice=>{} });
  my %update_cats;
  while (my $row = shift @$updates_ref) {
    push @{ $update_cats{ $row->{category_id} }->{item_ids} }, $row->{item_update_id};
  }	 

  # XXX It's a known issue that suggested updates without category ids will cause problems. -mls
  require Cascade::Category;
  foreach my $cat_id (keys %update_cats) {
    my $cat  = Cascade::Category->new(id=>$cat_id);
    $update_cats{$cat_id}->{single_link} = $cat->name('single_link');
	
    foreach my $item_id (@{ $update_cats{$cat_id}->{item_ids} }) {
      my $item = Cascade::Item->new(id=>$item_id,table=>'cas_item_suggested_updates');
      push @{ $update_cats{$cat_id}{items} }, {
	approve_link => qq!<A HREF="$CFG{CASCADE_CGI}/item_approve_update?update_id=!.$item->field('item_update_id').qq!&cat_id=$cat_id">approve</A>!,
	item_html => $item->output_html			   
       }
    }		
  }

  $tmpl->param(
    insert_cats=>[values %insert_cats],
    update_cats=>[values %update_cats],
    footer_html_tmpl()
   );

  $self->header_props(-type=>'text/html',-expires=>'-3m');
  return $tmpl->output; 

}

sub item_delete {
  my $self = shift;
   (defined $FORM{'item_id'} or $FORM{update_id}) and defined $FORM{category_id} or 
	return err(title => gettext("No Item or Category specified"), 
		   msg => gettext("There must be a category_id present as well as an item_id or update_id ").
		       gettext("present to delete the item"));
   my ($ItemId,$Table,$return_mode);
   if ($FORM{update_id}) {
     $ItemId = $FORM{update_id};
     $Table = 'cas_item_suggested_updates';
     $return_mode = 'needs_approval_summary'
   }
   else {	 
     $ItemId = $FORM{item_id};
     $Table = 'cas_item';
   }
  my $item = Cascade::Item->new(
	category_id=>$FORM{category_id},
	id=>$ItemId,
	table=>$Table);
 $return_mode ||= ($item->field('approval_state') eq 'needs_approval') ? 'needs_approval_summary' : 'category_page';

  # If it's just a link, delete that
    $DBH->do("delete from cas_link link where link_id  IN (
          SELECT link_id FROM cas_link link WHERE from_cat_id = $FORM{category_id} and to_item_id = $ItemId)");

  # If it links to it, those need to be deleted first
  my $cat_ids = $DBH->selectcol_arrayref("select from_cat_id from cas_link where to_item_id = $ItemId");
  if (@$cat_ids) {
    my $msg = gettext("This item is linked to from another ").
      gettext("category. So you\'ll you need to delete ").
	gettext("these references before you delete ").
	  gettext("this item. For each reference, ").
	    gettext("you need to look in these categories:").
	      "<UL>";
    foreach my $id (@$cat_ids) { 
      my $cat = Category->new(id=>$id);
      $msg .= CGI::li( $cat->name('SINGLE_LINK') );
    }	
    return err(title => gettext("Links Present"), msg=>$msg."</UL>");
  }
  else {
    $item->delete;
    return eval('$self->'.$return_mode);
  }
}

sub item_approve_insert {
   my $self = shift;
   unless ($FORM{item_id} && defined $FORM{cat_id}) {
      return	err(title=>'Insufficient Information',
		    msg=>'We were expecting an item_id and a cat_id, but something was missing. Oops.');
   }
   my $t = $self->load_tmpl('item-approval.tmpl');
   # approve the item
   my $rv = $DBH->do("
	UPDATE cas_item
	SET approval_state = 'approved'
	WHERE item_id = $FORM{item_id} ") or
	  return err(title=>gettext("Database Error"),
	  msg=>"The Database returned an error: $DBI::errstr" );

   # get an insert message 
   my $insert_msg = $DBH->selectrow_array("
	SELECT insert_msg FROM cas_category WHERE category_id = $FORM{cat_id} ") || $CFG{DEFAULT_INSERT_MSG};

   return prepare_approval_tmpl('addition',$insert_msg,$FORM{item_id},$t);
}
# prepares data for the template when a suggested addition or update is approved
sub prepare_approval_tmpl {
	my ($type,$msg,$item_id,$tmpl) = @_;
	
		# prepare the update for appearing in javascript by backslashing quotes
	#  and changing reall newlines to fake ones
	(my $js_body = $msg) =~ s/"/\"/g;
	$js_body =~ s/\n/\\n/gm;
	
	# Check to see if there are any email addresses related to this item to contact
	my @to_emails = $DBH->selectrow_array("
		SELECT email,submitor_email
			FROM cas_item item
			WHERE item.item_id = $item_id ");
	
	my $cat_mode = $CFG{DYNAMIC_ONLY_P} ? 'dynamic' : 'static';
	my $cat = Cascade::Category->new(id=>$FORM{cat_id},mode=>$cat_mode) || die;
	
	my @defined_to_emails;
	my %seen;
	foreach (@to_emails) {
		if (($_ =~ /\S+/) and (not $seen{$_}++)) {
			push @defined_to_emails, $_;
		}			
	}
	
	$tmpl->param(
		type			=> $type,
		to 				=> (join ',', @defined_to_emails),
		cc 				=> $cat->get_admin_and_cat_emails,
		body			=> $msg,
		js_body			=> $js_body,
		full_url		=> $cat->name('full_url'),
		cat_id			=> $FORM{cat_id},
		&footer_html_tmpl,
	);

	return $tmpl->output;
}

sub item_approve_update {
   my $self = shift;
   length $FORM{update_id} and length $FORM{cat_id} or
     return err(title=>'Insufficient Information',
		msg=>'We were expecting an update_id and a cat_id, but something was missing. Oops.');


   # perform update
   my $item;
	
   eval {
      $DBH->{RaiseError} = 1;
      $DBH->{AutoCommit} = 0;
      
      $item = $DBH->selectrow_hashref("SELECT * 
				FROM cas_item_suggested_updates
				WHERE item_update_id = $FORM{update_id}
					AND category_id = $FORM{cat_id} "); 
      length $item->{item_id} or die 
	    "That Item was not found in the table of suggested updates.
              Perhaps it's already been approved and deleted from suggested updates table\n";

      # delete a few columns we can't use
      delete $item->{category_id};
      delete $item->{item_update_id};
      delete $item->{date_added};

      require DBIx::Abstract;
      my $db = DBIx::Abstract->connect($DBH);
      $db->update('cas_item',$item,"item_id = ".$item->{item_id});

      # clean up the suggested updates table
      $DBH->do("DELETE FROM cas_item_suggested_updates WHERE item_update_id = $FORM{update_id}");

      $DBH->{AutoCommit} = 1;
      $DBH->{RaiseError} = 0;
   };

   if ($@) { 
      return err(title=>'Update Error',
	  msg=>"There was an error updating the database. The error was: $@\n") 
   }
	
   # print results page
   # get an update message 
   my $update_msg = $DBH->selectrow_array("
		SELECT update_msg FROM cas_category WHERE category_id = $FORM{cat_id} ")
     || $CFG{DEFAULT_UPDATE_MSG};

   return prepare_approval_tmpl('update',
				$update_msg,
				$item->{item_id},
				$self->load_tmpl('item-approval.tmpl'));
}   
1;

=pod

=head1 AUTHOR

Copyright (C) 2000-2001 Mark Stosberg <mark@stosberg.com>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
 
Address bug reports and comments to: mark@stosberg.com.  When sending
bug reports, please provide the version of Cascade, the version of
Perl, the name and version of your Web server, the name and version of
the operating system you are using, and the name and version of the
database you are using.  If the problem is even remotely browser
dependent, please provide information about the affected browers as
well.

=head1 SEE ALSO

perl(1).

=cut
