#!/usr/bin/perl
# Copyright (c) 2000 Mark Stosberg <mark@stosberg.com>
# Licensed under the the GNU GPL, available here: http://www.gnu.org/copyleft/gpl.html

# Initialize globals just to be safe
%FORM = ();
%CFG = (); 

##################################
# VARIABLES THAT YOU MUST SET.
##################################

##########
# Database Connection Info
##########

# Your DBD driver.
# Currently can be "Pg" for Postgres, or 'mysql' for MySQL
# Make sure you have DBD::Pg or DBD::mysql installed!
$CFG{DRIVER} = "Pg"; 

# name of your database 
$CFG{DATABASE} = "cascade";

# name of the machine with your database on it, 'localhost' if it's on
# the same machine as the webserver
$CFG{DBSERVER} = "localhost";	

# The database port. Leaving it blank is the Right Thing in most cases.
$CFG{DBPORT} = "";

# the user you connect to the database as. 
$CFG{DBUSER} = "mark";

# The password you use when connecting to the database. Leave empty for no password. 
$CFG{DBPASS} = "";

# This is a option in Postgres' connect string. You can usually leave it blank	  
$CFG{DBOPTIONS} = "";		

############
# General Site Variables
############

# The general contact email for this site If you are hacking on
# Cascade on your local Unix machine, look into the variable below
# named VERIFY_EMAILS_P. 
$CFG{CONTACT_EMAIL} = 'you@yourhost.com';
	  
# Name of your project. If you want to use the ' character, write it
# as \'
$CFG{SYSTEM_NAME} = 'Cascade'; 

# Path to directory on server where static pages will be written
# (no trailing slash)
$CFG{HTML_ROOT_DIR} = '/home/mark/html_root';

# root url of where html files live (no trailing slash)
$CFG{HTML_ROOT_URL} = "http://your.host.org/cascade";

# url of script that runs this instance of cascade.
# This should be based on the script distributed in html_root/cgi-bin/cascade.cgi
# However, you can name it something else as long that name matches here.
# This doesn't need to be below the html root.
$CFG{CASCADE_CGI} = "$CFG{HTML_ROOT_URL}/cgi-bin/cascade.cgi";

# Domain ( used for cookies authentication )
$CFG{SITE_DOMAIN} = "yourdomain.org" ;

# Location of the sendmail program on your system Maybe in the future
# Cascade will be smart enough to figure out the common cases for you.  
$CFG{MAILPROG} = '/usr/sbin/sendmail';  
	  
############################################
# VARIABLES THAT YOU MIGHT WANT TO SET. 
############################################

# A two letter language code. Currently only english is fully
# supported. 
$CFG{LAN} = 'en';

# the root directory for your templates
$CFG{HTML_TEMPLATE_ROOT} = "$CFG{HTML_ROOT_DIR}/templates/$CFG{LAN}/basic";

# Expiration time in months Maybe in the future we can support
# expiration times in different units 
$CFG{SESSION_EXPIRE_TIME} = '12',

# extension for html files created by the system. You may want to change this to "shtml"
# if your server request that for files that use server side includes (SSIs)
$CFG{HTML_EXTENSION} = "html";

# the number of entries to include on the "What's New" page. 
$CFG{BUILD_NEW_CUTOFF} = 52;

# how many new items to display on the front page
$CFG{FRONT_PAGE_NEW_CUTOFF} = 10;

# Use this to make the geospatial search engine interface appear on the front page
# You have to do a lot more than this to actually get it to work, though.
# see INSTALL.geospatial
$CFG{GEOSPATIAL_ENABLED_P} = 0;

# Set this to 1 if you want to remove the links to write static pages
# See the note in the RM_AUTH hash below about another tweak to make
# when switching modes. 
$CFG{DYNAMIC_ONLY_P} = 1;

# Set this to 1 if you want the interface elements to show up to allow
# people to suggest addtions and additions and updates
# and for admins to manage them. 
# This setting applies globally
$CFG{DISPLAY_SUGGESTION_LINKS_P} =1;

$CFG{RATING_ICON_FULL} = 
   qq!<img align="top" src="$CFG{HTML_ROOT_URL}/images/dot-on-red-10.gif" width="10" height="10">!;
$CFG{RATING_ICON_EMPTY} = 
  qq!<img align="top" src="$CFG{HTML_ROOT_URL}/images/dot-off-pink-10.gif" width="10" height="10">!;

# define what level of authentication run modes need for those that need it.
# Note: Since run modes may contain additional checks, it
# probably only makes sense to _raise_ the authentication level needed. -mls
$CFG{RM_AUTH} = {
   item_approve_add	=> 'editor',
   item_approve_insert=> 'editor',
   item_approve_update=> 'editor',
   item_edit_suggestion_form => 'editor',  
   write_static_pages => 'admin',
   cat_add_form	=> 'admin',
   cat_add_process	=> 'admin',
   link_form		=> 'admin',
   link_add		=> 'admin',
   link_edit		=> 'admin',
   link_delete	=> 'admin',
   cat_relate_form	=> 'admin',
   cat_relate_update  => 'admin',
   cat_edit_form	=> 'admin',
   cat_update		=> 'admin',
   cat_delete		=> 'admin',
   item_delete	=> 'editor',
   needs_approval_summary => 'editor',
   item_comment_post    => 'user',
   item_comments_delete => 'editor',
   pvt_home		=> 'user',
   pvt_basic_info_update_form => 'user', 
   pvt_basic_info_process => 'user', 
};

# If we aren't in dynamic mode, we probably want only editors to see the dynamic version
# of the front page and category page
unless ($CFG{DYNAMIC_ONLY_P}) {
   $CFG{RM_AUTH}->{front_page} = 'editor';
   $CFG{RM_AUTH}->{category_page} = 'editor';
}

# default file and directory creation mode.
# this works great for me, but if you get permissions errors, you might play with it. 
$CFG{DEFAULT_FILE_MODE} = 0777;

# The umask for writing files. This should be fine for most people. 
$CFG{UMASK} = 002;

# the default message template used to respond to people who suggest new items
# This can be overridden on a per-category basis. 
$CFG{DEFAULT_INSERT_MSG} = "Thanks for your contribution to $CFG{SYSTEM_NAME}. Your suggestion
	has been approved and will appear at the url below very soon.";

# the default message template used to respond to people who suggest updates for items
# This can be overridden on a per-category basis. 
$CFG{DEFAULT_UPDATE_MSG} = "Thanks for your contribution to $CFG{SYSTEM_NAME}. Your suggestion
	has been approved and will appear at the url below very soon.";

#####
# localization variables
#####
# See the i18n directory for more information  

# Default state (of the united states of america)
# Leave null for no default;
# Should be uppercase 2 letter abbreviation. 
$CFG{DEFAULT_STATE_CODE} = '';

# Default Country
$CFG{DEFAULT_COUNTRY_CODE} = 'US';

# Where your internationalization files are stored
$CFG{CATDIR} = "/path/to/i18n"; 

# Verify email addresses?
# When I'm developing and testing on my home machines, I want to just send email to 'mark'
# but that doesn't pass the email verification, so here's a preference to turn it off
# You probably never want to change this, unless you are developing Cascade offline
$CFG{VERIFY_EMAILS_P} = 1; 

# Default points for an item
$CFG{DEFAULT_POINTS} = 3;

# Directory where "what's new" files are stored
# This is a directory name relative to HTML_ROOT_URL	 
# no leading or trailing slash. 
$CFG{WHATS_NEW_DIR} = "new";	   

# Setting this to any value but zero will downcase the directory names
# This option gives greater compatibility across operating systems
# example: 'Nuts and Bolts' becomes nuts_and_bolts as a downcased directory
# I haven't tested this lately, but it _should_ work. :) 
$CFG{DOWNCASE_DIRS} = 0;

# All the domains we set cookies for. Usually just the site domain.
$CFG{COOKIE_DOMAINS} = [$CFG{SITE_DOMAIN}];

# name for your cookie. This is arbitary
$CFG{SESSION_COOKIE_NAME} = 'sid';

# Default error marker
$CFG{ERROR_MARK} = '<font color="#FF0000" size="+1"><b>*</b></font> ';

################################
# Some variables you probably shouldn't change
###############################

# default time for cookies to expire (you probably shouldn't change
#  this -- it's strategically aligned with the session exp. time)
$CFG{DEFAULT_COOKIE_EXP_TIME} = "+$CFG{SESSION_EXPIRE_TIME}M";

# Form variable defaults
# XXX, this probably isn't the best way to set these. -mls
$FORM{category_id} = 0;
$FORM{mode} = 'dynamic';

# default values passed to HTML::Template
# Most of the site will if you change these. 
$CFG{HTML_TMPL_DEFAULTS} = {
   path=>$CFG{HTML_TEMPLATE_ROOT},
   die_on_bad_params=>0,
   loop_context_vars=>1
  };

1;
