#!/usr/bin/perl
# Copyright (C) 2001 Mark Stosberg <mark@stosberg.com>
# Licensed under the the GNU GPL, available here: http://www.gnu.org/copyleft/gpl.html

# This is a parser for the ZIPUSA.asc file available from here:
# http://www.tpsnet.com/html/zipcode.html

# Before you begin: read README.geospatial included in the Cascade distribution
# instructions: set the environment variable PERL5LIB to be the directory where your Cascade.pm is stored
# (if it's not already in your path)
# The zipcodes database should already be created before you start
# run the script like this:
# ./zipcode-parser.pl /path/to/ZIPUSA.asc
 

package Cascade;
use Cascade::Config;
use Cascade;

$DBH = &connect_db;

my $lastzip;
my $sth = $DBH->prepare("insert into zipcodes (zipcode, city, state_code, lon_lat) values (?,?,?,?)");
while (<>) {
    chomp;
    tr/\r//d;
    if (($zipcode, $city, $state, $latitude, $longitude)
    	= /^\"D\",\"([0-9]+)\"(?:,\"[^\"]*\"){7},\"([^\"]+)\"(?:,\"[^\"]*\"){4},\"([^\"]+)\"(?:,\"[^\"]*\"){2},([0-9\.\-]+),([0-9\.\-]+),/o) {
        # we  only insert unique zipcodes
        unless ($zipcode eq $lastzip) {
        	$sth->execute( $zipcode, $city, $state, "($longitude,$latitude)") || die "Can't insert $zipcode in database: $_";
        }	
        $lastzip = $zipcode;
    } else {
# If you uncomment this, you will get all sorts of bad lines for APO and
# FPO sites, as well as some sites without latitude and longitude data
#	print "BAD LINE\n$_\n;";
    }
}

$DBH->disconnect;
