#!/usr/local/bin/perl
###################################################################
#                                                                 #
#                      CGI-PROTECTION - Verso "Free"             #
#                                                                 #
#                           By                                    #
#                                                                 #
#                   www.CGiFacil.com.br                           #
#               Aqui Voc Realmente Aprende                       #
#                                                                 #
#     Dvidas com Esse cgi ? http://www.cgifacil.com.br/forum     #
#                                                                 #
#           *ltima Modificao: 06/12/2000                       #
#  IMPORTANTE que voc envia os arquivos via FTP em modo ASCII ! #
#                                                                 #
###################################################################
#        Autor: Pablo William                                     #                                    
#        Email: pablo@internet-rn.com.br                          #
#        Natal-RN  / Brasil                                       # 
###################################################################

### Variveis e Opes:

# Para $savefile = 1, Mostra se existe a permio para escrever o arquivo.
# D Chmod 777 nos diretrios onde se encontraram os arquivos a serem gravados e onde se encontram os CGI's.

$savefile = 1;   # 0 = Display Only, 1 = Save to file

# Comment out $save_as to save as actual sent filename.
# Cria o arquivo "secure.txt" especificado com permisses 777.
$save_as = 'secure.txt';

# Prefixo do Path onde ser salvo o arquivo protegido (SECURE.TXT)
$file = '/data1/hypermart.net/MEMBRO/cgi-bin/';

################### Fim das Configuraes ##############################

# Get POST input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

# Look for separator beginning "--"
if ($buffer =~ /^\-\-/) {
   &get_file;	# file upload
} else {
   &get_text;	# text area upload
}

print "Content-type: text/html\n\n";
print "FILE UPLOAD PROTECT<BR>\n\n";
print "Seu Arquivo foi enviado com Sucesso!.\n\n";

# File sent is now in $FORM{'userfile'}
# Only display text file contents
if ($FORM{'filetype'} =~ /text/) {
   print "\n-----FILE-CONTENTS-----\n";
   print $FORM{'userfile'};
   print "----------EOF----------\n\n";
}
unless ($savefile && $FORM{'filename'}) {
   print "\nThis was just a demo, the file was not saved\n";
   exit;
}

# Remove path from uploaded filename (MSIE fix)
# Filename can contain dash, alphanumeric, _  or dot.
if ($FORM{'filename'} =~ /([-\w.]*)$/) {
   $FORM{'filename'} = $1;
} else {
   print "Invalid filename $FORM{'filename'}\n";
   exit;
}

# Add code here to disallow unwanted filenames
# like .htaccess, index.html, etc.

# Fixed or user provided filename?
unless ($save_as) {
   $save_as = $FORM{'filename'};
}
$file .= $save_as;
print "Save As: $file\n";

# Save the file (already checked if allowed)
if (open (OUT,">$file")) {
   print OUT $FORM{'userfile'};
   close OUT;
   print "File $FORM{'filename'} saved as $save_as\n";
} else {
	print "\nCan't save $file: $!\n";
}

##############
# Subroutines

sub get_file {
   local($sep, $type, $file) = undef;
   local(@buffer) = split(/\n/, $buffer);
   # Get separator string
   $sep = shift(@buffer);
   $sep = $1 if $sep =~ /([\S]+)/;

   # Get filename and content type
   while ($#buffer) {
      local($name, $value) = undef;
      $type = shift(@buffer);
      $name = $file = $type;
      $type = $1 if $type =~ /^Content-Disposition: ([^;]+)/i;
      $name = $1 if $name =~ /\sname=\"([^\"]+)/i;

      if ($file =~ /\sfilename=\"([^\"]+)/i) {
         $FORM{'filename'} = $1;
#         print "Filename = $FORM{'filename'}\n";

         $type = shift(@buffer);
         if ($type =~ /Content-Type: ([^\s]+)/i) {
            $FORM{'filetype'} = $1;
#            print "Content-Type = $FORM{'filetype'}\n";
         } else {
            unshift(@buffer, $type);
         }
      }

      # Get file contents or other variables
#      print "Getting file contents...\n";
      shift(@buffer);
      while ($#buffer) {
         $_ = shift(@buffer);
         last if /$sep/;
         $value .= "$_\n";
      }
      $value =~ s/\r?\n$//;	# prune trailing CR/LF from multipart
      $FORM{$name} = $value;
#      print "Got file data\n";
   }
}

sub get_text {
# Get text area
# Split the name-value pairs
   local(@pairs, $pair, $name, $value) = undef;
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

   # Un-Webify plus signs and %-encoding
      $name =~ tr/+/ /;
      $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      # $value =~ s/<!--\#(.|\n)*-->//g;	# uncomment to strip SSI's

#      print "$name = $value\n";
      $FORM{$name} = $value;
   }
   # End text file with newline if not
   if ($FORM{'userfile'}) {
      $FORM{'userfile'} .= "\n" unless ($FORM{'userfile'} =~ /[\r\n]$/);
   }
   # In case you want to check later if file is text or binary
   $FORM{'filetype'} = "text" if $FORM{'userfile'};
}

