#!/usr/bin/perl
#######################################################
#		404 Manager version 1.0
#
#     	Created by: Solution Scripts 
# 		Email: solutions@solutionscripts.com
#		Web: http://solutionscripts.com
#
#######################################################
#
#
# COPYRIGHT NOTICE:
#
# Copyright 2000 Solution Scripts  All Rights Reserved.
#
# This program is being distributed as freeware.  It may be used and
# modified free of charge, so long as this copyright notice, the header 
# above and all the footers in the program that give me credit remain 
# intact. Please also send me an email, and let me know 
# where you are using this script. 
#
# By using this program you agree to indemnify Solution Scripts from any liability.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  Obtain permission before redistributing this
# program over the Internet or in any other medium.  In all cases
# copyright and header must remain intact.
#
######################################################

### DATA DIRECTORY ##
my $data_path = "d:/cgi-bin/free/404manager/data";
	# Location you want 404 Manager data files stored in
	# Must be writable by the server, (chmod 666 most cases)
	# There will be a lot of data files.

#### REMOVES 404's NOT ACTIVE AFTER THIS MANY DAYS ####
## SET HIGH IF YOU DON"T WANT IT TO AFFECT YOUR REFERERS ###
my $total_day  = 10;

####################
# OPTIONAL OPTIONS #
####################

# ALTERNATING TABLE COLORS
my @colors = ('silver','Gainsboro');

##################
## EDIT NO MORE ##

use Fcntl;
use AnyDBM_File;
use Config;
use strict;
use vars qw(%INPUT);

my $current_time = time();
my $time = time;
(my $sec,my $min,my $hour,my $mday,my $mon,my $year,my $wday,my $yday,my $isdst) = localtime($time);
$year += 1900;
$mon++;
my $now = "$mon.$mday.$year";

my $uri = 0;
my $db = "$data_path/notfound";

print "Content-type: text/html\n\n";
if ($ENV{'QUERY_STRING'}) {
	my $fnfdb = $ENV{'QUERY_STRING'};
	$fnfdb =~ s/\//_/g;
	$fnfdb =~ s/\./_/g;
	
	$db = "$data_path/$fnfdb";
	$uri = 1;
}

my %INPUT;
read(STDIN, my $buffer, $ENV{'CONTENT_LENGTH'});
my @pairs = split(/&/, $buffer);
foreach my $pair (@pairs) {
	(my $name, my $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($INPUT{$name}) { $INPUT{$name} = $INPUT{$name}.",".$value; }
	else { $INPUT{$name} = $value; }
}
my $cgiurl = $ENV{'SCRIPT_NAME'};

unless ($INPUT{'from'}) { $INPUT{'from'} =1; }
unless ($INPUT{'to'}) { 
	$INPUT{'to'} =100;
	$INPUT{'to'} =1000000 if $uri;
}
if ($INPUT{'to'} eq "all") { $INPUT{'to'} =1000000; }
if ($INPUT{'today'}) {
	$INPUT{'from'} =1;
	$INPUT{'to'} =1000000;
}


my @filters = split(/\,/,$INPUT{'filter'});

print qq~
<HTML><HEAD>
<TITLE>404 Manager</TITLE>
<style type="text/css">
  body { font-size: 9pt; font-family: helvetica,arial; }  
  td { font-size: 9pt; font-family: helvetica,arial; }
</STYLE>
<HEAD>
<BODY vlink = SlateBlue link=black alink=#FF0000>
<h2 align=center>404 Manager</H2><BR>
~;

unless ($uri) {
	print qq~
	<form action="$cgiurl" method="POST">
	Show from &nbsp;<input type="Text" name="from" value="$INPUT{'from'}" size="4"> &nbsp;to&nbsp;<input type="Text" name="to" value="$INPUT{'to'}" size="4">
	&nbsp;&nbsp;&nbsp;<input type="Submit" name="submit" value = "Submit"><BR><BR>
	Show urls that first 404'd on <input type="Text" name="today_date" value="$now" size="8">
	&nbsp;&nbsp;&nbsp;<input type="Submit" name="today" value = "Submit">
	</form>
	~;
}


my $flags = O_CREAT | O_RDWR;

tie(my %acc, 'AnyDBM_File', $db , $flags, 0666) || &error("Cannot open database-- $db");

my $days=0;
my $months=0;
my $nums = 0;
my $total_count=0;
my $new_count =0;
my @sort ='';
foreach my $key (keys %acc) {
    my $value = $acc{$key};
	my @reffer_array = split(/\|/,$value);

	if ($now eq $reffer_array[5]){
		$days += $reffer_array[6] 
	}
	if ($mon eq $reffer_array[7]){
		$months += $reffer_array[8] 
	}
	
	$total_count = $total_count + $reffer_array[0];
	my $new_count = $new_count + $reffer_array[2];
	$sort[$nums] = "$reffer_array[0]||$key";
	$nums++;
	}

unless ($uri) {
	print qq~
	<BR>
	<B><font color=red>$total_count</FONT></B> Total 404 hits counted<BR>
	on <B><font color=red>$nums</FONT></B> different pages<BR>
	<B><font color=red>$days</FONT></B> today<BR>
	<B><font color=red>$months</FONT></B> this month<BR>
	With <B><font color=red>$new_count</FONT></B> since last checked
	<BR><br>
	<TABLE border=0 cellpadding=2><tr bgcolor=CornflowerBlue>
	<TD align=center><B>Rank</B></TD>
	<TD align=center><B>Hits</B></TD>
	<TD align=center><B>New</B></TD>
	<TD align=center><B>Day</B></TD>
	<TD align=center><B>Today</B></TD>
	<TD align=center><B>Month</B></TD>
	<TD align=center><B>Page URI</B></TD>
	</TR>
	~;
}
else {
	print qq~
	<BR>
	<B><font color=red>$total_count</FONT></B> Total 404 hits for <font color=red><B>$ENV{'QUERY_STRING'}</B></FONT> <BR>
	from <B><font color=red>$nums</FONT></B> different pages<BR>
	<B><font color=red>$days</FONT></B> today<BR>
	<B><font color=red>$months</FONT></B> this month<BR>
	With <B><font color=red>$new_count</FONT></B> since last checked
	<BR><br>
	<TABLE border=0 cellpadding=2><tr bgcolor=CornflowerBlue>
	<TD align=center><B>Rank</B></TD>
	<TD align=center><B>Hits</B></TD>
	<TD align=center><B>New</B></TD>
	<TD align=center><B>Day</B></TD>
	<TD align=center><B>Today</B></TD>
	<TD align=center><B>Month</B></TD>
	<TD align=center><B>Refered URL</B></TD>
	</TR>
	~;
}	


my @sorteddata = sort {$a <=> $b } @sort;
my @revsort = reverse(@sorteddata);

my $color = 0;
my $day;
my $dayy;
my $num=0;
my $nnum=0;
my $print_out = 0;
my $print_now = '';

foreach my $line (@revsort) {

	my @sorted_array = split(/\|\|/,$line);
	my $key = @sorted_array[1];
    my $value = $acc{$key};
	my @reffer_array = split(/\|/,$value);

	$num++;	

	if ($num == $INPUT{'from'}) { $print_out =1; }
	if ($INPUT{'today'}) {
		if ($reffer_array[4] eq $INPUT{'today_date'}) { $print_out =1; }
		else { $print_out =0; }		
	}
	my $ffil="";	
	foreach my $fil(@filters) {
		if ($key =~ /$fil/i) { $ffil="$fil"; } 
	}
	if ($ffil) { $print_now=0; }
	else { $print_now =1; }
	
	if ($print_out && $print_now) {
		print"<TR bgcolor=$colors[$color]><TD align=center width=10>$num</TD><TD align=center>$reffer_array[0]</TD><td align=center>";
	}
	if ($reffer_array[2]){
		if ($print_out && $print_now) { print"$reffer_array[2]"; }
		$reffer_array[2] = 0;
		$nnum = $num-1; 
		$acc{$key} = join("\|",@reffer_array);
		}
		else { if ($print_out && $print_now) { print" - "; } }
		if ($print_out && $print_now) { print "</TD><td align=center width=10>"; }
		if ($reffer_array[3]){
			$dayy = $current_time - $reffer_array[3];
			$day = $dayy / 86400;
			$day = int($day);
			if ($print_out && $print_now) {
				if ($day) { print "$day"; }
				else { print"-"; }
			}
		}
		else { if ($print_out && $print_now) { print "N.A."; } }
		if ($day > $total_day) { delete ($acc{$key}); }
		if ($print_out && $print_now) { print "</TD><td align=center width=10>"; }
		if ($reffer_array[5] eq $now){ if ($print_out && $print_now) { print "$reffer_array[6]"; } }
		else { if ($print_out && $print_now) { print "0"; } }
		if ($print_out && $print_now) { print "</TD><td align=center width=10>"; }
		if ($reffer_array[7] eq $mon){ if ($print_out && $print_now) { print "$reffer_array[8]"; } }
		else { if ($print_out && $print_now) { print "0"; } }
		if ($print_out && $print_now) {
			print"</TD><TD width=100\%><a href=\"$cgiurl?$key\" TARGET=\"_blank\">$key</a></TD></TR>\n" unless $uri;
			print"</TD><TD width=100\%><a href=\"$key\" TARGET=\"_blank\">$key</a></TD></TR>\n" if $uri;
			if ($color) { $color=0; }
			else { $color++; }
		}
		if ($num == $INPUT{'to'}) { $print_out =0; }
}
untie (%acc);
print "</TABLE><center><br>\n";
print "<hr width=525 noshade size=1><A HREF=\"http://solutionscripts.com\">404 Manager </a>v1.0<br>Free from <A HREF=\"http://solutionscripts.com\">Solution Scripts</A><BR><BR>";
exit;



sub error {

print qq~
<HTML><BODY>
<TABLE border=0 align=center>
<TR><TD><FONT FACE=arial size=-1>
<B>Error</B> - $_[0] - $!
<BR><BR>
Any and all problems regarding the running and using of 404 Manager<BR>
should be posted on our help forum at:<BR>
<A HREF="http://forum.solutionscripts.com/forum"><B>http://forum.solutionscripts.com</B></A>
<BR><BR>
<A HREF="http://solutionscripts.com"><B>Solution Scripts</B></A><BR><BR>
~;

exit;
}

sub sort_hashs {
	my $x = shift;
	my %array = %$x;
	sort { $array{$b} <=> $array{$a}; } keys %array;

}

1;