/************************************************************************
 *   Yanf - Yet Another News Fetcher src/yanf.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "parser.h"
#include "common.h"
#include "setup.h"

void init(void);
void finish(void);
void usage(char *proggie);
int main(int argc, char *argv[]);

int main(int argc, char *argv[]) {
    if(argc < 2) {
	usage(argv[0]);
    }else if(argc > 2) {
	filename = (char *)malloc(sizeof(argv[2]));
	memcpy(filename, "\0", sizeof(filename));
	strncpy(filename, argv[2], strlen(argv[2]));
    }else {
    	filename = (char *)malloc(sizeof(PAGE));
	strcpy(filename, PAGE);
    }
    
    settings = malloc(sizeof(struct globalset));
    
    parse_main(argv[1]); /* init is called from lunchfunc() */

    finish();

    free(filename);
    free(settings);
    exit(0);
}

void init(void) {
    char temp[2048];
    time_t curtime;
    FILE *fout;    

    if((fout = fopen(filename, "w")) == NULL) {
	printf("Could Not Open The Output File.. =(\n");
	perror("fopen");
        exit(1);
    }

    time(&curtime); /* Get time of day */
    strcpy(temp, settings->start);
    if(2048 - strlen("$DATE") + strlen(ctime(&curtime)) >= 0)
	repstr(temp, temp, "$DATE", ctime(&curtime), sizeof(temp));
    if(2048 - strlen("$VERSION") + strlen(VERSION) >= 0)
	repstr(temp, temp, "$VERSION", VERSION, sizeof(temp));
    repstr(temp, temp, "\\n", "\n", sizeof(temp));
    fputs(temp, fout);
    fflush(fout);
}

void finish(void) {
    char temp[2048];
    time_t curtime;
    FILE *fout;

    time(&curtime); /* Get time of day */
    if((fout = fopen(filename, "a")) == NULL) {
	printf("Could Not Open The Output File.. =(\n");
	perror("fopen");
        exit(1);
    }
    strcpy(temp, settings->end);
    if(2048 - strlen("$DATE") + strlen(ctime(&curtime)) >= 0)
	repstr(temp, temp, "$DATE", ctime(&curtime), sizeof(temp));
    if(2048 - strlen("$VERSION") + strlen(VERSION) >= 0)
	repstr(temp, temp, "$VERSION", VERSION, sizeof(temp));
    repstr(temp, temp, "\\n", "\n", sizeof(temp));
    fputs(temp, fout);
}

void usage(char *proggie) {
    printf("Yet Another News Fetcher v%s", VERSION);
    printf(", Copyright (C) 2000 Gaston Kleiman (yanf@gmx.net)\n");
    printf("Yet Another News Fetcher comes with ABSOLUTELY NO WARRANTY;");
    printf(" This is free software, and you are welcome to redistribute it");
    printf(" under certain conditions; View the file COPYING for more details\n");
    printf("Usage: %s configfile <output file>\n", proggie);
    exit(0);
}
		    
