#include "common.h"
#include "setup.h"
#include "prototypes.h"

extern void init(void);
void parse_config(char *file, struct sites *sitestart);
int parse_and_do(char buf[], struct sites *sitestart, struct sites *newsite);
int find_type(struct sites *newsite, char *buf);
struct sites *sitefend(struct sites *startsite);
void addsite(struct sites *startsite, struct sites *newsite);
void printsites(struct sites *startsite);
void lunchfunc(struct sites *startsite);
void sitesfree(struct sites *sitestart);
char *strip_n(char *s);

struct pagetype pagetypes[] = {
    {"bebits", bebits},
    {"32bitson", bo},
    {"fresh", fresh},
    {"ltoday", ltoday},
    {"pstorm", pstorm},
    {"segfault", seg},
    {"slash", slash},
    {"gnews", gnews},
    {"ufie", ufie},
    {"linux2000", l2news},
    {"rdf", rdf},
    {"secfocus", sec},
    {NULL, NULL}
};
int stage = 0;
int global = 0;
int nsites = -1; /* number of sites */

void parse_main(char *file) {
    struct sites *sitestart = NULL;
    struct sites *first = NULL;

    sitestart = malloc(sizeof(struct sites));
    sitestart->next = NULL;
    strcpy(sitestart->name, "");
    sitestart->counter = -1;
        
    parse_config(file, sitestart);

    if(sitestart->next != NULL) {
        first = sitestart;
	sitestart = sitestart->next;
	free(first);
    }else {
	if(!strcmp(sitestart->name, "")) /* if the first site == "", we exit */
	    exit(0);
    }
#ifdef DEBUG
    printsites(sitestart);
#endif
    lunchfunc(sitestart);
    sitesfree(sitestart);
}

void parse_config(char *file, struct sites *sitestart) {
    struct sites *newsite = NULL;
    char heh[2048];
    FILE *fin;
    int i = 0;
    
    if((fin = fopen(file, "r")) == NULL) {
	printf("Could Not Open The Config File.. =(\n");
        exit(1);
    }
    
    newsite = (struct sites *)malloc(sizeof(struct sites));
    strcpy(newsite->output, "");
    newsite->counter = -1;
    
    while(!feof(fin)) {
	memcpy(heh, "\0", sizeof(heh));
	fgets(heh, 2048, fin);
	if(!parse_and_do(heh, sitestart, newsite) == 1) {
	    printf("Error (%s:%d): %s\n", file, i, heh);
	    exit(1);
	}
	i++;
    }
    if(strcmp(newsite->name, "")) /* if the last site != "", we add it */
        addsite(sitestart, newsite);
}

int parse_and_do(char buf[], struct sites *sitestart, struct sites *newsite) {
    unsigned int i = 0;
    char *command = NULL;

    if(!strcmp(buf, "") || buf[0] == '#' || buf[0] == 10)
	return 1;

    if(buf[0] == EOF) {
	addsite(sitestart, newsite);
	return 1;
    }
    
    if(buf[0] == '[') {
	*strchr(buf, ']') = '\0';
	if(!stage) {
	    if(!strncmp(buf + 1, "global", 6)) {
		stage = 0;
		global = 1;
		return 1;
	    }
	    strncpy(newsite->name, ++buf, 2048);
	    stage = 1;
	    global = 0;
	    return 1;
	}
	addsite(sitestart, newsite);
	if(!strncmp(buf + 1, "global", 6)) {
	    stage = 0;
	    global = 1;
	    return 1;
	}
	strncpy(newsite->name, ++buf, 2048);
	global = 0;
        return 1;
    }
    
    strip_n(buf);
    
    if((command = (char *)strtok(buf, "=")) == NULL)
            return 0;
	    
    if(!strncmp(command, "type", 4)) {
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;	
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command))
		return 0;
	    command++;
	}
	if(!find_type(newsite, command))
	    return 0;
#ifdef DEBUG
	printf("Type: %s\n", command);
#endif
	return 1;
    }
    if(!strncmp(command, "url", 3)) {
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command)) {
		strncpy(newsite->url, "", 2048);
		return 1;
	    }
	    command++;
	}
	strncpy(newsite->url, command, 2048);
	return 1;
    }
    if(!strncmp(command, "output", 6)) {
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command)) {
		strncpy(newsite->output, "", 2048);
		return 1;
	    }
	    command++;
	}
	strncpy(newsite->output, command, 2048);
	return 1;
    }
    if(!strncmp(command, "max", 3)) {
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command)) {
		newsite->counter = -1;
		return 1;
	    }
	    command++;
	}
	newsite->counter = atoi(command);
	return 1;
    }
    if(!strncmp(command, "start", 5)) {
	if(!global)
	    return 0;
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command)) {
		strncpy(settings->start, "", 2048);
		return 1;
	    }
	    command++;
	}
	strncpy(settings->start, command, 2048);
	return 1;
    }
    if(!strncmp(command, "end", 3)) {
	if(!global)
	    return 0;
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command)) {
		strncpy(settings->end, "", 2048);
		return 1;
	    }
	    command++;
	}
	strncpy(settings->end, command, 2048);
	return 1;
    }
    if(!strncmp(command, "persite", 7)) {
	if(!global)
	    return 0;
	if((command = (char *)strtok(NULL, "\0")) == NULL)
            return 0;
	for(i = 0; command[0] == ' '; i++) {
	    if(i == strlen(command)) {
		strncpy(settings->persite, "", 2048);
		return 1;
	    }
	    command++;
	}
	strncpy(settings->persite, command, 2048);
	return 1;
    }
    return 0;
}

int find_type(struct sites *newsite, char *buf) {
    struct pagetype *curtype;  

    for(curtype = pagetypes;curtype->pagetype != NULL;curtype++) {
	if(!strncasecmp(buf, curtype->pagetype, strlen(curtype->pagetype))) {
	    newsite->pagefunc = (void *) curtype->pagefunc;
	    return 1;
	}
    }
    return 0;
}

void addsite(struct sites *startsite, struct sites *newsite) {
    struct sites *lastsite = NULL;
    
    if(!strcmp(newsite->output, ""))
	return;
    lastsite = (struct sites *) sitefend(startsite);
    lastsite->next = (struct sites *)malloc(sizeof(struct sites));

    strcpy(lastsite->next->url, newsite->url);
    lastsite->next->pagefunc = newsite->pagefunc;
    
    lastsite->next->sitegurl = parse_url(newsite->url);
    lastsite->next->sitegurl->counter = newsite->counter;
    strcpy(lastsite->next->sitegurl->name, newsite->name);
    strcpy(lastsite->next->sitegurl->output, newsite->output);
    
    lastsite->next->next = NULL;

    strcpy(newsite->name, "");
    strcpy(newsite->url, "");
    strcpy(newsite->output, "");
    newsite->pagefunc = NULL;
    newsite->counter = -1;

    nsites++;

#ifdef DEBUG
    printf("Name: %s\nUrl: %s\nHost: %s\nFile: %s\n", lastsite->next->sitegurl->name, lastsite->next->url, lastsite->next->sitegurl->host, lastsite->next->sitegurl->file);
    printf("Added!!\n");
#endif
}

void printsites(struct sites *startsite) {
    struct sites *n = NULL;
    int i = 0;
    n = startsite;
    
    while(1) {
	printf("%d. Name: %s\nUrl: %s\nHost: %s\nFile: %s\n", i, n->sitegurl->name, n->url, n->sitegurl->host, n->sitegurl->file);
	fflush(NULL);
	if(n->next == NULL)
	    break;
	n = n->next;
	i++;
    };
}		

struct sites *sitefend(struct sites *startsite) {
    struct sites *n;
    n = startsite;
    
    while(1) {
	if(n->next == NULL)
	    break;
        n = n->next;
    }
    return (n);
}		

char *strip_n(char *s) {
    char *p;

    if( (p=(char *)strchr(s, '\n')) != NULL ) (*p) = '\0';
	return s;
}		

void lunchfunc(struct sites *startsite) {
    struct sites *n = NULL;
    int i = 0;
    int *pids = NULL;
#ifndef DEBUG
    key_t key;
    int msgqueue_id;
    struct mymsgbuf *qbuf;
    struct mymsgbuf tqbuf;
    int cexit = 0;
    int cpid = 0;
    int value = 0;
#endif

    n = startsite;
    pids = calloc(nsites, sizeof(int));

    init();    
    while(n != NULL) {
#ifdef DEBUG 
/* If DEBUG is defined, we dont use fork */
	printf("Running funct number: %d\n", i);

        n->pagefunc (n->sitegurl, 0);
        i++;
        n = n->next;
    };
#else
/* If DEBUG is not defined, we fork before calling the functions */
	if(!(cpid = fork())) {
	    n->pagefunc (n->sitegurl, (long) i + (long) 1);
	    exit(0);
	}
	pids[i] = cpid;
	cexit++;
	i++;
	n = n->next;
    };
#endif

#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
        perror("msgget");
        exit(1);
    }
    for(i = 0; i <= nsites;i++) {
	qbuf->mtype = (long) i + (long) 1;
	strcpy(qbuf->mtext, "");
        if((msgsnd(msgqueue_id, qbuf, strlen(qbuf->mtext)+1, 0)) == -1) {
	    perror("msgsnd");
	    exit(1);
	}
	waitpid(pids[i], NULL, 0);
    }
    msgctl(msgqueue_id, IPC_RMID, 0);
#endif
#ifndef DEBUG
/* We only need this when we use fork */
    while(cexit > 0) {
        value = waitpid(0, NULL, 0);
	if(value == -1) {
	   cexit = 0;
	} else {
	   cexit--;
	}
    }
#endif
}		

void sitesfree(struct sites *sitestart) {
    struct sites *n;
    struct sites *c;
    
    c = sitestart;
    n = NULL;
    
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
