/************************************************************************
 *   Yanf - Yet Another News Fetcher src/get.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

struct gurl *parse_url(char *arg) {
    int i = 0;
    char *host;
    char *path;
    char *file;
    
    struct gurl *temp_url;

    temp_url = (struct gurl *) malloc(sizeof(struct gurl));
    /* We set the struct up to NULL  */
    strcpy(temp_url->host, "");
    strcpy(temp_url->path, "/");
    strcpy(temp_url->file, "");
    
    /* if arg is empty we exit */
    if(arg == NULL) {
#ifdef DEBUG
	printf("Arg is empty!\n");
#endif /* DEBUG */
	return(temp_url);
    }

    if((temp_url->cache = tmpfile()) == NULL) {
	printf("Could Not Open The Output File.. en el tmpfile=(\n");
	perror("tmpfile");
        exit(1);
    }
    
    /* if arg starts with 'http://', we skip that */
    if(strncmp("http://", arg, 7) == 0)
	arg += 7;
    
    /* looks up for the first '/' */
    i = 0;
    while(arg[i] && arg[i] != '/') {
	i++;
    };
    host = (char *) malloc(i + 1);
    memcpy(host, arg, i);
    host[i] = '\0';
    
    strncpy(temp_url->host, host, sizeof(temp_url->host));
    if(temp_url->host[strlen(temp_url->host)] != '\0')
	temp_url->host[strlen(temp_url->host)] = '\0';
    arg += i;

    /* if no '/' is found we return the host */
    if(strlen(arg) == 0 || strlen(arg) == 1) {
        return(temp_url);
    }

    /* looks up for the last '/' */
    i = strlen(arg);
    while(i >= 0 && arg[i] != '/') {
	i--;
    };
    path = (char *) malloc(i + 2);
    memcpy(path, arg, i + 1);
    path[i + 1] = '\0';

    strncpy(temp_url->path, path, sizeof(temp_url->path));
    if(temp_url->path[strlen(temp_url->path)] != '\0')
	temp_url->path[strlen(temp_url->path)] = '\0';
    arg += i + 1;

    file = (char *) malloc(strlen(arg) + 1);
    memcpy(file, arg, strlen(arg) + 1);
    strncpy(temp_url->file, file, sizeof(temp_url->file));
    if(temp_url->file[strlen(temp_url->file)] != '\0')
	temp_url->file[strlen(temp_url->file)] = '\0';

#ifdef DEBUG
    printf("Host %s\nPath %s\nFile %s\n\n", temp_url->host, temp_url->path,temp_url->file);
#endif /* DEBUG */
    free(host);
    free(path);
    free(file);

    return(temp_url);
}
    

int get(struct gurl *url) {
    int sfd; 	              
    char buf[2048];
    char cmd[2048];
    char c;
    int nread = 0;
    struct hostent *hent = NULL;
    struct sockaddr_in thaddr;
    int i = 0;
    int out_fd;
    
    if( (sfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
	printf("Error With Socket...\n\n");
	fclose(url->cache);
	exit(1);
    }

    if( (hent = gethostbyname(url->host)) == NULL ) {
        printf("Couldnt resolve [%s]\n", url->host);
	herror(NULL);
	fclose(url->cache);
	exit(1);
    }

    thaddr.sin_family = AF_INET;
    thaddr.sin_port = htons(80); 
    thaddr.sin_addr.s_addr = *(long *)hent->h_addr; /* IP */
    bzero(&(thaddr.sin_zero), 8); /* zero out the zero portion */

    if( connect(sfd, (struct sockaddr *)&thaddr, sizeof(struct sockaddr)) == -1) {
	printf("\nError Connecting...\n");
	perror("connect");
	fclose(url->cache);
	exit(1);
    }
#ifdef DEBUG
    printf("Connected to %s\n", url->host);
#endif /* DEBUG */
    snprintf(cmd, 2048, "GET %s%s HTTP/1.0\r\nUser-Agent: %s\r\nHost: %s\r\n\r\n", url->path, url->file, USER_AGENT, url->host);

    write(sfd, cmd, strlen(cmd)); /* Cmd is the string to send to the server */
#ifdef DEBUG
    printf("Sending: %s", cmd);
#endif /* DEBUG */
    for(i = 0; read(sfd, &c, 1) ; i++) { /* We read the first http header */
	buf[i] = c;
        if(buf[i] == '\n')
	    break;
    }

    if(strncmp("HTTP", buf, 4) != 0) { /* If the first header dont start with HTTP */
	printf("Did not get a normal HTTP response from server.\n");
	fclose(url->cache);
	exit(1);
    }

    /* get up afer first space after HTTP */
    i = 5;
    while(buf[i] != ' ') {
	i++;
    }
    i++; /* skip to char after space */

    if((buf[i] == '4') || (buf[i] == '5')) {
	printf("Server returned error:\n %s\n", buf);
	fclose(url->cache);
	exit(1);
    }

    /* Skip all the headers */
    for(i = 0; read(sfd, &c, 1); i++) {
	if(c == '\n') {
	    if(i == 2) {
		break; 
	    } 
	i = 0;
	}
    }

    /* gets fd from url->cache FILE stream... */
    out_fd = fileno(url->cache);
  
    while( (nread = read(sfd, buf, 2048)) ) {
	if(write(out_fd, buf, nread) < 0) {
	    printf("get %s: Could Not Write To The Output File.. =(\n", url->name);
	    perror("write");
	    fclose(url->cache);
	    exit(1);
	}
    }

    close(sfd);
//    rewind(url->cache);
    lseek(out_fd, 0L, SEEK_SET);
    hent = NULL;
    return(0);
}
