/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Ufie.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

char *uparse(FILE *cache);
void ufiehtmlprint(struct gurl *opt, char *picname);

void ufie(struct gurl *opt, int type) {
    char *url;
    struct gurl *ufurl;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    if(!strcmp(opt->output, ""))
	return;
    
    if((get(opt)) == -1)
	exit(1);
    
    url = uparse(opt->cache);
    ufurl = parse_url(url);

    fclose(ufurl->cache);
    free(url);

    if((ufurl->cache = fopen(ufurl->file, "w")) == NULL) {
        printf("%s: Could Not Open The Output File.. =(\n", opt->name);
        perror("fopen");
	exit(1);
    }			
    get(ufurl);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    ufiehtmlprint(opt, ufurl->file);
} 

char *uparse(FILE *cache) {
    char buf[2048];
    char *purl = NULL;
    char *url;
    FILE *fin;    
        
    strcpy(buf, "");
    
    fin = cache;    
    
    while(!feof(fin)) {
	fgets(buf, 2048, fin);
	fflush(NULL);
	purl = (char *)strstr(buf, "Latest Strip");
	if(purl != NULL) {
	    break;
	}
    };
    if(purl == NULL) {
	printf("Bad ufie file!!\n");
	exit(1);
    }
    purl = (char *)strstr(purl, "SRC=");
    purl += strlen("SRC=") + 1;
    purl[strlen(purl) - 7] = '\0'; /* we strip '"></A>' out */
    url = (char *) calloc(strlen(purl), sizeof(char));
    strncpy(url, purl, strlen(purl));
    if(url[strlen(url)] && url[strlen(url)] != '\0')
	url[strlen(url)] = '\0';
    
    fclose(fin);
    return(url);
}

void ufiehtmlprint(struct gurl *opt, char *picname) {
    FILE *fout;
    char temp[2048];
    
    if((fout = fopen(filename, "a")) == NULL) {
        printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
        exit(1);
    }
    strcpy(temp, settings->persite);
    if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
        repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
    if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
        repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
    repstr(temp, temp, "\\n", "\n", sizeof(temp));
    fputs(temp, fout);

    strcpy(temp, opt->output);
    if(2048 - strlen("$PICNAME") + strlen(picname) >= 0)
	repstr(temp, temp, "$PICNAME", picname, sizeof(temp));
    repstr(temp, temp, "\\n", "\n", sizeof(temp));
    fputs(temp, fout);
    
    fclose(fout);
}