/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Slash.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"
//#include "repstr.h"

/*

Slashdot Module

*/

void sparse(FILE *cache, struct sheads *sstart, int counter);
/* parses ultramode.txt */
void shtmlprint(struct sheads *sstart, struct gurl *opt);
void repstr(char *src, char *ds, char *this, char *that, int sod);

struct sheads *sadd(struct sheads *nhead, struct sheads *sstart);
struct sheads *sfend(struct sheads *sstart);
void sfree(struct sheads *sstart);

void slash(struct gurl *opt, int type) {
    struct sheads *sstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;

    sstart = (struct sheads *)malloc(sizeof(struct sheads));
    sstart->next = NULL;
    sstart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    sparse(opt->cache, sstart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    shtmlprint(sstart, opt);
    
    sfree(sstart);
    free(opt);
} 

struct sheads *sadd(struct sheads *nhead, struct sheads *sstart) {
    struct sheads *p;
    struct sheads *n;

    p = sfend(sstart);

    if( (n = (struct sheads *)malloc(sizeof(struct sheads))) == NULL )
        return NULL;
    	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);
    snprintf(n->date, 23, "%s", nhead->date);
    snprintf(n->author, 2048, "%s", nhead->author);
    snprintf(n->dept, 2048, "%s", nhead->dept);
    snprintf(n->storytype, 2048, "%s", nhead->storytype);
    snprintf(n->section, 2048, "%s", nhead->section);
    n->ncom = nhead->ncom;

    return (n);
}

struct sheads *sfend(struct sheads *sstart) {
    struct sheads *n;
    
    n = sstart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void sparse(FILE *cache, struct sheads *sstart, int counter) {
    struct sheads *nhead;

    char dum[2048];
    char ncom[2048];
    FILE *fin;    
    
    nhead = (struct sheads *)malloc(sizeof(struct sheads));
    
    fin = cache;    
    
    while(!feof(fin)) {
	fgets(dum, 2048, fin);
	if((char *) strstr(dum, "%%") != NULL) {
#ifdef DEBUG
	    printf("%% found!\n");
#endif /* DEBUG */	    
	    break;
	}
    };
   
    while (!feof(fin)) {
        if(counter == 0)
	    break;

        if(fgets(nhead->title, 2048, fin) == NULL)
	    break;
	    
        if(fgets(nhead->link, 2048, fin) == NULL)
	    break;

	if(fgets(nhead->date, 2048, fin) == NULL)
	    break;
	    
        if(fgets(nhead->author, 2048, fin) == NULL)
	    break;

        if(fgets(nhead->dept, 2048, fin) == NULL)
	    break;
	
        if(fgets(nhead->storytype, 2048, fin) == NULL)
	    break;
	    
	if(fgets(ncom, 2048, fin) == NULL) /* number of comments */
	    break;
        nhead->ncom = atoi(ncom);
	
        if(fgets(nhead->section, 2048, fin) == NULL)
	    break;

	if(fgets(dum, 2048, fin) == NULL) /* gif of the section */
	    break;
	if(fgets(dum, 2048, fin) == NULL) /* %% */ 
	    break;

        sadd(nhead, sstart);
	
	if(counter != -1)
	    counter--;
    };
    
    free(nhead);
    fclose(fin);
}    	    

void shtmlprint(struct sheads *sstart, struct gurl *opt) {
    FILE *fout = NULL;
    int si = 0;
    struct sheads *c = NULL;
    char temp[2048];
    
    if(sstart->next != NULL) {
	c = sstart->next;
        si = 1;
    }
    
    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }
    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	    if(2048 - strlen("$AUTHOR") + strlen(strip_n(c->author)) >= 0)
		repstr(temp, temp, "$AUTHOR", strip_n(c->author), sizeof(temp));
	    if(2048 - strlen("$DATE") + strlen(strip_n(c->date)) >= 0)
		repstr(temp, temp, "$DATE", strip_n(c->date), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    if(2048 - strlen("$DEPT") + strlen(strip_n(c->dept)) >= 0)
	        repstr(temp, temp, "$DEPT", strip_n(c->dept), sizeof(temp));
	    if(2048 - strlen("$TYPE") + strlen(strip_n(c->storytype)) >= 0)
		repstr(temp, temp, "$TYPE", strip_n(c->storytype), sizeof(temp));
	    if(2048 - strlen("$SECTION") + strlen(strip_n(c->section)) >= 0)
		repstr(temp, temp, "$SECTION", strip_n(c->section), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));

	    if(c->next == NULL) {
		fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;
	}
    }
    fclose(fout);
}

void sfree(struct sheads *sstart) {
    struct sheads *n;
    struct sheads *c;
    
    c = sstart;
    n = NULL;
    
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}