/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Seg.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"
/*

Segfault Module

*/

void segparse(FILE *cache, struct segheads *segstart, int counter);
/* parses ultramode.txt */
void seghtmlprint(struct segheads *segstart, struct gurl *opt);
void segfree(struct segheads *segstart);

struct segheads *segadd(struct segheads *nhead, struct segheads *segstart);
struct segheads *segfend(struct segheads *segstart);

void seg(struct gurl *opt, int type) {
    struct segheads *segstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    segstart = (struct segheads *)malloc(sizeof(struct segheads));
    segstart->next = NULL;
    segstart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    segparse(opt->cache, segstart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    seghtmlprint(segstart, opt);
    
    segfree(segstart);    
    free(opt);
} 

struct segheads *segadd(struct segheads *nhead, struct segheads *segstart) {
    struct segheads *p;
    struct segheads *n;

    p = segfend(segstart);

    if( (n = (struct segheads *)malloc(sizeof(struct segheads))) == NULL )
        return NULL;
    	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);
    snprintf(n->date, 23, "%s", nhead->date);
    snprintf(n->author, 2048, "%s", nhead->author);
    snprintf(n->email, 2048, "%s", nhead->email);
    snprintf(n->storytype, 2048, "%s", nhead->storytype);

    return (n);
}

struct segheads *segfend(struct segheads *segstart) {
    struct segheads *n;
    
    n = segstart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void segparse(FILE *cache, struct segheads *segstart, int counter) {
    struct segheads *nhead;
    char dum[2048];
    FILE *fin;    
    
    nhead = (struct segheads *)malloc(sizeof(struct segheads));
    
    fin = cache;    
    
    while(!feof(fin)) {
	fgets(dum, 2048, fin);
	if((char *)strstr(dum, "%%") != NULL) {
#ifdef DEBUG
	    printf("%% found!\n");
#endif /* DEBUG */    
	    break;
	}
    };
   
    while(!feof(fin)) {
	fgets(dum, 2048, fin);
	if((char *)strstr(dum, "%%") != NULL) {
#ifdef DEFINE
	    printf("%% found!\n");
#endif /* DEBUG */	    
	    break;
	}
    };

    while (!feof(fin)) {
        if(counter == 0)
	    break;
    
        if(fgets(nhead->title, 2048, fin) == NULL)
	    break;
	    
        if(fgets(nhead->link, 2048, fin) == NULL)
	    break;

	if(fgets(nhead->date, 2048, fin) == NULL)
	    break;
	    
        if(fgets(nhead->author, 2048, fin) == NULL)
	    break;

        if(fgets(nhead->email, 2048, fin) == NULL)
	    break;
	
        if(fgets(nhead->storytype, 2048, fin) == NULL)
	    break;
	    
        if(fgets(dum, 2048, fin) == NULL) /* %% */
	    break;
		    	    
        segadd(nhead, segstart);
	
	if(counter != -1)
	    counter--;
    }
    
    free(nhead);
    fclose(fin);
}    	    

void seghtmlprint(struct segheads *segstart, struct gurl *opt) {
    FILE *fout = NULL;
    int si = 0;
    struct segheads *c = NULL;
    char temp[2048];
            
    if(segstart->next != NULL) {
	c = segstart->next;
        si = 1;
    }
    
    if((fout = fopen(filename, "a")) == NULL) {
        printf("%s: Could Not Open The Output File.. =(\n", opt->name);
        perror("fopen");
	exit(1);
    }

    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
    	    if(2048 - strlen("$TYPE") + strlen(strip_n(c->storytype)) >= 0)
    		repstr(temp, temp, "$TYPE", strip_n(c->storytype), sizeof(temp));
    	    if(2048 - strlen("$AUTHOR") + strlen(strip_n(c->author)) >= 0)
    		repstr(temp, temp, "$AUTHOR", strip_n(c->author), sizeof(temp));
    	    if(2048 - strlen("$EMAIL") + strlen(strip_n(c->email)) >= 0)
    		repstr(temp, temp, "$EMAIL", strip_n(c->email), sizeof(temp));
    	    if(2048 - strlen("$DATE") + strlen(strip_n(c->date)) >= 0)
    		repstr(temp, temp, "$DATE", strip_n(c->date), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));
	    if(c->next == NULL) {
		fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;	
	}
    }
    fclose(fout);
}

void segfree(struct segheads *segstart) {
    struct segheads *n;
    struct segheads *c;
    
    c = segstart;
    n = NULL;

    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
