/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Secfocus.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

/*

Securityfocus module

*/


void sechtmlprint(struct sechead **secstart, struct gurl *opt);
void secparse(FILE *cache, struct sechead **secstart, int counter);

struct sechead *secadd(struct sechead *nhead, struct sechead **secstart);
struct sechead *secfend(struct sechead *secstart);
void secfree(struct sechead **secstart);

void sec(struct gurl *opt, int type) {
    struct sechead *secstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    secstart = NULL;

    if((get(opt)) == -1)
	exit(1);

    secparse(opt->cache, &secstart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    sechtmlprint(&secstart, opt);
    
    secfree(&secstart);
    free(opt);
} 

struct sechead *secadd(struct sechead *nhead, struct sechead **secstart) {
    struct sechead *p;
    struct sechead *n;

    p = secfend(*secstart);

    if( (n = (struct sechead *)malloc(sizeof(struct sechead))) == NULL )
	return NULL;
	
    if(p == NULL) {
	*secstart = n;
	p = n;
	n->prev = NULL;
	n->next = NULL;
    } else {
	p->next = n;
        n->prev = p;
        n->next = NULL;
    }
    
    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);
    snprintf(n->type, 2048, "%s", nhead->type);

    return (n);
}

struct sechead *secfend(struct sechead *secstart) {
    struct sechead *n;
    
    n = secstart;

    if(secstart == NULL)
	return (NULL);
	
    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void secparse(FILE *cache, struct sechead **secstart, int counter) {
    struct sechead *nhead = NULL;
    int stage = 0;
    char dum[2048];
    char *temp = NULL;
    char *temp1 = NULL;
    FILE *fin;    
    
    fin = cache;
    
    while (!feof(fin)) {
	if(counter == 0)
	    break;
	    
	strcpy(dum, "");
	temp = NULL;
	temp1 = NULL;
	
        if(fgets(dum, 2048, fin) == NULL)
	    break;

	if((temp = strstr(dum, "<headline>")) != NULL) {
	    stage = 1;
	    nhead = (struct sechead *)malloc(sizeof(struct sechead));
	    strcpy(nhead->title, "");
	    strcpy(nhead->link, "");
	    strcpy(nhead->type, "");
	    continue;
	}

	if(stage == 1) {
	    if((temp = strstr(dum, "<title>")) != NULL) {
		temp += strlen("<title>");
		if((temp1 = strstr(temp, "</title>")) == NULL) {
		    printf("Invalid XML\n");
		    exit(1);
		}
		*temp1 = '\0';

		strncpy(nhead->title, temp, 2048);
		continue;
	    }
	    if((temp = strstr(dum, "<type>")) != NULL) {
		temp += strlen("<type>");
		if((temp1 = strstr(temp, "</type>")) == NULL) {
		    printf("Invalid XML\n");
		    exit(1);
		}
		*temp1 = '\0';

		strncpy(nhead->type, temp, 2048);
		continue;
	    }
	    if((temp = strstr(dum, "<link>")) != NULL) {
		temp += strlen("<link>");
		if((temp1 = strstr(temp, "</link>")) == NULL) {
		    printf("Invalid XML\n");
		    exit(1);
		}
		*temp1 = '\0';

		strncpy(nhead->link, temp, 2048);
	    }
	    if((temp = strstr(dum, "</headline>")) != NULL) {
		secadd(nhead, *&secstart);
		free(nhead);
		stage = 0;
	        if(counter != -1)
	            counter--;
		continue;
	    }
	}
    }
}    	    

void sechtmlprint(struct sechead **secstart, struct gurl *opt) {
    FILE *fout = NULL;
    struct sechead *c = NULL;
    char temp[2048];
    
    c = *secstart;

    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }

    if(c == NULL) {
	fclose(fout);
	return;
    }

    strcpy(temp, settings->persite);
    if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
        repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
    if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
        repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
    repstr(temp, temp, "\\n", "\n", sizeof(temp));
    fputs(temp, fout);

    while(1) {
        strcpy(temp, opt->output);
	if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
	    repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
        if(2048 - strlen("$TYPE") + strlen(strip_n(c->type)) >= 0)
    	    repstr(temp, temp, "$TYPE", strip_n(c->type), sizeof(temp));
	if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
	    repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	if(c->next == NULL) {
	    fputs(temp, fout);
            break;
	}
	fputs(temp, fout);
        c = c->next;	
    }

    fclose(fout);
}

void secfree(struct sechead **secstart) {
    struct sechead *n;
    struct sechead *c;
    
    c = *secstart;
    n = NULL;

    if(c == NULL)
	return;
    
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
