/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Rdf.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

/*

RDF module

*/


void rdfhtmlprint(struct rdfhead **rdfstart, struct gurl *opt);
void rdfparse(FILE *cache, struct rdfhead **rdfstart, int counter);

struct rdfhead *rdfadd(struct rdfhead *nhead, struct rdfhead **rdfstart);
struct rdfhead *rdffend(struct rdfhead *rdfstart);
void rdffree(struct rdfhead **rdfstart);

void rdf(struct gurl *opt, int type) {
    struct rdfhead *rdfstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    rdfstart = NULL;
    qbuf = &tqbuf;
    
    if((get(opt)) == -1)
	exit(1);

    rdfparse(opt->cache, &rdfstart, opt->counter);
#ifndef DEBUG
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    rdfhtmlprint(&rdfstart, opt);
    
    rdffree(&rdfstart);
    free(opt);
} 

struct rdfhead *rdfadd(struct rdfhead *nhead, struct rdfhead **rdfstart) {
    struct rdfhead *p;
    struct rdfhead *n;

    p = rdffend(*rdfstart);

    if( (n = (struct rdfhead *)malloc(sizeof(struct rdfhead))) == NULL )
	return NULL;
	
    if(p == NULL) {
	*rdfstart = n;
	p = n;
	n->prev = NULL;
	n->next = NULL;
    } else {
	p->next = n;
        n->prev = p;
        n->next = NULL;
    }
    
    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);
    snprintf(n->description, 2048, "%s", nhead->description);

    return (n);
}

struct rdfhead *rdffend(struct rdfhead *rdfstart) {
    struct rdfhead *n;
    
    n = rdfstart;

    if(rdfstart == NULL)
	return (NULL);
	
    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void rdfparse(FILE *cache, struct rdfhead **rdfstart, int counter) {
    struct rdfhead *nhead = NULL;
    int stage = 0;
    char dum[2048];
    char *temp = NULL;
    char *temp1 = NULL;
    FILE *fin;    
    
    fin = cache;
    
    while (!feof(fin)) {
	if(counter == 0)
	    break;

	strcpy(dum, "");
	temp = NULL;
	temp1 = NULL;
	
        if(fgets(dum, 2048, fin) == NULL)
	    break;

	if((temp = strstr(dum, "<item>")) != NULL) {
	    stage = 1;
	    nhead = (struct rdfhead *)malloc(sizeof(struct rdfhead));
	    strcpy(nhead->title, "");
	    strcpy(nhead->link, "");
	    strcpy(nhead->description, "");
	    continue;
	}

	if(stage == 1) {
	    if((temp = strstr(dum, "<title>")) != NULL) {
		temp[strlen("<title>") - 1] = '\0';
		temp += strlen("<title>");
		if((temp1 = strstr(temp, "</title>")) == NULL) {
		    printf("Invalid RDF\n");
		    exit(1);
		}
		*temp1 = '\0';

		strncpy(nhead->title, temp, 2048);
		continue;
	    }
	    if((temp = strstr(dum, "<description>")) != NULL) {
		temp[strlen("<description>") - 1] = '\0';
		temp += strlen("<description>");
		if((temp1 = strstr(temp, "</description>")) == NULL) {
		    printf("Invalid RDF\n");
		    exit(1);
		}
		*temp1 = '\0';

		strncpy(nhead->description, temp, 2048);
		continue;
	    }
	    if((temp = strstr(dum, "<link>")) != NULL) {
		temp[strlen("<link>") - 1] = '\0';
		temp += strlen("<link>");
		if((temp1 = strstr(temp, "</link>")) == NULL) {
		    printf("Invalid RDF\n");
		    exit(1);
		}
		*temp1 = '\0';

		strncpy(nhead->link, temp, 2048);
	    }
	    if((temp = strstr(dum, "</item>")) != NULL) {
		rdfadd(nhead, *&rdfstart);
		free(nhead);
		stage = 0;
	        if(counter != -1)
	            counter--;
		continue;
	    }
	}
    }
}    	    

void rdfhtmlprint(struct rdfhead **rdfstart, struct gurl *opt) {
    FILE *fout = NULL;
    struct rdfhead *c = NULL;
    char temp[2048];
    
    c = *rdfstart;

    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }

    strcpy(temp, settings->persite);
    if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
        repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
    if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
        repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
    repstr(temp, temp, "\\n", "\n", sizeof(temp));
    fputs(temp, fout);

    if(c == NULL) {
	fclose(fout);
	return;
    }
    
    while(1) {
        strcpy(temp, opt->output);
	if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
	    repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	if(2048 - strlen("$DESCRIPTION") + strlen(strip_n(c->description)) >= 0)
	    repstr(temp, temp, "$DESCRIPTION", strip_n(c->description), sizeof(temp));
        if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
	    repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	repstr(temp, temp, "\\n", "\n", sizeof(temp));

	if(c->next == NULL) {
	    fputs(temp, fout);
	    break;
	}
	fputs(temp, fout);
        c = c->next;	
    }

    fclose(fout);
}

void rdffree(struct rdfhead **rdfstart) {
    struct rdfhead *n;
    struct rdfhead *c;
    
    c = *rdfstart;
    n = NULL;

    if(c == NULL)
	return;
	
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
