/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Pstorm.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

void psparse(FILE *cache, struct psheads *pstart, int counter);
void pshtmlprint(struct psheads *pstart, struct gurl *opt);

struct psheads *psadd(struct psheads *nhead, struct psheads *pstart);
struct psheads *psfend(struct psheads *pstart);
void psfree(struct psheads *pstart);

void pstorm(struct gurl *opt, int type) {
    struct psheads *pstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;

    pstart = (struct psheads *)malloc(sizeof(struct psheads));
    pstart->next = NULL;
    pstart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    psparse(opt->cache, pstart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    pshtmlprint(pstart, opt);

    psfree(pstart);
    free(opt);
} 

struct psheads *psadd(struct psheads *nhead, struct psheads *pstart) {
    struct psheads *p;
    struct psheads *n;

    p = psfend(pstart);

    if( (n = (struct psheads *)malloc(sizeof(struct psheads))) == NULL )
	return NULL;
	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);
    snprintf(n->date, 2048, "%s", nhead->date);
    snprintf(n->des, 2048, "%s", nhead->des);

    return (n);
}

struct psheads *psfend(struct psheads *pstart) {
    struct psheads *n;
    
    n = pstart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void psparse(FILE *cache, struct psheads *pstart, int counter) {
    struct psheads *nhead;
    int stage = 0;
    int wtf = 1;
    unsigned int len = 2048;
    char dum[2048];
    FILE *fin;    
    
    nhead = (struct psheads *)malloc(sizeof(struct psheads));
    
    fin = cache;    

    while (!feof(fin)) {
        if(counter == 0)
	    break;

	strcpy(nhead->title, "");
	strcpy(nhead->link, "");
	strcpy(nhead->date, "");
	strcpy(nhead->des, "");

        if(fgets(nhead->title, 2048, fin) == NULL)
	    break;
	
        if(fgets(nhead->link, 2048, fin) == NULL)
	    break;
	
	if(fgets(nhead->date, 2048, fin) == NULL)
	    break;

	    while(!feof(fin) && stage < 2) {
		fgets(dum, 2048, fin);
		if(dum[0] == 10) {
		    stage++;
		    continue;
		}
		if(wtf == 1) {
		    if(len >= (strlen(dum) + 1)) {
			strncat(nhead->des, dum, strlen(dum));
			len = len - (strlen(dum) + 1);
		    } else {
			strncat(nhead->des, dum, len - 1); /* we truncate it */
			wtf = 0;
		    }
		}
	    }
        psadd(nhead, pstart);
	
	stage = 0;
	wtf = 1;
	len = 2048;

	if(counter != -1)
	    counter--;
    }

    free(nhead);
    fclose(fin);
}    	    

void pshtmlprint(struct psheads *pstart, struct gurl *opt) {
    FILE *fout = NULL;
    int si = 0;
    struct psheads *c= NULL;
    char temp[2048];
            
    if(pstart->next != NULL) {
	c = pstart->next;
        si = 1;
    }
    
    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }

    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	    if(2048 - strlen("$DATE") + strlen(strip_n(c->date)) >= 0)
		repstr(temp, temp, "$DATE", strip_n(c->date), sizeof(temp));
	    if(2048 - strlen("$DESCRIPTION") + strlen(strip_n(c->des)) >= 0)
		repstr(temp, temp, "$DESCRIPTION", strip_n(c->des), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));
	    if(c->next == NULL) {
		fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;	
	}
    }
    fclose(fout);
}

/*void pshtmlprint(struct psheads *pstart, struct gurl *opt) {
    int si = 0;
    struct psheads *c;
    struct psheads *n = NULL;
        
    if(pstart->next != NULL) {
	c = pstart->next;
        si = 1;
    }
    
    while(1) {
	if(c->next == NULL)
 {
	    printf("Proggie: %s", c->proggie);
	    printf("Link: %s", c->link);
	    printf("Date: %s", c->date);
	    printf("Desc: %s", c->des);
    	    printf("--------------\n");
	    break;
	}
	printf("Proggie: %s", c->proggie);
        printf("Link: %s", c->link);
        printf("Date: %s", c->date);
        printf("Desc: %s", c->des);
        printf("--------------\n");
	c = c->next;	
    } 
}
*/

void psfree(struct psheads *pstart) {
    struct psheads *n;
    struct psheads *c;
    
    c = pstart;
    n = NULL;
    
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
