/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Gnews.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

/*

GeekNews module

*/


void gnhtmlprint(struct gnhead *gnstart, struct gurl *opt);
void gnparse(FILE *cache, struct gnhead *gnstart, int counter);

struct gnhead *gnadd(struct gnhead *nhead, struct gnhead *gnstart);
struct gnhead *gnfend(struct gnhead *gnstart);
void gnfree(struct gnhead *gnstart);

void gnews(struct gurl *opt, int type) {
    struct gnhead *gnstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    gnstart = (struct gnhead *)malloc(sizeof(struct gnhead));
    gnstart->next = NULL;
    gnstart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    gnparse(opt->cache, gnstart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    gnhtmlprint(gnstart, opt);
    
    gnfree(gnstart);
    free(opt);
} 

struct gnhead *gnadd(struct gnhead *nhead, struct gnhead *gnstart) {
    struct gnhead *p;
    struct gnhead *n;

    p = gnfend(gnstart);

    if( (n = (struct gnhead *)malloc(sizeof(struct gnhead))) == NULL )
	return NULL;
	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);
    snprintf(n->desc, 2048, "%s", nhead->desc);

    return (n);
}

struct gnhead *gnfend(struct gnhead *gnstart) {
    struct gnhead *n;
    
    n = gnstart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void gnparse(FILE *cache, struct gnhead *gnstart, int counter) {
    struct gnhead *nhead;

    char dum[2048];
    FILE *fin;    
    
    nhead = (struct gnhead *)malloc(sizeof(struct gnhead));
    
    fin = cache;
        
    while (!feof(fin)) {
        if(counter == 0)
	    break;

        if(fgets(nhead->title, 2048, fin) == NULL)
	            break;
		    
        if(fgets(nhead->link, 2048, fin) == NULL)
	            break;

        if(fgets(nhead->desc, 2048, fin) == NULL)
	            break;

        if(fgets(dum, 2048, fin) == NULL)
	            break;
	
        gnadd(nhead, gnstart);

        if(counter != -1)
	    counter--;
    };

    free(nhead);
    fclose(fin);
}    	    

void gnhtmlprint(struct gnhead *gnstart, struct gurl *opt) {
    FILE *fout = NULL;
    int si = 0;
    struct gnhead *c = NULL;
    char temp[2048];
            
    if(gnstart->next != NULL) {
	c = gnstart->next;
        si = 1;
    }

    if((fout = fopen(filename, "a")) == NULL) {
        printf("%s: Could Not Open The Output File.. =(\n", opt->name);
        perror("fopen");
        exit(1);
    }

    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	    if(2048 - strlen("$DESCRIPTION") + strlen(strip_n(c->desc)) >= 0)
		repstr(temp, temp, "$DESCRIPTION", strip_n(c->desc), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));
	    if(c->next == NULL) {
	        fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;	
	}
    }
    fclose(fout);
}

void gnfree(struct gnhead *gnstart) {
    struct gnhead *n;
    struct gnhead *c;
    
    c = gnstart;
    n = NULL;
    
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
