/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Fresh.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

struct fheads *fadd(struct fheads *nhead, struct fheads *fstart);
struct fheads *ffend(struct fheads *fstart);
void freshfree(struct fheads *fstart);

void freshparse(FILE *cache, struct fheads *fstart, int counter);
void freshhtmlprint(struct fheads *fstart, struct gurl *opt);

struct fheads *ffend(struct fheads *fstart) {
    struct fheads *n;
    
    n = fstart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

struct fheads *fadd(struct fheads *nhead, struct fheads *fstart) {
    struct fheads *p;
    struct fheads *n;

    p = ffend(fstart);

    if( (n = (struct fheads *)malloc(sizeof(struct fheads))) == NULL )
	return NULL;
	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->date, 2048, "%s", nhead->date);
    snprintf(n->link, 2048, "%s", nhead->link);

    return (n);
}

void fresh(struct gurl *opt, int type) {
    struct fheads *fstart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    fstart = (struct fheads *)malloc(sizeof(struct fheads));
    fstart->next = NULL;
    fstart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    freshparse(opt->cache, fstart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    freshhtmlprint(fstart, opt);
    
    freshfree(fstart);
    
    free(opt);
} 

void freshparse(FILE *cache, struct fheads *fstart, int counter) {
    struct fheads *nhead;
    FILE *fin;    

    nhead = (struct fheads *)malloc(sizeof(struct fheads));
    
    fin = cache;
    
    while (!feof(fin)) {
        if(counter == 0)
	    break;

	strcpy(nhead->title, "");
	strcpy(nhead->date, "");
	strcpy(nhead->link, "");

        if(fgets(nhead->title, 2048, fin) == NULL)
	    break;
	
        if(fgets(nhead->date, 2048, fin) == NULL)
	    break;
	
	if(fgets(nhead->link, 2048, fin) == NULL)
	    break;

        fadd(nhead, fstart);
	
	if(counter != -1)
	    counter--;
    }
    
    free(nhead);
    fclose(fin);
}    	    

void freshhtmlprint(struct fheads *fstart, struct gurl *opt) {
    int si = 0;
    FILE *fout = NULL;
    struct fheads *c = NULL;
    char temp[2048];
            
    if(fstart->next != NULL) {
	c = fstart->next;
        si = 1;
    }
    
    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }
    
    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	    if(2048 - strlen("$DATE") + strlen(strip_n(c->date)) >= 0)
		repstr(temp, temp, "$DATE", strip_n(c->date), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));
	    if(c->next == NULL) {
		fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;	
	}
    }
    fclose(fout);
}


void freshfree(struct fheads *fstart) {
    struct fheads *n;
    struct fheads *c;
    
    c = fstart;
    n = NULL;
    
    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
