/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Bitson.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

void boparse(FILE *cache, struct boheads *bostart, int counter);
void bohtmlprint(struct boheads *bostart, struct gurl *opt);
void bofree(struct boheads *bostart);

struct boheads *boadd(struct boheads *nhead, struct boheads *bostart);
struct boheads *bofend(struct boheads *bostart);

struct boheads *bofend(struct boheads *bostart) {
    struct boheads *n;
    
    n = bostart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

struct boheads *boadd(struct boheads *nhead, struct boheads *bostart) {
    struct boheads *p;
    struct boheads *n;

    p = bofend(bostart);

    if( (n = (struct boheads *)malloc(sizeof(struct boheads))) == NULL )
	return NULL;
	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->link, 2048, "%s", nhead->link);

    return (n);
}

void boparse(FILE *cache, struct boheads *bostart, int counter) {
    struct boheads *nhead;

    FILE *fin;    
    
    nhead = (struct boheads *)malloc(sizeof(struct boheads));
    
    fin = cache;

    while (!feof(fin)) {
        if(counter == 0)
	    break;

	strcpy(nhead->title, "");
	strcpy(nhead->link, "");

        if(fgets(nhead->title, 2048, fin) == NULL)
	    break;

        if(fgets(nhead->link, 2048, fin) == NULL)
	    break;
	
        boadd(nhead, bostart);

	if(counter != -1)
	    counter--;

    } 

    free(nhead);
    fclose(fin);
}    	    

void bohtmlprint(struct boheads *bostart, struct gurl *opt) {
    int si = 0;
    FILE *fout = NULL;
    struct boheads *c = NULL;
    char temp[2048];        
    if(bostart->next != NULL) {
	c = bostart->next;
        si = 1;
    }
    
    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }
    
    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));

	    if(c->next == NULL) {
		fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;	
	}
    }
    fclose(fout);
}

void bo(struct gurl *opt, int type) {
    struct boheads *bostart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;

    bostart = (struct boheads *)malloc(sizeof(struct boheads));
    bostart->next = NULL;
    bostart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    boparse(opt->cache, bostart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif
    bohtmlprint(bostart, opt);

    bofree(bostart);
    free(opt);
} 

void bofree(struct boheads *bostart) {
    struct boheads *n;
    struct boheads *c;
    
    c = bostart;
    n = NULL;

    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
