/************************************************************************
 *   Yanf - Yet Another News Fetcher src/Bebits.c
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "setup.h"
#include "common.h"

/*

Bebits module

*/


void behtmlprint(struct behead *bestart, struct gurl *opt);
void beparse(FILE *cache, struct behead *bestart, int counter);
/* parses behead.txt */

struct behead *beadd(struct behead *nhead, struct behead *bestart);
struct behead *befend(struct behead *bestart);
void befree(struct behead *bestart);

void bebits(struct gurl *opt, int type) {
    struct behead *bestart;
    struct mymsgbuf tqbuf;
    struct mymsgbuf *qbuf;
    key_t key;
    int msgqueue_id;
    
    bestart = (struct behead *)malloc(sizeof(struct behead));
    bestart->next = NULL;
    bestart->prev = NULL;

    if((get(opt)) == -1)
	exit(1);

    beparse(opt->cache, bestart, opt->counter);
#ifndef DEBUG
    qbuf = &tqbuf;
    key = ftok(".", 'm');
    if((msgqueue_id = msgget(key, IPC_CREAT|0660)) == -1) {
	perror("msgget");
	exit(1);
    }
    qbuf->mtype = type;
    msgrcv(msgqueue_id, qbuf, 1, type, 0);
#endif

    behtmlprint(bestart, opt);

    befree(bestart);
    free(opt);
} 

struct behead *beadd(struct behead *nhead, struct behead *bestart) {
    struct behead *p;
    struct behead *n;

    p = befend(bestart);

    if( (n = (struct behead *)malloc(sizeof(struct behead))) == NULL )
	return NULL;
	
    p->next = n;
    n->prev = p;
    n->next = NULL;

    snprintf(n->title, 2048, "%s", nhead->title);
    snprintf(n->version, 23, "%s", nhead->version);
    snprintf(n->link, 2048, "%s", nhead->link);

    return (n);
}

struct behead *befend(struct behead *bestart) {
    struct behead *n;
    
    n = bestart;

    while(1) {
	if(n->next == NULL)
	    break;
	n = n->next;
    }

    return (n);
}

void beparse(FILE *cache, struct behead *bestart, int counter) {
    struct behead *nhead;

    char dum[2048];
    FILE *fin;    
    
    nhead = (struct behead *)malloc(sizeof(struct behead));
    
    fin = cache;
    
    while(!feof(fin)) {
	fgets(dum, 2048, fin);
        if((char *)strstr(dum, "%%") != NULL) {
#ifdef DEBUG
            printf("%% found!\n");
#endif /* DEBUG */
	    break;
	}
    };
   
    while (!feof(fin)) {
	if(counter == 0)
	    break;
	    
        if(fgets(nhead->title, 2048, fin) == NULL)
	            break;
		    
        if(fgets(nhead->version, 2048, fin) == NULL)
	            break;

        if(fgets(nhead->link, 2048, fin) == NULL)
	            break;

        if(fgets(dum, 2048, fin) == NULL)
	            break;
	
        beadd(nhead, bestart);

	if(counter != -1)
	    counter--;
    };

    free(nhead);
    fclose(fin);
}    	    

void behtmlprint(struct behead *bestart, struct gurl *opt) {
    FILE *fout = NULL;
    int si = 0;
    struct behead *c = NULL;
    char temp[2048];
    
    if(bestart->next != NULL) {
	c = bestart->next;
        si = 1;
    }
    
    if((fout = fopen(filename, "a")) == NULL) {
	printf("%s: Could Not Open The Output File.. =(\n", opt->name);
	perror("fopen");
    	exit(1);
    }

    if(si == 1) {
	strcpy(temp, settings->persite);
	if(2048 - strlen("$NAME") + strlen(strip_n(opt->name)) >= 0)
	    repstr(temp, temp, "$NAME", strip_n(opt->name), sizeof(temp));
	if(2048 - strlen("$HOST") + strlen(strip_n(opt->host)) >= 0)
	    repstr(temp, temp, "$HOST", strip_n(opt->host), sizeof(temp));
        repstr(temp, temp, "\\n", "\n", sizeof(temp));
	fputs(temp, fout);
	while(1) {
	    strcpy(temp, opt->output);
	    if(2048 - strlen("$TITLE") + strlen(strip_n(c->title)) >= 0)
		repstr(temp, temp, "$TITLE", strip_n(c->title), sizeof(temp));
	    if(2048 - strlen("$VERSION") + strlen(strip_n(c->version)) >= 0)
		repstr(temp, temp, "$VERSION", strip_n(c->version), sizeof(temp));
	    if(2048 - strlen("$LINK") + strlen(strip_n(c->link)) >= 0)
		repstr(temp, temp, "$LINK", strip_n(c->link), sizeof(temp));
	    repstr(temp, temp, "\\n", "\n", sizeof(temp));
	    if(c->next == NULL) {
		fputs(temp, fout);
		break;
	    }
	    fputs(temp, fout);
	    c = c->next;	
	}
    }
    fclose(fout);
}

void befree(struct behead *bestart) {
    struct behead *n;
    struct behead *c;
    
    c = bestart;
    n = NULL;

    while(1) {
	if(c->next == NULL) {
    	    free(c);
	    break;
	}
	n = c->next;
	free(c);
	c = n;
    }
}
