/************************************************************************
 *   Yanf - Yet Another News Fetcher include/structs.h
 *   Copyright (C) 2000 Gaston Kleiman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

struct gurl {
    char output[2048];
    char host[2048];
    char path[2048];
    char file[2048];
    char name[2048];
    FILE *cache;
    int counter;
};

struct boheads {
    struct boheads *next;
    struct boheads *prev;
    char title[2048];
    char link[2048];
};

struct sheads {
    struct sheads *next;
    struct sheads *prev;
    char title[2048];
    char link[2048];
    char date[23];
    char author[2048];
    char dept[2048];
    char storytype[2048]; /* Tema del articulo */
    int ncom; /* Numero de comentarios */
    char section[2048]; /* Seccion del articulo */
};

struct fheads {
    struct fheads *next;
    struct fheads *prev;
    char title[2048];
    char date[2048];
    char link[2048];
};

struct lthead {
    struct lthead *next;
    struct lthead *prev;
    char title[2048];
    char link[2048];
    char date[2048];
};

struct psheads {
    struct psheads *next;
    struct psheads *prev;
    char title[2048];
    char link[2048];
    char date[2048];
    char des[2048];
};

struct segheads {
    struct segheads *next;
    struct segheads *prev;
    char title[2048];
    char link[2048];
    char date[23];
    char author[2048];
    char email[2048];
    char storytype[2048]; /* Tema del articulo */
};

struct gnhead {
    struct gnhead *next;
    struct gnhead *prev;
    char title[2048];
    char link[2048];
    char desc[2048];
};

struct behead {
    struct behead *next;
    struct behead *prev;
    char title[2048];
    char version[2048];
    char link[2048];
};

struct l2head {
    struct l2head *next;
    struct l2head *prev;
    char title[2048];
    char link[2048];
};

struct rdfhead {
    struct rdfhead *next;
    struct rdfhead *prev;
    char title[2048];
    char link[2048];
    char description[2048];
};

struct sechead {
    struct sechead *next;
    struct sechead *prev;
    char title[2048];
    char link[2048];
    char type[2048];
};

struct sites {
    char url[2048];
    char name[2048];
    char output[2048];
    int counter;
    int (*pagefunc) (struct gurl *, int);
    struct gurl *sitegurl;
    struct sites *next;
};

struct pagetype {
    char *pagetype;
    void (*pagefunc)();
};

struct mymsgbuf {
    long mtype;
    char mtext[1];
};

struct globalset {
    char start[2048];
    char end[2048];
    char persite[2048];
};