#!/usr/bin/perl

# $Id: conf-059-0510.pl,v 1.1 2000/07/05 08:33:44 mike Exp $
#
# conf-059-0510.pl - Converts a 0.5.9 config file to 0.5.10, output to stdout
#                    input from stdin
#
# So what special considerations do we need to look for?
#
# 1. DefaultSetup and ExternalSetup are now called PageGroups, their
#    attributes are intersected into the new class.
# 2. DefaultPage and ExternalPage are now called Pages, their attributes
#    are intersected into the new class.
# 3. DefaultTheme and ExternalTheme are now called Themes, their attributes
#    are intersected into the new class.
# 4. DefaultPages and ExternalPages are now inside their associated
#    Setup section, instead of after.
# 5. web_path is deprecated, change to web_page
# 6. web_path_tagname is deprecated, change to output_page_tagname

$level = 0;
$inpg = 0;

while(<STDIN>) {
  &lookAtTheStuff($_);
}

if($level != 0) {
    print "}\n";
}

exit(0);

sub lookAtTheStuff {
  my($line) = @_;

  if(($line =~ /^\#/)||($line eq "\n")) {
      print;
      return;
  }
  for($line) {
      s/^([^\"]+)DefaultSetup(.*)$/$1PageGroup$2/;
      s/^([^\"]+)ExternalSetup(.*)$/$1PageGroup$2/;
      s/^([^\"]+)DefaultPage(.*)$/$1Page$2/;
      s/^([^\"]+)ExternalPage(.*)$/$1Page$2/;
      s/^([^\"]+)DefaultTheme(.*)$/$1Theme$2/;
      s/^([^\"]+)ExternalTheme(.*)$/$1Theme$2/;
      s/^([^\"]+)web_path_tagname(.*)$/$1output_page_tagname$2/;
      s/^([^\"]+)web_path(.*)$/$1web_page$2/;
  }
  if($line =~ /^[^\"]+PageGroup/) {
      if($inpg) {
	  print "}\n\n";
	  $level--;
      }
      $inpg = 1;
  }
  
  if($line =~ /^[^\"]+\{/ ) {
      $level++;
  }

  if($line =~ /^[^\"]+\}/ ) {
      if($inpg) {
	  if($level != 2) {
	      print $line;
	      $level--;
	  }
      } else {
	  print $line;
	  $level--;
      }
  } else {
      print $line;
  }

};
