#!/usr/bin/perl

require "056/website";
require "056/page";
require "056/subtaggroup";
require "056/pageorder";

# $Id: conf-056-057.pl,v 1.5 1999/10/04 05:27:02 mike Exp $
#
# conf-056-057.pl - Converts a 0.5.6 config file to 0.5.7, output to stdout
#                   input from stdin
#
# So what special considerations do we need to look for?
#
# DONE:
# 1. First, the common pageorder and common subtaggroup are now gone. This
#    means if they were set, then they will need to be added to all pages.
#    (This will be reimplemented before 0.6.0 though...)
# 2. Nearly all the tagnames in the website section now belong in the new
#    default setup section
# 3. Output_dir has moved from the website section to each page. So this
#    will need to be added to all pages (not pageorderpages)
# 4. Database_filename goes to the default_setup section
# 5. The website section now surrounds all information in the config file,
#    so the default_setup and new default_pages will go in there. All
#    pageorders, pageorderpages, and subtaggroups go into the default setup
#    section. With subtaggroups first, then the pageorders and pageorderpages
#    in the order that they depend correctly.
# 6. The Page { } section delimeters are now obsolete
# 7. PageOrderPage is now PagePart
# 8. PageParts do not define source_dir and path anymore, they simply
#    define filename and directory
# 9. The "file" tag in pageorders is now "part"

# What can we have in the old config?
$website = "";
@pages = ();
@subtaggroups = ();
@pageorders = ();

while(<STDIN>) {
  &lookAtTheStuff($_);
}

$website->print();

#foreach $page (@pages) {
#  $page->print();
#}
#
#foreach $subtaggroup (@subtaggroups) {
#  $subtaggroup->print();
#}
#
#foreach $pageorder (@pageorders) {
#  $pageorder->print();
#}

exit(0);

sub lookAtTheStuff {
  my($line) = @_;

  return if $line =~ /^\#/;               # Skip comments
  return if $line eq "\n";        # Skip emptylines

  SWITCH: {
    ($line =~ /Website\ +{/i) && do { $website = Website->new(); last SWITCH; };
    ($line =~ /Page\ +{/i) && do { push @pages,Page->new(); last SWITCH; };
    ($line =~ /PageOrder\ +{/i) && do { push @pageorders, PageOrder->new(); last SWITCH; };
    ($line =~ /SubTagGroup\ +{/i) && do { push @subtaggroups, SubTagGroup->new(); last SWITCH; };
    $nothing = 1;
  }

};


exit(0);
