/* $Id: wsmake.h,v 1.34 2001/09/01 21:32:09 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSMAKE_H__
#define __WSMAKE_H__ 1

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef WIN32
#pragma warning(disable:4786) // Broken STL headers on win
#endif

#define UNKNOWN                      -1

#define SECTION_WEBSITE               0
#define SECTION_PAGE                  1
#define SECTION_PAGEGROUP             2
#define SECTION_SUBTAGGROUP           3
#define SECTION_PAGEORDER             4
#define SECTION_PAGEPART              5
#define SECTION_THEME                 6

#define MATCH_BEG                    50
#define MATCH_SUB                    51
#define MATCH_END                    52

// Website section
#define TAG_NAME                    100
#define TAG_MAINTAINER              101
#define TAG_URL                     102
#define TAG_DATABASE_FILENAME       103
#define TAG_COMMON_SUBTAGGROUP      104
#define TAG_COMMON_PAGEORDER        105
#define TAG_LASTMOD_TAGNAME         106
#define TAG_WSMAKE_VERSION_TAGNAME  107
#define TAG_OUTPUT_PAGE_TAGNAME     108
#define TAG_SOURCE_TAGNAME          109
#define TAG_OUTPUT_TAGNAME          110
#define TAG_INCLUDE_TAGNAME         111
#define TAG_HEADER_TAGNAME          112
#define TAG_FOOTER_TAGNAME          113
#define TAG_COMMAND                 114
#define TAG_OPTIONS                 115
#define TAG_CLONE                   116
#define TAG_THEME                   117
#define TAG_DEPEND                  118
#define TAG_TIME_FORMAT             119
#define TAG_SUBTAG_FORMAT           120
#define TAG_DATABASE_FORMAT         121
#define TAG_INCLUDE                 122
#define TAG_INCLUDE_DIR             123

// Page section
#define TAG_WEB_PAGE                200
#define TAG_SOURCE_PAGE             201
#define TAG_SOURCE_DIR              202
#define TAG_OUTPUT_PAGE             203
#define TAG_OUTPUT_DIR              204
#define TAG_PART_DIR                205
#define TAG_PAGETYPE                206
#define TAG_PARSE                   207
#define TAG_CGIHEADER               208
#define TAG_CGIFOOTER               209
#define TAG_SUBTAG                  210
#define TAG_SUBTAGGROUP             211
#define TAG_PAGEORDER               212
#define TAG_FILENAME                213
#define TAG_DIRECTORY               214

// Pageorder section
#define TAG_PART                    300
#define TAG_DATA                    301

// Helpers
#define PAGETYPE_NORMAL             400
#define PAGETYPE_CGI                401

#define PARSE_YES                   500
#define PARSE_NO                    501
#define PARSE_INCLUDES_ONLY         502
#define YES                         503
#define NO                          504

#define STATTYPE_NOCHANGE           600
#define STATTYPE_ERROR              601
#define STATTYPE_NEWPAGE            602
#define STATTYPE_FORCE              603
#define STATTYPE_SOURCEUPDATED      604
#define STATTYPE_NOOUTPUTPAGE       605
#define STATTYPE_NOSOURCEPAGE       606
#define STATTYPE_OLDOUTPUTPAGE      607
#define STATTYPE_PAGEORDERUPDATED   608
#define STATTYPE_THEMEUPDATED       609
#define STATTYPE_DEPENDUPDATED      610
#define STATTYPE_SUBTAGUPDATED      611
#define STATTYPE_SUBTAGGROUPUPDATED 612

#define MAXSECTIONLEN               20
#define MAX_DEBUG_LEVEL             3
#define MIN_DEBUG_LEVEL             0

// Database key prefixes
#define KEY_WEBPAGE                 "WP:"
#define KEY_PAGEPART                "PP:"
#define KEY_DEPEND                  "D:"
#define KEY_SUBTAG                  "ST:"
#define KEY_SUBTAGGROUP             "STG:"
#define KEY_THEME                   "T:"

int wsmake_init(void);
void wsmake_exit(void);

#endif /* __WSMAKE_H__ */
