/* $Id: wsWebSite.h,v 1.1 2001/05/30 13:38:56 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSWEBSITE_H__
#define __WSWEBSITE_H__ 1

#include <iostream>
#include <fstream>
#include <string>

#include "wsPageGroupList.h"
#include "wsUtil.h"

namespace std
{
  class wsWebSite
  {
  public:
    wsWebSite(int, int, int);
    ~wsWebSite(void);

    string getOutputDir(void);

    int load(string *, int);
    int sync(void);
    int make(void);
    int make(list<string>, int);
    int clean(void);
    int clean(list<string>, int);
    int dump(ofstream *);

    void print(void) const;

  private:
    void setConfigFileName(string);
    int load();
    int loadWebsite(ifstream *);
    void setDebugLevel(int);
    void setForce(int);
    void setQuiet(int);
    void setTimes(int);

    int makePages(void);
    int makePages(list<string>, int);
    int cleanPages(void);
    int cleanPages(list<string>, int);

    int getSectionID(const string *);
    int getWebsiteTagID(const string *);
    string getConfigFileDir(void);
    string getConfigFileName(void);

    string name;
    string maintainer;
    string URL;
    string database_filename;

    int force;
    int times;

    string config_filename;

    wsPageGroupList *pagegroup_list;
  };
}

#endif /* __WSWEBSITE_H__ */
