/* $Id: wsWebPage.h,v 1.1 2001/05/30 13:38:56 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSWEBPAGE_H__
#define __WSWEBPAGE_H__ 1

#include "wsDependList.h"
#include "wsPage.h"
#include "wsPageGroup.h"
#include "wsPageList.h"
#include "wsSubTag.h"
#include "wsThemeList.h"

namespace std
{
  class wsWebPage : public wsPage
  {
  public:
    wsWebPage(string, ifstream *, wsPageGroup *);
    wsWebPage(string, wsPageGroup *);
    wsWebPage(string, ifstream *, wsPageGroup *, wsWebPage *);
    virtual ~wsWebPage(void);

    virtual int load(ifstream *);
    virtual int sync(int);
    virtual int make();
    virtual int clean();
    virtual int make(ofstream *);
    virtual int dump(ofstream *);

    virtual void print(void) const;
    virtual void printSync(void);

    virtual int setPageList(wsPageList *, wsPageList *);

    void copyTo(wsWebPage *);

  protected:
    int getPageTypeID(void) const;
    void  parseContent(ofstream *);

    int pushBackSubTag(wsSubTag *);
    int pushBackPage(wsPage *);

    string getFormatOptions(string) const;

    inline void setStat(int statType)
    { this->statType = statType; }
    inline void setUpdate(bool update)
    { this->update = update; }
    inline void setPageType(string page_type)
    { this->page_type.assign(page_type); }
    inline void setParseType(string parse_type)
    { this->parse_type.assign(parse_type); }
    inline void setCGIHeader(string cgi_header)
    { this->cgi_header.assign(cgi_header); }
    inline void setCGIFooter(string cgi_footer)
    { this->cgi_footer.assign(cgi_footer); }
    inline void setSyncPrinted(int sync_printed)
    { this->sync_printed = sync_printed; }
    inline void setCommand(string command)
    { this->command.assign(command); }
    inline void setOptions(string options)
    { this->options.assign(options); }

    inline virtual string getDatabaseKey(void) const
    { return KEY_WEBPAGE "(" + this->getFullSourcePageDir() + "/" +
	this->getSourcePage() + ") -> (" + getFullOutputPageDir() + "/" +
	this->getOutputPage() + ")"; }
    inline bool getUpdate(void) const
    { return update; }
    inline int getStat(void) const
    { return statType; }
    inline wsSubTagList *getSubTagList(void) const
    { return subtag_list; }
    inline wsSubTagGroupList *getSubTagGroupList(void) const
    { return subtaggroup_list; }
    inline wsThemeList *getThemeList(void) const
    { return theme_list; }
    inline wsPageOrderList *getPageOrderList(void) const
    { return pageorder_list; }
    inline wsDependList *getDependList(void) const
    { return depend_list; }
    inline wsPageGroup *getPageGroup(void) const
    { return pagegroup; }
    inline string getPageType(void) const
    { return page_type; }
    inline string getParseType(void) const
    { return parse_type; }
    inline int getSyncPrinted(void) const
    { return sync_printed; }
    inline string getCommand(void) const
    { return command; }
    inline string getOptions(void) const
    { return options; }

    inline bool subTagListIsUpdated(void) const
    { return subtag_list->isUpdated(); }
    inline bool pageOrderListIsUpdated(void) const
    { return pageorder_list->isUpdated(); }
    inline bool dependListIsUpdated(void) const
    { return depend_list->isUpdated(); }
    inline bool subTagGroupListIsUpdated(void) const
    { return subtaggroup_list->isUpdated(); }

  private:
    int getDefaultPageTagID(const string *);
    int getParseID(const string *);
    int setInternalSubTagList(void);
    void parseContentLoop(string, ofstream *);
    virtual void parseSubtags(string *);
    void parseIncludes(ofstream *, string *);

    int statType;
    int recurse_level;
    int sync_printed;
    bool clone;
    bool update;
    string page_type;
    string parse_type;
    string cgi_header;
    string cgi_footer;
    string command;
    string options;

    wsDependList      *depend_list;
    wsPageGroup       *pagegroup;
    wsPageList        *clone_list;
    wsPageOrderList   *pageorder_list;
    wsSubTagList      *subtag_list;
    wsSubTagList      *internal_subtag_list;
    wsSubTagGroupList *subtaggroup_list;
    wsThemeList       *theme_list;
  };
}
#endif /* __WSWEBPAGE_H__ */
