/* $Id: wsUtil.h,v 1.4 2002/02/19 06:14:05 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSUTIL_H__
#define __WSUTIL_H__ 1

#include <ctime>
#include <cstdio>
#include <cstdarg>

#include <fstream>
#include <iostream>
#include <string>

#include <sys/types.h> /* mode_t */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define MAXLINELEN 2048

#ifdef DEBUG
# define DBGPRINT(action) __wsmake_print_debug action
#else
# define DBGPRINT(action) do { } while(0)
#endif

namespace std
{
  int isWhiteSpace(string *);
  int getNextConfigLine(ifstream *, string *);
  int getNextBinaryLine(ifstream *, char []);
  int getNextLine(ifstream *, string *);
  string *chopQuotes(string *);
  string *chopBackQuotes(string *);
  int splitString(string *, string *, const string *);
  string *getStringFromChar(string*, const char *);
  time_t getFileLastMod(string);
  int searchAndReplace(string *, string, string);
  char *getFullPath(char *);
  int applyStat(const char *, const char *);
  int applyTime(const char *, const char *);
  int fileExists(const char *);
  int fileIsDir(const char *);
  int fileMkDir(string, mode_t);
  char *collapsePath(const char *, const char *);
  char *collapsePath(const char *, const char *, const char *);
  char *remExtraSlashes(char *);
  void __wsmake_set_level(int);
  void __wsmake_set_quiet(int);
  int __wsmake_get_level(void);

#ifdef DEBUG
  void __wsmake_print_debug(const char *, ...);
#endif
  void __wsmake_print_warning(const char *, ...);
  void __wsmake_print_error(const char *, ...);
  void __wsmake_print(const char *, ...);
  void __wsmake_print(int, const char *, ...);
  void __wsmake_print_it(FILE *, const char *, const va_list *);
}

#endif /* __WSUTIL_H__ */
