/* $Id: wsThemeList.h,v 1.2 2001/09/01 20:15:01 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSTHEMELIST_H__
#define __WSTHEMELIST_H__ 1

#include <list>
#include <string>

#include "wsTheme.h"
#include "wsUtil.h"

namespace std
{
  class wsThemeList
  {
  public:
    wsThemeList();
    ~wsThemeList();

    int free(void);
    int sync(int);
    int make(void);
    int parse(string *);

    bool isUpdated(void) const;

    int pushBackTheme(wsTheme *);
    int pushFrontTheme(wsTheme *);

    void print(void) const;
    void printSyncs(void) const;
    void printNames(void) const;

    wsTheme *findThemeWithName(const string);

    int setPageList(wsPageList *, wsPageList *);

    wsThemeList *operator+=(wsThemeList *);

  protected:
    int haveThemeWithName(const string);

  private:
    list< wsTheme * >themelist;
  };
}
#endif /* __WSTHEMELIST_H__ */
