/* $Id: wsThemeList.cpp,v 1.2 2001/09/01 20:15:01 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsThemeList.h"

using namespace std;

wsThemeList::wsThemeList()
{
  DBGPRINT(("O:created: wsThemeList\n"));
}

wsThemeList::~wsThemeList()
{
  DBGPRINT(("O:destroyed: wsThemeList\n"));
}

int wsThemeList::free(void)
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    delete (*i);

  return 1;
}

int wsThemeList::sync(int force)
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    (*i)->sync(force);

  return 1;
}

int wsThemeList::make(void)
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    (*i)->make();

  return 1;
}

int wsThemeList::parse(string *in)
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    if((*i)->parse(in))
      return 1;

  return 0;
}

bool wsThemeList::isUpdated(void) const
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    if((*i)->isUpdated())
      return true;

  return false;
}

int wsThemeList::setPageList(wsPageList *prepend, wsPageList *append)
{
  list< wsTheme * >::const_iterator i;
  for(i=themelist.begin();i!=themelist.end();++i)
    if(!(*i)->setPageList(prepend,append))
      return 0;

  return 1;
}

int wsThemeList::pushBackTheme(wsTheme *theme)
{
  if(theme == NULL)
    return 0;        // Tried to insert a null theme

  if(this->haveThemeWithName(theme->getName())) {
    __wsmake_print_error("theme with name `%s' already defined\n",
			 theme->getName().c_str());
    return 0;
  }

  themelist.push_back(theme);
  return 1;
}

int wsThemeList::pushFrontTheme(wsTheme *theme)
{
  if(theme == NULL)
    return 0;        // Tried to insert a null theme

  if(this->haveThemeWithName(theme->getName())) {
    __wsmake_print_error("theme with name `%s' already defined\n",
			 theme->getName().c_str());
    return 0;
  }

  themelist.push_front(theme);
  return 1;
}

wsTheme *wsThemeList::findThemeWithName(const string name)
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    if((*i)->nameIs(name))
      return (*i);

  return 0;
}

int wsThemeList::haveThemeWithName(const string name)
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    if((*i)->nameIs(name))
      return 1;

  return 0;
}

void wsThemeList::print(void) const
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    (*i)->print();
}

wsThemeList *wsThemeList::operator+=(wsThemeList *append_list)
{
  list< wsTheme * >::const_iterator i;
  for(i=append_list->themelist.begin();
      i!=append_list->themelist.end();++i)
    pushBackTheme(*i);

  return this;
}

void wsThemeList::printSyncs(void) const
{
  list< wsTheme * >::const_iterator i;

  for(i=themelist.begin();i!=themelist.end();++i)
    (*i)->printSync();
}

void wsThemeList::printNames(void) const
{
  list< wsTheme * >::const_iterator i;

  __wsmake_print("[ ");
  for(i=themelist.begin();i!=themelist.end();++i) {
    (*i)->printName();
    __wsmake_print(" ");
  }
  __wsmake_print("]");
}
