/* $Id: wsTheme.h,v 1.2 2001/09/01 20:15:01 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __THEME_H__
#define __THEME_H__ 1

#include <iostream>
#include <fstream>

#include "wsDependList.h"
#include "wsPageGroup.h"
#include "wsPageOrderList.h"
#include "wsSubTag.h"
#include "wsSubTagGroupList.h"
#include "wsSubTagList.h"
#include "wsUtil.h"
#include "wsWebPage.h"

namespace std
{
  class wsTheme
  {
    friend class wsWebPage;

  public:
    wsTheme(ifstream *, wsPageGroup *);
    wsTheme(ifstream *, wsPageGroup *, string, int);
    ~wsTheme(void);

    int load(ifstream *, string, int);
    int sync(int force);
    int make(void);
    //  int dump(ofstream *);

    int parse(string *);
    void print(void) const;
    void printSync(void) const;
    void printName(void) const;

    int setPageList(wsPageList *, wsPageList *);

    inline string getName(void) const
    { return name; }
    inline int nameIs(string name) const
    { return (this->name.compare(name) == 0)?1:0; }

    inline bool isUpdated(void) const
    { return updated; }

  protected:
    int getThemeTagID(const string *);
    int pushBackSubTag(const string *, const string, const string);
    int pushBackSubTag(const string *, const string, const string,
		       const string, const string, int);

    inline void setName(const string *name)
    { this->name.assign(*name); }
    inline void setCommand(string command)
    { this->command.assign(command); }
    inline void setOptions(string options)
    { this->options.assign(options); }
    inline string getCommand(void) const
    { return command; }
    inline string getOptions(void) const
    { return options; }
    inline string getDatabaseKey(void) const
    { return KEY_THEME + name; }

  private:
    bool updated;
    string name;
    string command;
    string options;

    wsDependList *depend_list;
    wsPageGroup *pagegroup;
    wsPageOrderList *pageorder_list;
    wsSubTagList *subtag_list;
    wsSubTagGroupList *subtaggroup_list;
  };
}

#endif /* __THEME_H__ */
