/* $Id: wsSubTagList.h,v 1.2 2001/09/01 20:15:01 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSSUBTAGLIST_H__
#define __WSSUBTAGLIST_H__ 1

#include <list>
#include <string>

#include "wsSubTag.h"
#include "wsUtil.h"

namespace std
{
  class wsSubTagList
  {
  public:
    wsSubTagList();
    ~wsSubTagList();

    void free(void);
    int sync(int);

    int pushBackSubTag(wsSubTag *);
    int pushFrontSubTag(wsSubTag *);
    int pushBackSubTag(const string *);
    int pushBackSubTag(const string *, const string *, const string *);
    int pushBackSubTag(const string *, const string, const string, int);
    int pushBackSubTag(const string *, const string, const string,
		       const string, const string, int);
    int pushFrontSubTag(const string *);

    void print(void);
    void print(int);
    void printNames(void);
    void printNames(int);

    int parse(string *);

    bool isUpdated(void) const;

    wsSubTagList *operator+=(wsSubTagList *);

  private:
    int defined(const string);
    int defined(const wsSubTag *);

    list< wsSubTag * >subtaglist;
  };
}

#endif /* __WSSUBTAGLIST_H__ */
