/* $Id: wsSubTagList.cpp,v 1.2 2001/09/01 20:15:01 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsSubTagList.h"
#include "wsUtil.h"

using namespace std;

wsSubTagList::wsSubTagList()
{
  DBGPRINT(("O:created: wsSubTagList\n"));
}

wsSubTagList::~wsSubTagList()
{
  DBGPRINT(("O:destroyed: wsSubTagList\n"));
}

void wsSubTagList::free()
{
  list< wsSubTag * >::const_iterator i;

  for(i=subtaglist.begin();i!=subtaglist.end();++i)
    delete (*i);
}

int wsSubTagList::sync(int force)
{
  list< wsSubTag * >::const_iterator i;

  for(i=subtaglist.begin();i!=subtaglist.end();++i)
    (*i)->sync(force);

  return 1;
}

int wsSubTagList::pushBackSubTag(wsSubTag *subtag)
{
  if(subtag == NULL)
    return 0;        // Tried to insert a null subtag

  if(this->defined(subtag) == 0)
    subtaglist.push_back(subtag);

  return 1;
}

int wsSubTagList::pushBackSubTag(const string *subtag)
{
  subtaglist.push_back(new wsSubTag(subtag));

  return 1;
}

int wsSubTagList::pushBackSubTag(const string *subtag,
				 const string *tagfront,
				 const string *tagback)
{
  subtaglist.push_back(new wsSubTag(subtag, tagfront, tagback));

  return 1;
}

int wsSubTagList::pushBackSubTag(const string *subtag,
				 const string prefix,
				 const string db_file,
				 int db_type)
{
  subtaglist.push_back(new wsSubTag(subtag, &prefix, &db_file, db_type));

  return 1;
}

int wsSubTagList::pushBackSubTag(const string *subtag,
				 const string tagfront,
				 const string tagback,
				 const string prefix,
				 const string db_file,
				 int db_type)
{
  subtaglist.push_back(new wsSubTag
		       (subtag, &tagfront, &tagback,
			&prefix, &db_file, db_type));

  return 1;
}

int wsSubTagList::pushFrontSubTag(wsSubTag *subtag)
{
  if(subtag == NULL)
    return 0;        // Tried to insert a null subtag

  if(this->defined(subtag) == 0)
    subtaglist.push_front(subtag);

  return 1;
}

int wsSubTagList::pushFrontSubTag(const string *subtag)
{
  subtaglist.push_front(new wsSubTag(subtag));

  return 1;
}

int wsSubTagList::parse(string *in)
{
  list< wsSubTag * >::const_iterator i;

  // find first subtag and replace it
  for(i=subtaglist.begin();i!=subtaglist.end();++i)
    if((*i)->parse(in))
      return 1;

  return 0;
}

bool wsSubTagList::isUpdated(void) const
{
  list< wsSubTag * >::const_iterator i;

  for(i=subtaglist.begin();i!=subtaglist.end();++i)
    if((*i)->isUpdated() == 1)
      return true;

  return false;
}

void wsSubTagList::print(void)
{
  this->printNames();
}

void wsSubTagList::print(int debug)
{
  this->printNames(debug);
}

wsSubTagList *wsSubTagList::operator+=(wsSubTagList *append_list)
{
  list< wsSubTag * >::const_iterator i;

  for(i=append_list->subtaglist.begin();
      i!=append_list->subtaglist.end();++i)
    this->pushBackSubTag(*i);

  return this;
}

int wsSubTagList::defined(const wsSubTag *subtag)
{
  list< wsSubTag * >::const_iterator i;

  for(i=subtaglist.begin();i!=subtaglist.end();++i)
    if(*(*i) == subtag)
      return 1;

  return 0;
}

int wsSubTagList::defined(const string subtag)
{
  list< wsSubTag * >::const_iterator i;

  for(i=subtaglist.begin();i!=subtaglist.end();++i)
    if(*(*i) == subtag)
      return 1;

  return 0;
}

void wsSubTagList::printNames(void)
{
  list< wsSubTag * >::const_iterator i;

  __wsmake_print("[ ");
  for(i=subtaglist.begin();i!=subtaglist.end();++i) {
    (*i)->print();
    __wsmake_print(" ");
  }
  __wsmake_print("]");
}

void wsSubTagList::printNames(int debug)
{
  list< wsSubTag * >::const_iterator i;

  __wsmake_print(debug,"[ ");
  for(i=subtaglist.begin();i!=subtaglist.end();++i) {
    (*i)->print(debug);
    __wsmake_print(debug, " ");
  }
  __wsmake_print(debug, "]");
}
