/* $Id: wsSubTagGroupList.cpp,v 1.3 2001/09/01 20:15:01 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsSubTagGroupList.h"

using namespace std;

wsSubTagGroupList::wsSubTagGroupList()
{
  DBGPRINT(("O:created: wsSubTagGroupList\n"));
}

wsSubTagGroupList::~wsSubTagGroupList()
{
  DBGPRINT(("O:destroyed: wsSubTagGroupList\n"));
}

int wsSubTagGroupList::free(void)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    delete (*i);

  return 1;
}

void wsSubTagGroupList::sync(int force)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    (*i)->sync(force);
}

int wsSubTagGroupList::parse(string *in)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    if((*i)->parse(in))
      return 1;

  return 0;
}

int wsSubTagGroupList::pushBackSubTagGroup(wsSubTagGroup *subtaggroup)
{
  if(subtaggroup == NULL) {
    return 0;        // Tried to insert a null subtaggroup
  }

  if(this->haveSubTagGroupWithName(subtaggroup->getName()) != 0) {
    __wsmake_print_error("subtaggroup with name `%s' already defined\n",
			 subtaggroup->getName().c_str());
    return 0;
  }

  subtaggrouplist.push_back(subtaggroup);
  return 1;
}

int wsSubTagGroupList::pushFrontSubTagGroup(wsSubTagGroup *subtaggroup)
{
  if(subtaggroup == NULL) {
    return 0;        // Tried to insert a null subtaggroup
  }

  if(this->haveSubTagGroupWithName(subtaggroup->getName()) != 1) {
    __wsmake_print_error("subtaggroup with name `%s' already defined\n",
			 subtaggroup->getName().c_str());
    return 0;
  }
  subtaggrouplist.push_front(subtaggroup);
  return 1;
}

wsSubTagGroup *wsSubTagGroupList::findSubTagGroupWithName(const string name)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    if((*i)->nameIs(name))
      return (*i);

  return NULL;
}

int wsSubTagGroupList::haveSubTagGroupWithName(const string name)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    if((*i)->nameIs(name))
      return 1;

  return 0;
}

int wsSubTagGroupList::appendTo(wsSubTagList *append_list)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    if(!(*i)->appendTo(append_list))
      return 0;

  return 1;
}

bool wsSubTagGroupList::isUpdated() const
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    if((*i)->isUpdated())
      return true;

  return false;
}

void wsSubTagGroupList::print(void) const
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i)
    (*i)->print();
}

wsSubTagGroupList *wsSubTagGroupList::operator+=(wsSubTagGroupList *append_list)
{
  list< wsSubTagGroup * >::const_iterator i;

  for(i=append_list->subtaggrouplist.begin();
      i!=append_list->subtaggrouplist.end();++i)
    this->pushBackSubTagGroup(*i);

  return this;
}

void wsSubTagGroupList::printNames(void) const
{
  list< wsSubTagGroup * >::const_iterator i;

  __wsmake_print("[ ");
  for(i=subtaggrouplist.begin();i!=subtaggrouplist.end();++i) {
    (*i)->printName();
    __wsmake_print(" ");
  }
  __wsmake_print("]");
}
