/* $Id: wsSubTagGroup.h,v 1.2 2001/09/01 20:15:01 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSSUBTAGGROUP_H__
#define __WSSUBTAGGROUP_H__ 1

#include <iostream>
#include <fstream>

#include "wsSubTag.h"
#include "wsSubTagList.h"
#include "wsmake.h"

namespace std
{
  class wsSubTagGroup
  {
  public:
    wsSubTagGroup(ifstream *, string, string);
    wsSubTagGroup(ifstream *, string, string, string, int);
    ~wsSubTagGroup(void);

    int load(ifstream *, string, string, string, int);
    inline void sync(int force)
    { subtag_list->sync(force); }
    int dump(ofstream *);
    inline int parse(string *in)
    { return subtag_list->parse(in); }

    void print(void) const;
    void printName(void) const;

    inline string getName(void) const
    { return name; }
    inline int nameIs(string name) const
    { return (this->name.compare(name) == 0)?1:0; }

    inline int appendTo(wsSubTagList *append_list)
    { (*append_list)+=subtag_list; return 1; }

    inline int isUpdated(void) const
    { return subtag_list->isUpdated(); }

  protected:
    inline void setName(const string *name)
    { this->name.assign(*name); }

    int getSubTagGroupID(const string *);

    int pushBackSubTag(wsSubTag*);

    int pushBackSubTag(const string *, const string, const string,
		       const string, const string, int);

    inline string getDatabaseKey(void) const
    { return KEY_SUBTAGGROUP + name; }

  private:
    string name;
    wsSubTagList *subtag_list;
  };
}

#endif /* __WSSUBTAGGROUP_H__ */
