/* $Id: wsSubTagGroup.cpp,v 1.1 2001/05/30 13:38:55 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsSubTagGroup.h"
#include "wsUtil.h"

using namespace std;

wsSubTagGroup::wsSubTagGroup(ifstream *config, string tagfront,
			     string tagback)
{
  subtag_list = new wsSubTagList();

  this->load(config, tagfront, tagback, "", 0);

  DBGPRINT(("O:created: wsSubTagGroup\n"));
}

wsSubTagGroup::wsSubTagGroup(ifstream *config, string tagfront,
			     string tagback, string db_file,
			     int db_type)
{
  subtag_list = new wsSubTagList();

  this->load(config, tagfront, tagback, db_file, db_type);

  DBGPRINT(("O:created: wsSubTagGroup\n"));
}

wsSubTagGroup::~wsSubTagGroup(void)
{
  subtag_list->free();
  delete subtag_list;

  DBGPRINT(("O:destroyed: wsSubTagGroup\n"));
}

int wsSubTagGroup::getSubTagGroupID(const string *tag)
{
  if(strcmp(tag->c_str(), "name") == 0)
    return TAG_NAME;
  else if(strcmp(tag->c_str(), "SubTag") == 0)
    return TAG_SUBTAG;

  return UNKNOWN;
}

int wsSubTagGroup::load(ifstream *config, string tagfront,
			string tagback, string db_file, int db_type)
{
  string buff;
  string tag;
  string value;
  int done = 0;
  int line = 0;

  while((!done) && (line=getNextConfigLine(config, &buff))!=0) {
    splitString(&tag, &value, &buff);

    if(tag.find("}") != string::npos) {
      done = 1;
    } else {
      switch(this->getSubTagGroupID(&tag)) {
      case TAG_NAME :
        chopQuotes(&value);
        this->setName(&value);
        break;
      case TAG_SUBTAG :
	if((db_file.length() != 0)&&(name.length() != 0)) {
	  this->pushBackSubTag(&value, tagfront, tagback,
			       this->getDatabaseKey(), db_file, db_type);
	} else {
	  this->pushBackSubTag(new wsSubTag(&value, &tagback, &tagfront));
	}
        break;
      case UNKNOWN :
      default :
        __wsmake_print_error("unknown subtaggroup tag skipped (line %d): %s\n",
			     line,tag.c_str());
	return 0;
        break;
      }
    }
  }
  return 1;
}

int wsSubTagGroup::pushBackSubTag(wsSubTag *subtag)
{
  if(subtag == NULL) {
    return 0;
  }

  subtag_list->pushBackSubTag(subtag);

  return 1;

}

int wsSubTagGroup::pushBackSubTag(const string *value,
				  const string tagfront,
				  const string tagback,
				  const string db_key,
				  const string db_file, int db_type)
{
  return subtag_list->pushBackSubTag(value, tagfront, tagback, db_key,
				     db_file, db_type);
}

void wsSubTagGroup::print(void) const
{
  __wsmake_print(3,"  SubTag Group\n");
  __wsmake_print(3,"  ============\n");
  __wsmake_print(3,"    Name     : %s\n", this->getName().c_str());
  __wsmake_print(3,"    Subtags  : ");
  if(__wsmake_get_level() >= 3) {
    subtag_list->print();
  }
  __wsmake_print(3,"\n");
  __wsmake_print(3,"  ============\n");
}

void wsSubTagGroup::printName(void) const
{
  __wsmake_print("%s", this->getName().c_str());
}
