/* $Id: wsSubTag.h,v 1.1 2001/05/30 13:38:55 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSSUBTAG_H__
#define __WSSUBTAG_H__ 1

#include <string>

#include "wsDBObject.h"
#include "wsUtil.h"
#include "wsmake.h"

#define MAX_ARGS 256

namespace std
{
  class wsSubTag : public wsDBObject
  {
  public:
    wsSubTag();
    wsSubTag(const string *);
    wsSubTag(const string *, const string *, const string *);
    wsSubTag(const string *, const string *, const string *, int);
    wsSubTag(const string *, const string *, const string *,
	     const string *, const string *, int);
    wsSubTag(const string *, const string *);
    virtual ~wsSubTag();

    int load(const string *);
    int load(const string *, const string *);
    int load(const string *, const string *, const string *);
    int load(const string *, const string *, const string *, const string *);

    int sync(int);
    int dump(ostream *);
    int parse(string *);

    inline bool isUpdated() const
    { return (update == 1)?true:false; }

    void print(void) const;
    void print(int) const;

    inline bool operator==(const string st) const
    { return (st.compare(this->name) == 0)?true:false; }
    inline bool operator==(const wsSubTag* st) const
    { return (st->name.compare(this->name) == 0)?true:false; }
    inline wsSubTag *operator=(const string st)
    { this->load(&st); return this; }

    inline wsSubTag *operator=(const wsSubTag *st)
    {
      this->setName(st->name);
      this->setTag(st->tag);
      this->setValue(st->value);
      return this;
    }

  protected:
    inline void setName(string name)
    { this->name.assign(name); }

    void setTag(string);
    void setValue(string);

    inline virtual string getDatabaseKey(void) const
    { return prefix + ":" KEY_SUBTAG + name; }

  private:
    bool isCommand(string);
    void splitCommand(void);

    int command;
    bool update;
    char *split_buff;
    char *argv[MAX_ARGS];
    string prefix;
    string name;
    string tag;
    string value;
    string command_output;
  };
}

#endif /* __WSSUBTAG_H__ */
