/* $Id: wsPageOrderList.h,v 1.1 2001/05/30 13:38:55 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSPAGEORDERLIST_H__
#define __WSPAGEORDERLIST_H__ 1

#include "wsUtil.h"
#include "wsPageOrder.h"

namespace std
{
  class wsPageOrderList
  {
  public:
    wsPageOrderList();
    ~wsPageOrderList();

    int free(void);
    int sync(int);
    int make(void);

    int pushBackPageOrder(wsPageOrder *);
    int pushFrontPageOrder(wsPageOrder *);

    void print(void) const;
    void printSyncs(void) const;
    void printNames(void) const;

    wsPageOrder *findPageOrderWithName(const string);

    bool isUpdated(void) const;

    int setPageList(wsPageList *, wsPageList *);

    wsPageOrderList *operator+=(wsPageOrderList *);

  protected:
    int havePageOrderWithName(const string);

  private:
    static int count;
    list< wsPageOrder * >pageorderlist;
  };
}

#endif /* __WSPAGEORDERLIST_H__ */
