/* $Id: wsPageOrderList.cpp,v 1.1 2001/05/30 13:38:55 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsPageOrderList.h"

using namespace std;

wsPageOrderList::wsPageOrderList()
{
  DBGPRINT(("O:created: wsPageOrderList\n"));
}

wsPageOrderList::~wsPageOrderList()
{
  DBGPRINT(("O:destroyed: wsPageOrderList\n"));
}

int wsPageOrderList::free(void)
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    delete (*i);

  return 1;
}

int wsPageOrderList::sync(int force)
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    (*i)->sync(force);

  return 1;
}

int wsPageOrderList::make(void)
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    if(!(*i)->make())
      return 0;

  return 1;
}

bool wsPageOrderList::isUpdated(void) const
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    if((*i)->isUpdated())
      return true;

  return false;
}

int wsPageOrderList::setPageList(wsPageList *prepend, wsPageList *append) 
{
  list< wsPageOrder * >::const_iterator i;
  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    if(!(*i)->addToLists(prepend, append))
      return 0;

  return 1;
}

int wsPageOrderList::pushBackPageOrder(wsPageOrder *pageorder)
{
  if(pageorder == NULL) {
    return 0;        // Tried to insert a null pageorder
  }

  if(this->havePageOrderWithName(pageorder->getName())) {
    __wsmake_print_error("pageorder with name `%s' already defined\n",
			 pageorder->getName().c_str());
    return 0;
  }

  pageorderlist.push_back(pageorder);
  return 1;
}

int wsPageOrderList::pushFrontPageOrder(wsPageOrder *pageorder)
{
  if(pageorder == NULL) {
    return 0;        // Tried to insert a null pageorder
  }

  if(this->havePageOrderWithName(pageorder->getName())) {
    __wsmake_print_error("pageorder with name `%s' already defined\n",
			 pageorder->getName().c_str());
    return 0;
  }

  pageorderlist.push_front(pageorder);
  return 1;
}

wsPageOrder *wsPageOrderList::findPageOrderWithName(const string name)
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    if((*i)->nameIs(name))
      return (*i);

  return 0;
}

int wsPageOrderList::havePageOrderWithName(const string name)
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    if((*i)->nameIs(name))
      return 1;

  return 0;
}

wsPageOrderList *wsPageOrderList::operator+=(wsPageOrderList *append_list)
{
  list< wsPageOrder * >::const_iterator i;
  for(i=append_list->pageorderlist.begin();
      i!=append_list->pageorderlist.end();++i)
    this->pushBackPageOrder(*i);

  return this;
}

void wsPageOrderList::print(void) const
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    (*i)->print();
}

void wsPageOrderList::printSyncs(void) const
{
  list< wsPageOrder * >::const_iterator i;

  for(i=pageorderlist.begin();i!=pageorderlist.end();++i)
    (*i)->printSync();
}

void wsPageOrderList::printNames(void) const
{
  list< wsPageOrder * >::const_iterator i;

  __wsmake_print("[ ");
  for(i=pageorderlist.begin();i!=pageorderlist.end();++i) {
    (*i)->printName();
    __wsmake_print(" ");
  }
  __wsmake_print("]");
}
