/* $Id: wsPageOrder.h,v 1.1 2001/05/30 13:38:56 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSPAGEORDER_H__
#define __WSPAGEORDER_H__ 1

#include "wsPageList.h"

namespace std
{
  class wsPageOrder
  {
  public:
    wsPageOrder(ifstream *, wsPageList *);
    ~wsPageOrder(void);

    int load(ifstream *, wsPageList *);
    int sync(int);
    int make(void);
    int dump(ofstream *);
    void print(void) const;
    void printName(void) const;
    void printSync(void) const;

    inline string getName(void) const
    { return name; }

    inline int nameIs(string name) const
    { return (this->name.compare(name) == 0)?1:0; }

    inline bool isUpdated(void) const
    { return updated; }

    int addToLists(wsPageList *, wsPageList *);

  protected:
    inline void setName(const string *name)
    { this->name.assign(*name); }

    int getPageOrderID(const string *);

    int pushBackPrepend(wsPage *);
    int pushBackAppend(wsPage *);

  private:
    string name;
    bool updated;
    wsPageList *prepend_list;
    wsPageList *append_list;
  };
}

#endif /* __WSPAGEORDER_H__ */
