/* $Id: wsPageOrder.cpp,v 1.1 2001/05/30 13:38:56 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsPageOrder.h"
#include "wsUtil.h"
#include "wsmake.h"

using namespace std;

wsPageOrder::wsPageOrder(ifstream *config, wsPageList *page_list)
  : updated(false)
{
  prepend_list = new wsPageList();
  append_list = new wsPageList();

  this->load(config, page_list);

  DBGPRINT(("O:created: wsPageOrder\n"));
}

wsPageOrder::~wsPageOrder(void)
{
  delete prepend_list;
  delete append_list;

  DBGPRINT(("O:destroyed: wsPageOrder\n"));
}

int wsPageOrder::getPageOrderID(const string *tag)
{
  if(strcmp(tag->c_str(),"name") == 0)
    return TAG_NAME;
  else if(strcmp(tag->c_str(),"part") == 0)
    return TAG_PART;
  else if(strcmp(tag->c_str(),"data") == 0)
    return TAG_DATA;

  return UNKNOWN;
}

int wsPageOrder::load(ifstream *config, wsPageList *page_list)
{
  string buff;
  string tag;
  string value;
  int done = 0,prepend = 1;
  int line = 0;

  while((!done) && (line=getNextConfigLine(config, &buff))!=0) {
    splitString(&tag, &value, &buff);

    if(tag.find("}") != string::npos) {
      done = 1;
    } else {
      switch(this->getPageOrderID(&tag)) {
      case TAG_NAME :
        chopQuotes(&value);
        this->setName(&value);
        break;
      case TAG_PART :
        chopQuotes(&value);
	if(page_list->hasPageWithName(&value)) {
	  if(prepend)
	    this->pushBackPrepend(page_list->findPageWithName(&value));
	  else
	    this->pushBackAppend(page_list->findPageWithName(&value));
	} else {
	  __wsmake_print_error("part `%s' referecned on line %d was not found, "
			       "reference discarded\n",
			       value.c_str(),line);
	}
        break;
      case TAG_DATA :
        prepend=0;
        break;
      default : break;
      }
    }
  }

  return 1;
}

int wsPageOrder::sync(int force)
{
  DBGPRINT(("S: syncing wsPageOrder `%s'\n", name.c_str()));

  if(prepend_list->sync(force)) {
    updated = true;
  }
  if(append_list->sync(force)) {
    updated = true;
  }

  return 1;
}

int wsPageOrder::make(void)
{
  if(prepend_list->make() == 0) return 0;
  if(append_list->make() == 0) return 0;
  
  return 1;
}

int wsPageOrder::addToLists(wsPageList *prepend, wsPageList *append)
{
  if(!prepend_list->prepend(prepend))
    return 0;

  if(!append_list->append(append))
    return 1;

  return 1;
}

int wsPageOrder::pushBackPrepend(wsPage *page)
{
  if(!page) {
    return 0;
  }

  prepend_list->pushBackPage(page);

  return 1;
}

int wsPageOrder::pushBackAppend(wsPage *page)
{
  if(!page) {
    return 0;
  }

  append_list->pushBackPage(page);

  return 1;
}

void wsPageOrder::print(void) const
{
  __wsmake_print(3,"  PageOrder\n");
  __wsmake_print(3,"  =========\n");
  __wsmake_print(3,"    Name  : %s\n", name.c_str());
  __wsmake_print(3,"    Order : ");
  if(__wsmake_get_level() >= 3) {
    prepend_list->printWebPaths();
    __wsmake_print(" [data] ");
    append_list->printWebPaths();
  }
  __wsmake_print(3,"\n");
  __wsmake_print(3,"  =========\n");
}

void wsPageOrder::printName(void) const
{
  __wsmake_print("%s", getName().c_str());
}

void wsPageOrder::printSync(void) const
{
  prepend_list->printSyncs();
  append_list->printSyncs();
}
