/* $Id: wsPageList.h,v 1.1 2001/05/30 13:38:56 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSPAGELIST_H__
#define __WSPAGELIST_H__ 1

#include <list>
#include <string>

#include "wsPage.h"

namespace std
{
  class wsPageList
  {
  public:
    wsPageList();
    ~wsPageList();

    int free(void);
    int sync(int);
    int make(void);
    int make(list< string >, int);
    int make(ofstream *);
    int clean(void);
    int clean(list< string >, int);

    int pushBackPage(wsPage *);
    int pushFrontPage(wsPage *);

    void print(void) const;
    void printSyncs(void) const;
    void printWebPaths(void) const;

    int hasPageWithName(const string *);
    wsPage *findPageWithName(const string *);

    int prepend(wsPageList *);
    int append(wsPageList *);

  private:
    list< wsPage * >pagelist;
  };
}

#endif /* __WSPAGELIST_H__ */
