/* $Id: wsPageList.cpp,v 1.1 2001/05/30 13:38:55 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsPageList.h"
#include "wsUtil.h"
#include "wsmake.h"

using namespace std;

wsPageList::wsPageList()
{
  DBGPRINT(("O:created: page list\n"));
}

wsPageList::~wsPageList()
{
  DBGPRINT(("O:destroyed: page list\n"));
}

int wsPageList::free(void)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    delete (*i);

  return 1;
}

int wsPageList::sync(int force)
{
  list< wsPage * >::const_iterator i;
  int updated = 0;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    if((*i)->sync(force))
      updated = 1;

  return updated;
}

int wsPageList::make(void)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    if(!(*i)->make())
      return 0;

  return 1;
}

int wsPageList::make(list< string > targets, int matchtype)
{
  list< wsPage * >::const_iterator i;
  list< string >::const_iterator s;

  switch(matchtype) {
  case MATCH_BEG :
    for(i=pagelist.begin();i!=pagelist.end();++i)
      for(s=targets.begin();s!=targets.end();++s)
	if((*i)->nameBegins(new string(*s)))
	  if(!(*i)->make())
	    return 0;
    break;
  case MATCH_END :
    for(i=pagelist.begin();i!=pagelist.end();++i)
      for(s=targets.begin();s!=targets.end();++s)
	if((*i)->nameEnds(new string(*s)))
	  if(!(*i)->make())
	    return 0;
    break;
  case MATCH_SUB :
    for(i=pagelist.begin();i!=pagelist.end();++i)
      for(s=targets.begin();s!=targets.end();++s)
	if((*i)->nameHas(new string(*s)))
	  if(!(*i)->make())
	    return 0;
    break;
  }

  return 1;
}

int wsPageList::clean(void)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    if(!(*i)->clean())
      return 0;

  return 1;
}

int wsPageList::clean(list< string > targets, int matchtype)
{
  list< wsPage * >::const_iterator i;
  list< string >::const_iterator s;

  switch(matchtype) {
  case MATCH_BEG :
    for(i=pagelist.begin();i!=pagelist.end();++i)
      for(s=targets.begin();s!=targets.end();++s)
	if((*i)->nameBegins(new string(*s)))
	  if(!(*i)->clean())
	    return 0;
    break;
  case MATCH_END :
    for(i=pagelist.begin();i!=pagelist.end();++i)
      for(s=targets.begin();s!=targets.end();++s)
	if((*i)->nameEnds(new string(*s)))
	  if(!(*i)->clean())
	    return 0;
    break;
  case MATCH_SUB :
    for(i=pagelist.begin();i!=pagelist.end();++i)
      for(s=targets.begin();s!=targets.end();++s)
	if((*i)->nameHas(new string(*s)))
	  if(!(*i)->clean())
	    return 0;
    break;
  }

  return 1;
}

int wsPageList::make(ofstream *out)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    if(!(*i)->make(out))
      return 0;

  return 1;
}

int wsPageList::pushBackPage(wsPage *page)
{
  if(!page) {
    return 0;        // Tried to insert a null page
  }

  pagelist.push_back(page);

  return 1;
}

int wsPageList::pushFrontPage(wsPage *page)
{
  if(!page) {
    return 0;        // Tried to insert a null page
  }

  pagelist.push_front(page);

  return 1;
}

int wsPageList::prepend(wsPageList *prepend_list)
{
  list< wsPage * >::reverse_iterator i;

  for(i=pagelist.rbegin();i!=pagelist.rend();++i)
    prepend_list->pushFrontPage((*i));

  return 1;
}

int wsPageList::append(wsPageList *append_list)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    append_list->pushBackPage((*i));

  return 1;
}

void wsPageList::print(void) const
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    (*i)->print();
}

void wsPageList::printSyncs(void) const
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    (*i)->printSync();
}

void wsPageList::printWebPaths(void) const
{
  list< wsPage * >::const_iterator i;

  __wsmake_print("[ ");
  for(i=pagelist.begin();i!=pagelist.end();++i) {
    (*i)->printWebPath();
    __wsmake_print(" ");
  }
  __wsmake_print("]");
}

int wsPageList::hasPageWithName(const string *name)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    if((*i)->nameIs(name))
      return 1;

  return 0;
}

wsPage *wsPageList::findPageWithName(const string *name)
{
  list< wsPage * >::const_iterator i;

  for(i=pagelist.begin();i!=pagelist.end();++i)
    if((*i)->nameIs(name))
      return (*i);

  return 0;
}
