/* $Id: wsPageGroupList.cpp,v 1.1 2001/05/30 13:38:56 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsPageGroupList.h"
#include "wsUtil.h"

using namespace std;

wsPageGroupList::wsPageGroupList()
{
  DBGPRINT(("O:created: wsPageGroupList\n"));
}

wsPageGroupList::~wsPageGroupList()
{
  DBGPRINT(("O:destroyed: wsPageGroupList\n"));
}

int wsPageGroupList::free(void)
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    delete (*i);

  return 1;
}

int wsPageGroupList::sync(int force)
{
  list< wsPageGroup * >::const_iterator i;
  int updated = 0;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    if((*i)->sync(force)) updated = 1;

  return updated;
}

int wsPageGroupList::make(void)
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    if((*i)->make() == 0)
      return 0;

  return 1;
}

int wsPageGroupList::make(list< string > targets, int matchtype)
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    if((*i)->make(targets, matchtype) == 0)
      return 0;

  return 1;
}

int wsPageGroupList::clean(void)
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    if((*i)->clean() == 0)
      return 0;

  return 1;
}

int wsPageGroupList::clean(list< string > targets, int matchtype)
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    if((*i)->clean(targets, matchtype) == 0)
      return 0;

  return 1;
}

int wsPageGroupList::pushBackPageGroup(wsPageGroup *pagegroup)
{
  if(!pagegroup) {
    return 0;        // Tried to insert a null pagegroup
  }

  pagegrouplist.push_back(pagegroup);

  return 1;
}

int wsPageGroupList::pushFrontPageGroup(wsPageGroup *pagegroup)
{
  if(!pagegroup) {
    return 0;        // Tried to insert a null pagegroup
  }

  pagegrouplist.push_front(pagegroup);

  return 1;
}

int wsPageGroupList::prepend(wsPageGroupList *prepend_list)
{
  list< wsPageGroup * >::reverse_iterator i;

  for(i=pagegrouplist.rbegin();i!=pagegrouplist.rend();++i)
    prepend_list->pushFrontPageGroup((*i));

  return 1;
}

int wsPageGroupList::append(wsPageGroupList *append_list)
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    append_list->pushBackPageGroup((*i));

  return 1;
}

int wsPageGroupList::numPages(void) const
{
  list< wsPageGroup * >::const_iterator i;
  int pages = 0;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    pages+=(*i)->numPages();

  return pages;
}

void wsPageGroupList::print(void) const
{
  list< wsPageGroup * >::const_iterator i;

  for(i=pagegrouplist.begin();i!=pagegrouplist.end();++i)
    (*i)->print();
}
