/* $Id: wsPageGroup.h,v 1.3 2001/09/01 21:32:09 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSPAGEGROUP_H__
#define __WSPAGEGROUP_H__ 1

#include <fstream>
#include <list>
#include <string>

#include "dba.h"

namespace std {
  class wsDependList;
  class wsPageList;
  class wsPageOrder;
  class wsPageOrderList;
  class wsSubTagList;
  class wsSubTagGroup;
  class wsSubTagGroupList;
  class wsTheme;
  class wsThemeList;

  class wsPageGroup
  {
    friend class wsDepend;
    friend class wsPagePart;
    friend class wsTheme;
    friend class wsWebPage;

  public:
    wsPageGroup(string, ifstream *, int);
    ~wsPageGroup(void);
 
    int load(ifstream *);
    int sync(int);
    int make(void);
    int make(list<string>, int);
    int clean(void);
    int clean(list<string>, int);
    int dump(ofstream *);
 
    void print(void) const;
    void printSyncResults(void) const;
    void printStatType(int);

    inline int numPages(void) const
    { return num_pages; }

    wsSubTagGroup *findSubTagGroupWithName(string);
    wsPageOrder *findPageOrderWithName(string);
    wsTheme *findThemeWithName(string);

    int parseSubtags(string *);
    void useTags(wsSubTagList *, wsSubTagGroupList *,
		 wsThemeList *, wsSubTagList *);

    inline bool usingSourceTimestamp(void)
    { return use_source_timestamp; }
 
  protected:
    int getPageGroupTagID(const string *);

    void setSubTagFormat(string);

    inline void setSourceDir(string source_dir)
    { this->source_dir.assign(source_dir); }
    inline void setOutputDir(string output_dir)
    { this->output_dir.assign(output_dir); }
    inline void setPartDir(string part_dir)
    { this->part_dir.assign(part_dir); }
    inline void setIncludeDir(string include_dir)
    { this->include_dir.assign(include_dir); }
    inline void setCommand(string command)
    { this->command.assign(command); }
    inline void setOptions(string options)
    { this->options.assign(options); }
    inline void setTimeFormat(string time_format)
    { this->time_format.assign(time_format); }
    inline void setTimes(int times)
    { this->times = times; }

    inline string getSourceDir(void) const
    { return source_dir; }
    inline string getOutputDir(void) const
    { return output_dir; }
    inline string getPartDir(void) const
    { return part_dir; }
    inline string getIncludeDir(void) const
    { return include_dir; }
    inline string getCommand(void) const
    { return command; }
    inline string getOptions(void) const
    { return options; }
    inline string getDatabaseFilename(void) const
    { return database_filename; }
    inline int getDatabaseFormat(void) const
    { return database_format; }
    inline string getConfigDir(void) const
    { return config_dir; }
    inline string getTimeFormat(void) const
    { return time_format; }
    inline int getTimes(void) const
    { return times; }
    inline string getSubTagTagFront(void) const
    { return subtag_tagfront; }
    inline string getSubTagTagBack(void) const
    { return subtag_tagback; }
  
  private:
    int validIncludeTag(void);
    void setConfigDir(string);

    int    num_pages;
    int    database_format;
    int    times;
    bool   use_source_timestamp;
    string database_filename;
    string config_dir;
    string source_dir;
    string output_dir;
    string part_dir;
    string include_dir;
    string command;
    string options;
    string time_format;
    string subtag_format;
    string subtag_tagfront;
    string subtag_tagback;
    string lastmod_tagname;
    string wsmake_version_tagname;
    string wsmake_cvsid_tagname;
    string output_page_tagname;
    string source_tagname;
    string output_tagname;
    string include_tagname;
    string include_tagfront;
    string include_tagback;
    string header_tagname;
    string footer_tagname;

    wsDependList      *depend_list;
    wsPageList        *pagepart_list;
    wsPageOrderList   *pageorder_list;
    wsSubTagGroupList *subtaggroup_list;
    wsThemeList       *theme_list;
    wsPageList        *page_list;
    wsSubTagList      *use_page_list;
    wsSubTagList      *use_internal_list;
    wsSubTagGroupList *use_group_list;
    wsThemeList       *use_theme_list;
  };
}

#endif /* __WSPAGEGROUP_H__ */
